/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block.entity;

import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.msrandom.witchery.block.BlockDreamWeaver;
import net.msrandom.witchery.config.WitcheryConfigOptions;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.init.WitcheryTransformations;
import net.msrandom.witchery.util.WitcheryUtils;

public class TileEntityDreamWeaver
extends TileEntity
implements ITickable {
    private boolean buffIfDay;
    private boolean buffIfNight;

    public void update() {
        if (!this.world.isRemote) {
            if (this.buffIfDay || this.buffIfNight) {
                boolean day = this.world.isDaytime();
                if (this.buffIfDay && day || this.buffIfNight && !day) {
                    boolean isDream = true;
                    boolean isEnhanced = false;
                    int r = 5;
                    boolean done = false;
                    for (int y = this.getPos().getY() - r; y <= this.getPos().getY() + r && !done; ++y) {
                        for (int x = this.getPos().getX() - r; x <= this.getPos().getX() + r && !done; ++x) {
                            for (int z = this.getPos().getZ() - r; z <= this.getPos().getZ() + r && !done; ++z) {
                                Block block;
                                BlockPos pos = new BlockPos(x, y, z);
                                if (y == this.getPos().getY() && x == this.getPos().getX() && z == this.getPos().getZ() || !((block = this.world.getBlockState(pos).getBlock()) instanceof BlockDreamWeaver)) continue;
                                if (((BlockDreamWeaver)block).getModifier() == BlockDreamWeaver.Modifier.CAUSES_NIGHTMARES) {
                                    isDream = false;
                                    done = isEnhanced;
                                    continue;
                                }
                                if (((BlockDreamWeaver)block).getModifier() != BlockDreamWeaver.Modifier.ENHANCED_DREAMS) continue;
                                isEnhanced = true;
                                done = !isDream;
                            }
                        }
                    }
                    AxisAlignedBB bounds = new AxisAlignedBB(this.getPos().add(-5, -5, -5), this.getPos().add(5, 5, 5));
                    List list2 = this.world.getEntitiesWithinAABB(EntityPlayer.class, bounds);
                    for (EntityPlayer player : list2) {
                        PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
                        if ((!day || playerEx.isTransformation(WitcheryTransformations.VAMPIRE)) && (day || !playerEx.isTransformation(WitcheryTransformations.VAMPIRE))) continue;
                        ((BlockDreamWeaver)this.getBlockType()).applyEffect(player, isDream, isEnhanced);
                    }
                }
                this.buffIfNight = false;
                this.buffIfDay = false;
            }
            if (this.areAllPlayersAsleep(this.world)) {
                this.buffIfDay = !this.world.provider.isDaytime();
                this.buffIfNight = !this.buffIfDay;
            }
        }
    }

    private boolean areAllPlayersAsleep(World world) {
        Iterator iterator = world.playerEntities.iterator();
        int sleepThreshold = MathHelper.floor((float)(0.01f * (float)WitcheryConfigOptions.percentageOfPlayersSleepingForBuff * (float)world.playerEntities.size()));
        while (iterator.hasNext()) {
            EntityPlayer entityplayer = (EntityPlayer)iterator.next();
            if (!entityplayer.isPlayerSleeping() || --sleepThreshold > 0) continue;
            return true;
        }
        return false;
    }
}

