/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block.entity;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.BlockDistillery;
import net.msrandom.witchery.block.entity.TileEntityAltar;
import net.msrandom.witchery.common.IPowerSource;
import net.msrandom.witchery.common.PowerSources;
import net.msrandom.witchery.init.data.recipes.WitcheryRecipeTypes;
import net.msrandom.witchery.init.items.WitcheryFumeItems;
import net.msrandom.witchery.recipe.DistilleryRecipe;
import net.msrandom.witchery.util.BlockUtil;
import net.msrandom.witchery.util.WitcheryUtils;

public class TileEntityDistillery
extends TileEntity
implements ISidedInventory,
ITickable {
    static final int COOK_TIME = 800;
    static final float POWER_PER_TICK = 0.6f;
    private static final int THROTTLE = 20;
    private static final int[] slots_top = new int[]{0, 1, 2};
    private static final int[] slots_bottom = new int[]{0, 1, 2};
    private static final int[] slots_sides = new int[]{0, 1, 2, 3, 4, 5, 6};
    public int currentItemBurnTime;
    public int furnaceCookTime;
    public int powerLevel;
    BlockPos powerSourceCoord;
    private NonNullList<ItemStack> furnaceItemStacks = NonNullList.withSize((int)7, (Object)ItemStack.EMPTY);
    private long ticks;
    private long lastUpdate = 0L;
    private boolean needUpdate = false;

    public int getSizeInventory() {
        return this.furnaceItemStacks.size();
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.furnaceItemStacks) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getStackInSlot(int par1) {
        return (ItemStack)this.furnaceItemStacks.get(par1);
    }

    public ItemStack decrStackSize(int par1, int par2) {
        return ItemStackHelper.getAndSplit(this.furnaceItemStacks, (int)par1, (int)par2);
    }

    public ItemStack removeStackFromSlot(int par1) {
        return ItemStackHelper.getAndRemove(this.furnaceItemStacks, (int)par1);
    }

    public void setInventorySlotContents(int par1, ItemStack par2ItemStack) {
        this.furnaceItemStacks.set(par1, (Object)par2ItemStack);
        if (!par2ItemStack.isEmpty() && par2ItemStack.getCount() > this.getInventoryStackLimit()) {
            par2ItemStack.setCount(this.getInventoryStackLimit());
        }
    }

    public String getName() {
        return this.getBlockType().getLocalizedName();
    }

    public boolean hasCustomName() {
        return true;
    }

    public void readFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readFromNBT(par1NBTTagCompound);
        NBTTagList nbttaglist = par1NBTTagCompound.getTagList("Items", 10);
        this.furnaceItemStacks = NonNullList.withSize((int)this.getSizeInventory(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < nbttaglist.tagCount(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.getCompoundTagAt(i);
            byte b0 = nbttagcompound1.getByte("Slot");
            if (b0 < 0 || b0 >= this.furnaceItemStacks.size()) continue;
            this.furnaceItemStacks.set((int)b0, (Object)new ItemStack(nbttagcompound1));
        }
        this.furnaceCookTime = par1NBTTagCompound.getShort("CookTime");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeToNBT(par1NBTTagCompound);
        par1NBTTagCompound.setShort("CookTime", (short)this.furnaceCookTime);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.furnaceItemStacks.size(); ++i) {
            if (((ItemStack)this.furnaceItemStacks.get(i)).isEmpty()) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.setByte("Slot", (byte)i);
            ((ItemStack)this.furnaceItemStacks.get(i)).writeToNBT(nbttagcompound1);
            nbttaglist.appendTag((NBTBase)nbttagcompound1);
        }
        par1NBTTagCompound.setTag("Items", (NBTBase)nbttaglist);
        return par1NBTTagCompound;
    }

    @Nonnull
    public ITextComponent getDisplayName() {
        return new TextComponentString(this.getName());
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int par1) {
        return this.furnaceCookTime * par1 / 800;
    }

    IPowerSource getPowerSource() {
        if (this.powerSourceCoord == null || this.ticks % 100L == 0L) {
            return this.findNewPowerSource();
        }
        TileEntity tileEntity = this.world.getTileEntity(this.powerSourceCoord);
        if (!(tileEntity instanceof TileEntityAltar)) {
            return this.findNewPowerSource();
        }
        TileEntityAltar altarTileEntity = (TileEntityAltar)tileEntity;
        if (!altarTileEntity.isValid()) {
            return this.findNewPowerSource();
        }
        return altarTileEntity;
    }

    private IPowerSource findNewPowerSource() {
        List<PowerSources.RelativePowerSource> sources = PowerSources.instance().get(this.world, this.pos);
        return sources != null && sources.size() > 0 ? sources.get(0).source() : null;
    }

    public void update() {
        boolean flag1 = false;
        if (!this.world.isRemote) {
            boolean powered;
            boolean cooking = this.furnaceCookTime > 0;
            boolean bl = powered = this.powerLevel > 0;
            if (this.recipeToSmelt() != null) {
                IPowerSource powerSource = this.getPowerSource();
                this.powerSourceCoord = powerSource != null && powerSource.isLocationEqual(this.powerSourceCoord) ? powerSource.getLocation() : null;
                int n = this.powerLevel = powerSource != null ? 1 : 0;
                if (powerSource != null && powerSource.consumePower(0.6f)) {
                    ++this.furnaceCookTime;
                    if (this.furnaceCookTime == 800) {
                        this.furnaceCookTime = 0;
                        this.smeltItem();
                        flag1 = true;
                    }
                } else {
                    this.powerLevel = 0;
                }
            } else {
                if (this.ticks % 40L == 0L) {
                    IPowerSource powerSource = this.getPowerSource();
                    if (powerSource != null && powerSource.isLocationEqual(this.powerSourceCoord)) {
                        this.powerSourceCoord = powerSource.getLocation();
                    }
                    this.powerLevel = powerSource != null ? 1 : 0;
                }
                this.furnaceCookTime = 0;
            }
            if (cooking != this.furnaceCookTime > 0) {
                BlockDistillery.updateDistilleryBlockState(this.furnaceCookTime > 0 && this.powerLevel > 0, this.world, this.getPos());
                this.lastUpdate = this.ticks;
                this.needUpdate = false;
            } else if (powered != this.powerLevel > 0) {
                if (this.ticks - this.lastUpdate > 20L) {
                    BlockDistillery.updateDistilleryBlockState(this.furnaceCookTime > 0 && this.powerLevel > 0, this.world, this.getPos());
                    this.lastUpdate = this.ticks;
                    this.needUpdate = false;
                } else {
                    this.needUpdate = true;
                }
            } else if (this.needUpdate && this.ticks - this.lastUpdate > 20L) {
                BlockDistillery.updateDistilleryBlockState(this.furnaceCookTime > 0 && this.powerLevel > 0, this.world, this.getPos());
                this.lastUpdate = this.ticks;
                this.needUpdate = false;
            }
            if (flag1) {
                BlockUtil.notifyBlockUpdate(this.world, this.getPos());
            }
        }
        ++this.ticks;
    }

    private DistilleryRecipe recipeToSmelt() {
        Optional<DistilleryRecipe> optionalRecipe = this.getActiveRecipe();
        if (!optionalRecipe.isPresent()) {
            return null;
        }
        DistilleryRecipe recipe = optionalRecipe.get();
        NonNullList<ItemStack> itemstacks = recipe.getOutputs();
        for (int i = 0; i < itemstacks.size(); ++i) {
            int newSize;
            ItemStack current = (ItemStack)this.furnaceItemStacks.get(i + 3);
            if (!current.isItemEqual((ItemStack)itemstacks.get(i)) || (newSize = current.getCount() + ((ItemStack)itemstacks.get(i)).getCount()) <= this.getInventoryStackLimit() && newSize <= current.getMaxStackSize()) continue;
            return null;
        }
        return recipe;
    }

    public Optional<DistilleryRecipe> getActiveRecipe() {
        if (((ItemStack)this.furnaceItemStacks.get(0)).isEmpty() && ((ItemStack)this.furnaceItemStacks.get(1)).isEmpty()) {
            return Optional.empty();
        }
        return WitcheryUtils.getRecipeManager(this.world).getRecipe(WitcheryRecipeTypes.DISTILLERY, this, this.world);
    }

    public void smeltItem() {
        DistilleryRecipe recipe = this.recipeToSmelt();
        if (recipe != null) {
            NonNullList<ItemStack> itemstacks = recipe.getOutputs();
            for (int i = 0; i < itemstacks.size(); ++i) {
                int furnaceIndex = i + 3;
                ItemStack stack = (ItemStack)itemstacks.get(i);
                if (stack.isEmpty()) continue;
                if (((ItemStack)this.furnaceItemStacks.get(furnaceIndex)).isEmpty()) {
                    this.furnaceItemStacks.set(furnaceIndex, (Object)stack.copy());
                    continue;
                }
                if (!((ItemStack)this.furnaceItemStacks.get(furnaceIndex)).isItemEqual(stack)) continue;
                ItemStack itemStack = (ItemStack)this.furnaceItemStacks.get(furnaceIndex);
                itemStack.grow(stack.getCount());
            }
            if (!((ItemStack)this.furnaceItemStacks.get(0)).isEmpty()) {
                ItemStack itemStack2 = (ItemStack)this.furnaceItemStacks.get(0);
                itemStack2.shrink(1);
            }
            if (!((ItemStack)this.furnaceItemStacks.get(1)).isEmpty()) {
                ItemStack itemStack3 = (ItemStack)this.furnaceItemStacks.get(1);
                itemStack3.shrink(1);
            }
            if (!((ItemStack)this.furnaceItemStacks.get(2)).isEmpty()) {
                ItemStack itemStack4 = (ItemStack)this.furnaceItemStacks.get(2);
                itemStack4.shrink(recipe.getJars());
            }
        }
    }

    public boolean isUsableByPlayer(EntityPlayer par1EntityPlayer) {
        return this.world.getTileEntity(this.getPos()) == this && par1EntityPlayer.getDistanceSq(this.getPos()) <= 64.0;
    }

    public void openInventory(EntityPlayer player) {
    }

    public void closeInventory(EntityPlayer player) {
    }

    public boolean isItemValidForSlot(int slot, ItemStack itemstack) {
        if (slot > 3) {
            return false;
        }
        if (slot == 2) {
            return itemstack.getItem() == WitcheryFumeItems.CLAY_JAR;
        }
        return itemstack.getItem() != WitcheryFumeItems.CLAY_JAR;
    }

    public int getField(int id) {
        switch (id) {
            case 0: {
                return this.furnaceCookTime;
            }
            case 1: {
                return this.powerLevel;
            }
        }
        return 0;
    }

    public void setField(int id, int value) {
        switch (id) {
            case 0: {
                this.furnaceCookTime = value;
                break;
            }
            case 1: {
                this.powerLevel = value;
            }
        }
    }

    public int getFieldCount() {
        return 2;
    }

    public void clear() {
        this.furnaceItemStacks.clear();
    }

    public int[] getSlotsForFace(EnumFacing side) {
        return side == EnumFacing.DOWN ? slots_bottom : (side == EnumFacing.UP ? slots_top : slots_sides);
    }

    public boolean canInsertItem(int slot, ItemStack itemstack, EnumFacing par3) {
        return this.isItemValidForSlot(slot, itemstack);
    }

    public boolean canExtractItem(int slot, ItemStack itemstack, EnumFacing side) {
        return side != EnumFacing.DOWN && side != EnumFacing.UP && (slot == 3 || slot == 4 || slot == 5 || slot == 6);
    }

    public SPacketUpdateTileEntity getUpdatePacket() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.writeToNBT(nbtTag);
        return new SPacketUpdateTileEntity(this.getPos(), 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet2) {
        super.onDataPacket(net, packet2);
        this.readFromNBT(packet2.getNbtCompound());
        this.world.markBlockRangeForRenderUpdate(this.getPos(), this.getPos());
    }
}

