/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block.entity;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.msrandom.witchery.block.entity.WitcheryTileEntity;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.brewing.ModifiersImpact;
import net.msrandom.witchery.init.data.brewing.WitcheryBrewEffects;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.util.BlockUtil;
import net.msrandom.witchery.util.WitcheryUtils;

public class TileEntityCursedBlock
extends WitcheryTileEntity {
    public NBTTagCompound nbtEffect;
    public int duration;
    public int expansion;
    public int count;
    public UUID thrower;

    public void initialize(ModifiersImpact impactModifiers, NBTTagCompound nbtBrew) {
        if (nbtBrew != null) {
            this.nbtEffect = nbtBrew.copy();
        }
        this.duration = impactModifiers.lifetime.get() >= 0 ? 5 + impactModifiers.lifetime.get() * impactModifiers.lifetime.get() * 5 : 100;
        this.expansion = Math.min(4 + impactModifiers.extent.get(), 10);
        if (impactModifiers.thrower != null) {
            this.thrower = impactModifiers.thrower.getUniqueID();
        }
        this.count = 1;
        BlockUtil.notifyBlockUpdate(this.world, this.getPos());
    }

    public void updateCurse(ModifiersImpact impactModifiers, NBTTagCompound nbtBrew) {
        if (nbtBrew != null) {
            if (this.nbtEffect != null && this.nbtEffect.getTagList("Items", 10).equals((Object)nbtBrew.getTagList("Items", 10))) {
                ++this.count;
            } else {
                this.nbtEffect = nbtBrew;
                this.count = 1;
                this.duration = impactModifiers.lifetime.get() >= 0 ? 5 + impactModifiers.lifetime.get() * impactModifiers.lifetime.get() * 5 : 100;
                this.expansion = Math.min(4 + impactModifiers.extent.get(), 10);
                if (impactModifiers.thrower != null) {
                    this.thrower = impactModifiers.thrower.getUniqueID();
                }
            }
        }
    }

    public SPacketUpdateTileEntity getUpdatePacket() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.writeToNBT(nbtTag);
        return new SPacketUpdateTileEntity(this.getPos(), 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet2) {
        super.onDataPacket(net, packet2);
        this.readFromNBT(packet2.getNbtCompound());
        this.world.markBlockRangeForRenderUpdate(this.getPos(), this.getPos());
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbtRoot) {
        super.writeToNBT(nbtRoot);
        if (this.nbtEffect != null) {
            nbtRoot.setTag("Effect", (NBTBase)this.nbtEffect);
        }
        nbtRoot.setInteger("Duration", this.duration);
        nbtRoot.setInteger("Expansion", this.expansion);
        nbtRoot.setInteger("Count", this.count);
        if (this.thrower != null) {
            nbtRoot.setUniqueId("Creator", this.thrower);
        }
        return nbtRoot;
    }

    public void readFromNBT(NBTTagCompound nbtRoot) {
        super.readFromNBT(nbtRoot);
        if (nbtRoot.hasKey("Effect")) {
            this.nbtEffect = nbtRoot.getCompoundTag("Effect");
        }
        this.duration = nbtRoot.getInteger("Duration");
        this.expansion = nbtRoot.getInteger("Expansion");
        this.count = nbtRoot.getInteger("Count");
        if (nbtRoot.hasUniqueId("Creator")) {
            this.thrower = nbtRoot.getUniqueId("Creator");
        }
    }

    public boolean applyToEntityAndDestroy(Entity entity) {
        if (this.nbtEffect != null && entity instanceof EntityLivingBase) {
            EntityLivingBase living = (EntityLivingBase)entity;
            EntityPlayer player = WitcheryUtils.getPlayer(this.world, this.thrower);
            if (player == null) {
                player = FakePlayerFactory.get((WorldServer)((WorldServer)this.world), (GameProfile)new GameProfile(this.thrower, null));
            }
            WitcheryBrewEffects.applyToEntity(entity.world, living, this.nbtEffect, new ModifiersEffect(1.0, 1.0, false, living.getPositionVector(), false, 0, player));
            living.world.playSound(null, living.getPosition(), SoundEvents.ENTITY_ITEM_PICKUP, SoundCategory.BLOCKS, 0.5f, 0.4f / (living.world.rand.nextFloat() * 0.4f + 0.8f));
            WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(living.posX, living.posY, living.posZ, 1.0f, 1.0f, 0xFFFFFF), (Entity)living);
        }
        return --this.count <= 0;
    }
}

