/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block.entity;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;

public class TileEntityCrystalBall
extends TileEntity {
    private long lastUsedTime = 0L;

    public void onUsed() {
        this.lastUsedTime = this.world.getTotalWorldTime();
    }

    public boolean canBeUsed() {
        return this.world.getTotalWorldTime() - this.lastUsedTime > 100L;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbtTag) {
        super.writeToNBT(nbtTag);
        nbtTag.setLong("LastUsedTime", this.lastUsedTime);
        return nbtTag;
    }

    public void readFromNBT(NBTTagCompound nbtTag) {
        super.readFromNBT(nbtTag);
        this.lastUsedTime = nbtTag.getLong("LastUsedTime");
    }

    public SPacketUpdateTileEntity getUpdatePacket() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.writeToNBT(nbtTag);
        return new SPacketUpdateTileEntity(this.getPos(), 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet2) {
        super.onDataPacket(net, packet2);
        this.readFromNBT(packet2.getNbtCompound());
        this.world.markBlockRangeForRenderUpdate(this.getPos(), this.getPos());
    }
}

