/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block.entity;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.msrandom.witchery.block.BlockCoffin;
import net.msrandom.witchery.init.WitcheryTileEntities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J,\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u0014H\u0002R\u001c\u0010\u0004\u001a\u00020\u00058FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000f\u00a8\u0006!"}, d2={"Lnet/msrandom/witchery/block/entity/TileEntityCoffin;", "Lnet/minecraft/tileentity/TileEntity;", "Lnet/minecraft/util/ITickable;", "()V", "color", "Lnet/minecraft/item/EnumDyeColor;", "getColor", "()Lnet/minecraft/item/EnumDyeColor;", "setColor", "(Lnet/minecraft/item/EnumDyeColor;)V", "lidAngle", "", "getLidAngle", "()F", "setLidAngle", "(F)V", "prevLidAngle", "getPrevLidAngle", "setPrevLidAngle", "shouldRefresh", "", "world", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "oldState", "Lnet/minecraft/block/state/IBlockState;", "newState", "update", "", "updateAngle", "isOpen", "playSound", "WitcheryResurrected"})
public final class TileEntityCoffin
extends TileEntity
implements ITickable {
    private float lidAngle;
    private float prevLidAngle;
    @NotNull
    private EnumDyeColor color = EnumDyeColor.WHITE;

    public final float getLidAngle() {
        return this.lidAngle;
    }

    public final void setLidAngle(float f) {
        this.lidAngle = f;
    }

    public final float getPrevLidAngle() {
        return this.prevLidAngle;
    }

    public final void setPrevLidAngle(float f) {
        this.prevLidAngle = f;
    }

    @NotNull
    public final EnumDyeColor getColor() {
        EnumDyeColor enumDyeColor;
        if (this.hasWorld()) {
            Block block = this.blockType;
            if (block == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.msrandom.witchery.block.BlockCoffin");
            }
            enumDyeColor = ((BlockCoffin)block).getColor();
        } else {
            enumDyeColor = this.color;
        }
        return enumDyeColor;
    }

    public final void setColor(@NotNull EnumDyeColor enumDyeColor) {
        Intrinsics.checkParameterIsNotNull((Object)enumDyeColor, (String)"<set-?>");
        this.color = enumDyeColor;
    }

    public void update() {
        block1: {
            if ((this.getBlockMetadata() & 8) != 0) break block1;
            boolean isOpen = (this.getBlockMetadata() & 4) != 0;
            this.updateAngle(isOpen, true);
            World world = this.world;
            Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"world");
            IBlockAccess iBlockAccess = (IBlockAccess)world;
            BlockPos blockPos = this.pos.offset(EnumFacing.byHorizontalIndex((int)(this.getBlockMetadata() & 3)));
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"pos.offset(EnumFacing.by\u2026x(blockMetadata and 0x3))");
            TileEntityCoffin tileEntityCoffin = WitcheryTileEntities.COFFIN.getAt(iBlockAccess, blockPos);
            if (tileEntityCoffin != null) {
                tileEntityCoffin.updateAngle(isOpen, false);
            }
        }
    }

    private final void updateAngle(boolean isOpen, boolean playSound) {
        this.prevLidAngle = this.lidAngle;
        if (playSound && isOpen && this.lidAngle == 0.0f) {
            this.world.playSound(null, this.pos, SoundEvents.BLOCK_CHEST_OPEN, SoundCategory.BLOCKS, 0.5f, this.world.rand.nextFloat() * 0.1f + 0.9f);
        }
        if (!isOpen && this.lidAngle > 0.0f || isOpen && this.lidAngle < 1.0f) {
            float oldAngle = this.lidAngle;
            this.lidAngle = isOpen ? (this.lidAngle += 0.1f) : (this.lidAngle -= 0.1f);
            this.lidAngle = RangesKt.coerceAtMost((float)this.lidAngle, (float)1.0f);
            if (playSound && this.lidAngle < 0.5f && oldAngle >= 0.5f) {
                this.world.playSound(null, this.pos, SoundEvents.BLOCK_CHEST_CLOSE, SoundCategory.BLOCKS, 0.5f, this.world.rand.nextFloat() * 0.1f + 0.9f);
            }
            this.lidAngle = RangesKt.coerceAtLeast((float)this.lidAngle, (float)0.0f);
        }
    }

    public boolean shouldRefresh(@Nullable World world, @Nullable BlockPos pos, @NotNull IBlockState oldState, @NotNull IBlockState newState) {
        Intrinsics.checkParameterIsNotNull((Object)oldState, (String)"oldState");
        Intrinsics.checkParameterIsNotNull((Object)newState, (String)"newState");
        return Intrinsics.areEqual((Object)oldState.getBlock(), (Object)newState.getBlock());
    }
}

