/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block.entity;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.WitcheryTileEntity;
import net.msrandom.witchery.entity.passive.coven.EntityCovenWitch;
import net.msrandom.witchery.resources.RiteManager;
import net.msrandom.witchery.rite.Rite;
import net.msrandom.witchery.rite.RiteHandler;
import net.msrandom.witchery.rite.RitualCircle;
import net.msrandom.witchery.rite.effect.RiteEffect;
import net.msrandom.witchery.rite.sacrifice.SacrificedItemReturn;
import net.msrandom.witchery.util.BlockUtil;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.Nullable;

public class TileEntityCircle
extends WitcheryTileEntity {
    private static final BlockPos[] COVEN_WITCH_POSITIONS = new BlockPos[]{new BlockPos(-2, 0, -2), new BlockPos(2, 0, -2), new BlockPos(-2, 0, 2), new BlockPos(2, 0, 2), new BlockPos(0, 0, 3), new BlockPos(0, 0, -3)};
    private final List<ActivatedRitual> activeRituals = new ArrayList<ActivatedRitual>();
    private final List<ActivatedRitual> upkeepRituals = new ArrayList<ActivatedRitual>();
    public boolean previousRedstoneState;
    private boolean abortNext;
    public boolean active;

    public NBTTagCompound writeToNBT(NBTTagCompound nbtTag) {
        NBTTagList rituals = new NBTTagList();
        for (ActivatedRitual upkeepRitual : this.upkeepRituals) {
            rituals.appendTag((NBTBase)upkeepRitual.serialize());
        }
        nbtTag.setTag("Rituals", (NBTBase)rituals);
        nbtTag.setBoolean("Active", this.active);
        return super.writeToNBT(nbtTag);
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.upkeepRituals.clear();
        if (tag.hasKey("Rituals")) {
            NBTTagList rituals = tag.getTagList("Rituals", 10);
            for (int i = 0; i < rituals.tagCount(); ++i) {
                ActivatedRitual ritual = ActivatedRitual.deserialize(rituals.getCompoundTagAt(i));
                if (ritual == null) continue;
                this.upkeepRituals.add(ritual);
            }
        }
        this.active = tag.getBoolean("Active");
    }

    @Override
    public void update() {
        super.update();
        if (!this.world.isRemote) {
            List<RiteEffect> effects2;
            if (!this.upkeepRituals.isEmpty()) {
                Iterator<ActivatedRitual> iterator = this.upkeepRituals.iterator();
                while (iterator.hasNext()) {
                    ActivatedRitual upkeepRitual = iterator.next();
                    effects2 = RiteManager.INSTANCE.getEffects(upkeepRitual.rite);
                    RiteHandler.Result result2 = upkeepRitual.currentEffectIndex >= effects2.size() ? RiteHandler.Result.COMPLETED : effects2.get(upkeepRitual.currentEffectIndex).run(this.world, this.getPos(), (int)this.ticks, upkeepRitual.stage, upkeepRitual);
                    switch (result2) {
                        case COMPLETED: {
                            ++upkeepRitual.currentEffectIndex;
                            if (upkeepRitual.currentEffectIndex < effects2.size()) break;
                            iterator.remove();
                            break;
                        }
                        case ABORTED: 
                        case ABORTED_REFUND: {
                            iterator.remove();
                            this.world.playSound(null, this.pos, SoundEvents.BLOCK_NOTE_SNARE, SoundCategory.BLOCKS, 0.5f, 0.4f / (this.world.rand.nextFloat() * 0.4f + 0.8f));
                        }
                    }
                }
            }
            if (!this.activeRituals.isEmpty()) {
                RiteHandler.Result result3;
                ActivatedRitual ritual = this.activeRituals.get(0);
                if (ritual.summoningCoven) {
                    RiteHandler.Result result4 = result3 = this.ticks % 20L == 0L ? EntityCovenWitch.processCovenSummon(ritual.getInitiatingPlayer(this.world), ritual.currentCovenIndex, this.getPos().add((Vec3i)COVEN_WITCH_POSITIONS[ritual.currentCovenIndex++])) : RiteHandler.Result.STARTING;
                    if (result3 == RiteHandler.Result.COMPLETED) {
                        result3 = RiteHandler.Result.STARTING;
                        if (ritual.currentCovenIndex == ritual.covenSize) {
                            ritual.summoningCoven = false;
                        }
                    }
                } else if (ritual.currentSacrificeIndex < ritual.rite.getSacrifices().size()) {
                    if (ritual.sacrificeFail != null && ritual.currentSacrificeIndex == (Integer)ritual.sacrificeFail.getSecond()) {
                        RiteEffect.error((String)ritual.sacrificeFail.getFirst(), ritual.getInitiatingPlayer(this.world));
                        result3 = RiteHandler.Result.ABORTED_REFUND;
                    } else {
                        result3 = ritual.rite.getSacrifices().get(ritual.currentSacrificeIndex).run(this.world, this.getPos(), (int)this.ticks, ritual.stage, ritual);
                        if (result3 == RiteHandler.Result.COMPLETED) {
                            ++ritual.currentSacrificeIndex;
                            result3 = RiteHandler.Result.STARTING;
                        }
                    }
                } else {
                    effects2 = RiteManager.INSTANCE.getEffects(ritual.rite);
                    if (ritual.currentEffectIndex < effects2.size()) {
                        result3 = effects2.get(ritual.currentEffectIndex).run(this.world, this.getPos(), (int)this.ticks, ritual.stage, ritual);
                        if (result3 == RiteHandler.Result.COMPLETED) {
                            ++ritual.currentEffectIndex;
                            if (ritual.currentEffectIndex < effects2.size()) {
                                result3 = RiteHandler.Result.STARTING;
                            }
                        }
                    } else {
                        result3 = RiteHandler.Result.COMPLETED;
                    }
                }
                ritual.postProcess(this.world);
                if (this.abortNext) {
                    this.abortNext = false;
                    result3 = RiteHandler.Result.ABORTED_REFUND;
                    this.activeRituals.clear();
                }
                switch (result3) {
                    case UPKEEP: {
                        if (this.activeRituals.size() > 0) {
                            this.activeRituals.remove(0);
                        }
                        this.upkeepRituals.add(ritual);
                        break;
                    }
                    case COMPLETED: {
                        if (this.activeRituals.size() <= 0) break;
                        this.activeRituals.remove(0);
                        break;
                    }
                    case ABORTED: 
                    case ABORTED_REFUND: {
                        EntityPlayer player;
                        EntityPlayer entityPlayer = player = this.activeRituals.isEmpty() ? null : this.activeRituals.get(0).getInitiatingPlayer(this.world);
                        if (this.activeRituals.size() > 0) {
                            this.activeRituals.remove(0);
                        }
                        if (this.world.isRemote) break;
                        if (player != null) {
                            WitcheryUtils.playSoundAt(player, SoundEvents.BLOCK_NOTE_SNARE, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        }
                        if (result3 != RiteHandler.Result.ABORTED_REFUND) break;
                        for (Long2ObjectMap.Entry entry2 : ritual.sacrificedItems.long2ObjectEntrySet()) {
                            RiteEffect.SacrificedItem sacrificedItem = (RiteEffect.SacrificedItem)entry2.getValue();
                            this.world.spawnEntity((Entity)new EntityItem(this.world, 0.5 + (double)sacrificedItem.getLocation().getX(), 0.5 + (double)sacrificedItem.getLocation().getY(), 0.5 + (double)sacrificedItem.getLocation().getZ(), sacrificedItem.getStack()));
                        }
                        break;
                    }
                }
            }
            if (this.active && this.activeRituals.isEmpty()) {
                this.active = false;
                BlockUtil.notifyBlockUpdate(this.world, this.pos);
            }
        }
    }

    public void deactivate() {
        if (!this.world.isRemote) {
            EntityPlayer player;
            EntityPlayer entityPlayer = player = this.activeRituals.isEmpty() ? null : this.activeRituals.get(0).getInitiatingPlayer(this.world);
            if (this.activeRituals.size() > 0) {
                this.abortNext = true;
            }
            this.upkeepRituals.clear();
            BlockUtil.notifyBlockUpdate(this.world, this.pos);
            if (player != null) {
                WitcheryUtils.playSoundAt(player, SoundEvents.BLOCK_NOTE_SNARE, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    public boolean isRitualActive() {
        return !this.activeRituals.isEmpty() || !this.upkeepRituals.isEmpty();
    }

    public void queueRitual(Rite rite, Pair<String, Integer> failure, AxisAlignedBB bounds, Set<RitualCircle> circles, EntityPlayer player, int covenSize, boolean summonCoven) {
        if (summonCoven) {
            for (EntityCovenWitch witch : this.world.getEntitiesWithinAABB(EntityCovenWitch.class, player.getEntityBoundingBox().grow(64.0, 16.0, 64.0))) {
                if (!witch.isTamed() || witch.getOwner() != player) continue;
                witch.playSound(SoundEvents.ENTITY_ENDERMEN_TELEPORT, 0.5f, 0.4f / (witch.world.rand.nextFloat() * 0.4f + 0.8f));
                this.world.setEntityState((Entity)witch, (byte)16);
                witch.setDead();
            }
        }
        if (!this.world.isRemote) {
            ActivatedRitual ritual = new ActivatedRitual(rite, covenSize, player == null ? null : player.getUniqueID(), this.world.rand.nextLong(), 0, bounds, circles, failure);
            ritual.starter = player;
            ritual.summoningCoven = summonCoven;
            this.activeRituals.add(ritual);
            this.active = true;
            BlockUtil.notifyBlockUpdate(this.world, this.pos);
        }
    }

    public SPacketUpdateTileEntity getUpdatePacket() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.writeToNBT(nbtTag);
        return new SPacketUpdateTileEntity(this.getPos(), 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet2) {
        super.onDataPacket(net, packet2);
        this.handleUpdateTag(packet2.getNbtCompound());
    }

    public static class ActivatedRitual {
        public final UUID playerId;
        public final Long2ObjectMap<RiteEffect.SacrificedItem> sacrificedItems = new Long2ObjectOpenHashMap();
        public final AxisAlignedBB bounds;
        public final Set<RitualCircle> circles;
        public final int covenSize;
        public final Rite rite;
        public final long id;
        private final AtomicInteger stage;
        @Nullable
        private final Pair<String, Integer> sacrificeFail;
        private BlockPos position;
        private EntityPlayer starter;
        private boolean summoningCoven;
        private int currentCovenIndex;
        private int currentSacrificeIndex;
        private int currentEffectIndex;

        private ActivatedRitual(Rite rite, int covenSize, UUID playerId, long id, int stage, AxisAlignedBB bounds, Set<RitualCircle> circles, @Nullable Pair<String, Integer> sacrificeFail) {
            this.rite = rite;
            this.bounds = bounds;
            this.circles = circles;
            this.playerId = playerId;
            this.covenSize = covenSize;
            this.id = id;
            this.stage = new AtomicInteger(stage);
            this.sacrificeFail = sacrificeFail;
        }

        public static ActivatedRitual deserialize(NBTTagCompound tag) {
            Rite rite = RiteManager.INSTANCE.getRiteMap().get(new ResourceLocation(tag.getString("Rite")));
            if (rite != null) {
                ActivatedRitual ritual = new ActivatedRitual(rite, tag.getByte("CovenSize"), tag.getUniqueId("Initiator"), tag.getLong("ID"), tag.getByte("Stage"), ActivatedRitual.readBounds(tag), ActivatedRitual.readCircles(tag), ActivatedRitual.readFailure(tag));
                ritual.position = ActivatedRitual.readPosition(tag);
                ActivatedRitual.readIndices(tag, ritual);
                ritual.summoningCoven = tag.getBoolean("SummoningCoven");
                return ritual;
            }
            return null;
        }

        private static Pair<String, Integer> readFailure(NBTTagCompound tag) {
            if (tag.hasKey("Failure")) {
                NBTTagCompound failure = tag.getCompoundTag("Failure");
                return TuplesKt.to((Object)failure.getString("Error"), (Object)failure.getInteger("SacrificeIndex"));
            }
            return null;
        }

        public UUID getInitiatingPlayerId() {
            return this.playerId;
        }

        public EntityPlayer getInitiatingPlayer(World world) {
            if (this.starter == null) {
                this.starter = WitcheryUtils.getPlayer(world, this.getInitiatingPlayerId());
            }
            return this.starter;
        }

        public void postProcess(World world) {
            ObjectIterator iterator = this.sacrificedItems.long2ObjectEntrySet().iterator();
            while (iterator.hasNext()) {
                SacrificedItemReturn returns;
                RiteEffect.SacrificedItem sacrificedItem = (RiteEffect.SacrificedItem)((Long2ObjectMap.Entry)iterator.next()).getValue();
                if (sacrificedItem == null || (returns = sacrificedItem.getReturns()) == null) continue;
                ItemStack itemStack = returns.handleItem(sacrificedItem.getStack());
                world.spawnEntity((Entity)new EntityItem(world, 0.5 + (double)sacrificedItem.getLocation().getX(), 0.5 + (double)sacrificedItem.getLocation().getY(), 0.5 + (double)sacrificedItem.getLocation().getZ(), itemStack));
                iterator.remove();
                break;
            }
        }

        public int getCurrentStage() {
            return this.stage.get();
        }

        private static BlockPos readPosition(NBTTagCompound tag) {
            if (tag.hasKey("Position")) {
                NBTTagCompound position = tag.getCompoundTag("Position");
                return new BlockPos(position.getInteger("X"), position.getInteger("Y"), position.getInteger("Z"));
            }
            return null;
        }

        private static void readIndices(NBTTagCompound tag, ActivatedRitual ritual) {
            NBTTagCompound indices = tag.getCompoundTag("Indices");
            ritual.currentCovenIndex = indices.getInteger("CovenWitch");
            ritual.currentSacrificeIndex = indices.getInteger("Sacrifice");
            ritual.currentEffectIndex = indices.getInteger("Effect");
        }

        private static AxisAlignedBB readBounds(NBTTagCompound tag) {
            NBTTagCompound bounds = tag.getCompoundTag("Bounds");
            return new AxisAlignedBB(BlockPos.fromLong((long)bounds.getLong("From")), BlockPos.fromLong((long)bounds.getLong("To")));
        }

        private static Set<RitualCircle> readCircles(NBTTagCompound tag) {
            HashSet<RitualCircle> circles = new HashSet<RitualCircle>();
            WitcheryUtils.forEachCompound(tag.getTagList("Circles", 10), (Function1<? super NBTTagCompound, Unit>)((Function1)circleTag -> {
                circles.add(RitualCircle.deserialize(circleTag));
                return Unit.INSTANCE;
            }));
            return circles;
        }

        public BlockPos getLocation() {
            return this.position;
        }

        public void setLocation(BlockPos coord) {
            this.position = coord;
        }

        public NBTTagCompound serialize() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.setString("Rite", this.rite.getId().toString());
            tag.setByte("CovenSize", (byte)this.covenSize);
            tag.setUniqueId("Initiator", this.getInitiatingPlayerId());
            tag.setLong("ID", this.id);
            tag.setByte("Stage", (byte)this.getCurrentStage());
            this.writeBounds(tag);
            this.writeCircles(tag);
            this.writeFailure(tag);
            this.writePosition(tag);
            this.writeIndices(tag);
            tag.setBoolean("SummoningCoven", this.summoningCoven);
            return tag;
        }

        private void writeBounds(NBTTagCompound tag) {
            NBTTagCompound boundsTag = new NBTTagCompound();
            boundsTag.setLong("From", new BlockPos(this.bounds.minX, this.bounds.minY, this.bounds.minZ).toLong());
            boundsTag.setLong("To", new BlockPos(this.bounds.maxX, this.bounds.maxY, this.bounds.maxZ).toLong());
            tag.setTag("Bounds", (NBTBase)boundsTag);
        }

        private void writeCircles(NBTTagCompound tag) {
            NBTTagList circlesList = new NBTTagList();
            for (RitualCircle circle : this.circles) {
                circlesList.appendTag((NBTBase)circle.serialize());
            }
            tag.setTag("Circles", (NBTBase)circlesList);
        }

        private void writeFailure(NBTTagCompound tag) {
            if (this.sacrificeFail != null) {
                NBTTagCompound failure = new NBTTagCompound();
                failure.setString("Error", (String)this.sacrificeFail.getFirst());
                failure.setInteger("SacrificeIndex", ((Integer)this.sacrificeFail.getSecond()).intValue());
                tag.setTag("Failure", (NBTBase)tag);
            }
        }

        private void writePosition(NBTTagCompound tag) {
            if (this.position != null) {
                NBTTagCompound positionTag = new NBTTagCompound();
                positionTag.setInteger("X", this.position.getX());
                positionTag.setInteger("Y", this.position.getY());
                positionTag.setInteger("Z", this.position.getZ());
                tag.setTag("Position", (NBTBase)positionTag);
            }
        }

        private void writeIndices(NBTTagCompound tag) {
            NBTTagCompound indices = new NBTTagCompound();
            indices.setInteger("CovenWitch", this.currentCovenIndex);
            indices.setInteger("Sacrifice", this.currentSacrificeIndex);
            indices.setInteger("Effect", this.currentEffectIndex);
            tag.setTag("Indices", (NBTBase)indices);
        }
    }
}

