/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.msrandom.witchery.block.entity.WaterContainer;
import net.msrandom.witchery.block.entity.WitcheryTileEntity;
import net.msrandom.witchery.brewing.CauldronBrewData;
import net.msrandom.witchery.brewing.EffectLevelCounter;
import net.msrandom.witchery.brewing.RitualStatus;
import net.msrandom.witchery.brewing.action.BrewAction;
import net.msrandom.witchery.brewing.action.BrewActionList;
import net.msrandom.witchery.common.IPowerSource;
import net.msrandom.witchery.common.PowerSources;
import net.msrandom.witchery.entity.EntityLeonard;
import net.msrandom.witchery.entity.passive.coven.EntityCovenWitch;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryFluids;
import net.msrandom.witchery.init.WitcheryPotionEffects;
import net.msrandom.witchery.init.data.brewing.WitcheryBrewEffects;
import net.msrandom.witchery.init.data.recipes.WitcheryRecipeTypes;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.potion.WitcheryPotion;
import net.msrandom.witchery.recipe.CauldronRecipe;
import net.msrandom.witchery.util.EntityUtil;
import net.msrandom.witchery.util.WitcheryUtils;

public class TileEntityCauldron
extends WitcheryTileEntity
implements WaterContainer,
IInventory {
    private static final int TICKS_TO_BOIL = 100;
    private final List<ItemStack> addedStacks = new ArrayList<ItemStack>();
    private CauldronBrewData brewData = new CauldronBrewData();
    private int ticksHeated;
    private boolean powered;
    private int ritualTicks;
    private int power;
    private int fluid;
    private List<CauldronRecipe> recipeCandidates;
    private CauldronRecipe currentRecipe;

    public boolean isBoiling() {
        return this.ticksHeated == 100;
    }

    public boolean isPowered() {
        return this.powered;
    }

    public int getRedstoneSignalStrength() {
        if (!this.isFilled()) {
            return 0;
        }
        if (!this.isBoiling()) {
            return 3;
        }
        if (this.brewData.getEffectCounter().getCount() == 0) {
            return 6;
        }
        if (!this.isPowered()) {
            return 9;
        }
        if (this.brewData.getEffectCounter().remainingCapacity() > 0) {
            return 12;
        }
        return 15;
    }

    @Override
    public void update() {
        super.update();
        if (!this.world.isRemote) {
            boolean sync = false;
            Block blockBelow = this.world.getBlockState(this.getPos().down()).getBlock();
            if (blockBelow == Blocks.FIRE && this.isFilled()) {
                if (this.ticksHeated < 100 && ++this.ticksHeated == 100) {
                    sync = true;
                }
            } else if (this.ticksHeated > 0) {
                this.ticksHeated = 0;
                sync = true;
            }
            if (this.isBoiling() && this.ticks % 20L == 7L) {
                boolean wasPowered = this.powered;
                int power = this.getPower();
                if (power == 0) {
                    this.powered = true;
                } else if (power > 0) {
                    double powerNeeded;
                    IPowerSource source = PowerSources.findClosestPowerSource(this);
                    if (this.fluid == 3000 && this.brewData.isRitualTriggered()) {
                        Block smallCircleGlyph = WitcheryUtils.getCircleGlyph((IBlockAccess)this.world, this.getPos(), 1);
                        Block mediumCircleGlyph = WitcheryUtils.getCircleGlyph((IBlockAccess)this.world, this.getPos(), 3);
                        boolean small = smallCircleGlyph == WitcheryBlocks.GLYPH_RITUAL;
                        boolean smallPower = smallCircleGlyph == WitcheryBlocks.GLYPH_INFERNAL;
                        boolean medium = mediumCircleGlyph == WitcheryBlocks.GLYPH_RITUAL;
                        boolean mediumPower = mediumCircleGlyph == WitcheryBlocks.GLYPH_INFERNAL;
                        double powerScale = 1.4;
                        if (small) {
                            powerScale -= 0.2;
                        }
                        if (medium) {
                            powerScale -= 0.2;
                        }
                        if (smallPower) {
                            powerScale -= 0.37;
                        }
                        if (mediumPower) {
                            powerScale -= 0.37;
                        }
                        powerNeeded = (double)power * powerScale;
                    } else {
                        powerNeeded = power;
                    }
                    this.powered = source != null && powerNeeded <= (double)source.getCurrentPower();
                } else {
                    this.powered = false;
                }
                if (wasPowered != this.powered) {
                    sync = true;
                }
            }
            if (this.ticks % 10L == 8L) {
                int oldRitualTicks = this.ritualTicks++;
                int x = this.getPos().getX();
                int y = this.getPos().getY();
                int z = this.getPos().getZ();
                if (this.isBoiling() && this.isPowered() && this.fluid == 3000) {
                    if (this.brewData.isRitualTriggered()) {
                        int witchCount = 0;
                        List<EntityCovenWitch> covenWitches = EntityUtil.getEntitiesInRadius(EntityCovenWitch.class, this, 6.0);
                        for (EntityCovenWitch witch : covenWitches) {
                            if (witch.getOwner() == null) continue;
                            ++witchCount;
                        }
                        List<EntityPlayer> playerWitches = EntityUtil.getEntitiesInRadius(EntityPlayer.class, this, 6.0);
                        boolean playerCoven = false;
                        for (EntityPlayer player : playerWitches) {
                            if (WitcheryUtils.getExtension((EntityPlayer)player).coven.isEmpty()) continue;
                            if (playerCoven) {
                                ++witchCount;
                                continue;
                            }
                            playerCoven = true;
                        }
                        if (this.ritualTicks > 20) {
                            ItemStack craftedStack = ItemStack.EMPTY;
                            if (this.recipeCandidates != null && this.currentRecipe == null) {
                                for (CauldronRecipe recipeCandidate : this.recipeCandidates) {
                                    craftedStack = recipeCandidate.craft(this);
                                    if (craftedStack.isEmpty()) continue;
                                    this.currentRecipe = recipeCandidate;
                                    break;
                                }
                            }
                            IPowerSource powerSource = PowerSources.findClosestPowerSource(this);
                            int neededPower = this.currentRecipe == null ? this.getPower() : (int)((double)this.currentRecipe.getPower() / 1.4);
                            Block smallCircleGlyph = WitcheryUtils.getCircleGlyph((IBlockAccess)this.world, this.getPos(), 1);
                            Block mediumCircleGlyph = WitcheryUtils.getCircleGlyph((IBlockAccess)this.world, this.getPos(), 3);
                            boolean safePowerIncrease = smallCircleGlyph == WitcheryBlocks.GLYPH_RITUAL;
                            boolean riskyPowerIncrease = smallCircleGlyph == WitcheryBlocks.GLYPH_INFERNAL;
                            boolean safePowerIncrease2 = mediumCircleGlyph == WitcheryBlocks.GLYPH_RITUAL;
                            boolean riskyPowerIncrease2 = mediumCircleGlyph == WitcheryBlocks.GLYPH_INFERNAL;
                            double powerScale = 1.4;
                            if (safePowerIncrease) {
                                powerScale -= 0.2;
                            }
                            if (safePowerIncrease2) {
                                powerScale -= 0.2;
                            }
                            int risk = 0;
                            if (!safePowerIncrease && !safePowerIncrease2) {
                                ++risk;
                            }
                            if (riskyPowerIncrease) {
                                ++risk;
                                powerScale -= 0.37;
                            }
                            if (riskyPowerIncrease2) {
                                ++risk;
                                powerScale -= 0.37;
                            }
                            if (neededPower == 0 || powerSource != null && powerSource.consumePower((int)Math.floor((double)neededPower * powerScale))) {
                                RitualStatus status;
                                boolean leonardPresent = false;
                                for (EntityLeonard leonard : this.world.getEntitiesWithinAABB(EntityLeonard.class, new AxisAlignedBB(this.getPos().add(-16, -16, -16), this.getPos().add(16, 16, 16)))) {
                                    if (leonard.isDead || !(leonard.getHealth() > 1.0f)) continue;
                                    leonardPresent = true;
                                    ++risk;
                                    break;
                                }
                                if (craftedStack.isEmpty() && this.currentRecipe != null) {
                                    craftedStack = this.currentRecipe.craft(this);
                                }
                                if (!craftedStack.isEmpty()) {
                                    EntityItem item = new EntityItem(this.world, (double)this.pos.getX() + 0.5, (double)this.pos.getY() + 1.5, (double)this.pos.getZ() + 0.5, craftedStack);
                                    item.motionX = 0.0;
                                    item.motionY = 0.2;
                                    item.motionZ = 0.0;
                                    this.world.spawnEntity((Entity)item);
                                    status = RitualStatus.success(true);
                                } else {
                                    status = this.currentRecipe == null && this.recipeCandidates != null ? RitualStatus.failure(RitualStatus.Failure.OTHER_FAILURE) : WitcheryBrewEffects.updateRitual(this.world.getMinecraftServer(), this, witchCount, this.ritualTicks - 20, leonardPresent);
                                }
                                switch (status.getType()) {
                                    case ONGOING: {
                                        this.checkForMisfortune(risk, neededPower);
                                        break;
                                    }
                                    case COMPLETE: {
                                        this.world.playSound(null, this.pos, SoundEvents.BLOCK_FIRE_EXTINGUISH, SoundCategory.BLOCKS, 0.5f, 0.4f / (this.world.rand.nextFloat() * 0.4f + 0.8f));
                                        WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.6, (double)this.pos.getZ() + 0.5, 0.5f, 1.0f, EnumParticleTypes.SPELL), this.world, this.pos.getX(), (double)this.pos.getY() + 0.5, this.pos.getZ(), 8.0);
                                        this.drain(this.getLiquidQuantity(), true);
                                        this.ritualTicks = 0;
                                        this.powered = false;
                                        this.ticksHeated = 0;
                                        sync = true;
                                        this.checkForMisfortune(risk, neededPower);
                                        break;
                                    }
                                    case FAILED: {
                                        this.world.playSound(null, this.pos, SoundEvents.ENTITY_ITEM_PICKUP, SoundCategory.BLOCKS, 0.5f, 0.4f / (this.world.rand.nextFloat() * 0.4f + 0.8f));
                                        WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.6, (double)this.pos.getZ() + 0.5, 0.5f, 1.0f, status.getFailure().getColor()), this.world, this.pos.getX(), (double)this.pos.getY() + 0.5, this.pos.getZ(), 8.0);
                                        if (this.recipeCandidates == null) {
                                            this.addedStacks.remove(this.addedStacks.size() - 1);
                                            this.getActions().actions.remove(this.getActions().actions.size() - 1);
                                            this.world.spawnEntity((Entity)new EntityItem(this.world, (double)x, (double)y, (double)z, this.getActions().items.remove(this.getActions().items.size() - 1)));
                                        } else {
                                            ItemStack removedStack = this.addedStacks.remove(this.addedStacks.size() - 1);
                                            if (this.getActions().getTopItemStack() == removedStack) {
                                                this.getActions().actions.remove(this.getActions().actions.size() - 1);
                                                this.getActions().items.remove(this.getActions().items.size() - 1);
                                            }
                                            this.world.spawnEntity((Entity)new EntityItem(this.world, (double)x, (double)y, (double)z, removedStack));
                                        }
                                        this.brewData.setRitualTriggered(false);
                                        this.ritualTicks = 0;
                                        sync = true;
                                    }
                                }
                            } else if (this.ritualTicks > 21) {
                                this.drain(this.getLiquidQuantity(), true);
                                this.ritualTicks = 0;
                                this.powered = false;
                                this.ticksHeated = 0;
                                this.world.playSound(null, this.pos, SoundEvents.ENTITY_ITEM_PICKUP, SoundCategory.BLOCKS, 0.5f, 0.4f / (this.world.rand.nextFloat() * 0.4f + 0.8f));
                                WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.6, (double)this.pos.getZ() + 0.5, 0.5f, 1.0f, -7829504), this.world, this.pos.getX(), (double)this.pos.getY() + 0.5, this.pos.getZ(), 8.0);
                                sync = true;
                            }
                        }
                    }
                } else {
                    if (this.ritualTicks > 20) {
                        this.drain(this.getLiquidQuantity(), true);
                        this.ritualTicks = 0;
                        this.powered = false;
                        this.ticksHeated = 0;
                        this.world.playSound(null, this.pos, SoundEvents.ENTITY_ITEM_PICKUP, SoundCategory.BLOCKS, 0.5f, 0.4f / (this.world.rand.nextFloat() * 0.4f + 0.8f));
                        WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.6, (double)this.pos.getZ() + 0.5, 0.5f, 1.0f, -7829504), this.world, this.pos.getX(), (double)this.pos.getY() + 0.5, this.pos.getZ(), 8.0);
                        sync = true;
                    }
                    this.ritualTicks = 0;
                }
                if (this.ritualTicks != oldRitualTicks) {
                    sync = true;
                }
            }
            if (sync) {
                this.notifyBlockUpdate(true);
            }
        }
    }

    private void checkForMisfortune(int risk, int power) {
        if (risk > 0 && power > 0) {
            double roll = this.world.rand.nextDouble() * (1.0 + (double)(risk - 1) * 0.2);
            if (roll < 0.5) {
                return;
            }
            if (roll < 0.75) {
                this.applyToAllNear(new PotionEffect(MobEffects.SLOWNESS, 1200, 1));
            } else if (roll < 0.9) {
                this.applyToAllNear(new PotionEffect(WitcheryPotionEffects.PARALYSED, 400, 2));
            } else if (roll < 0.98) {
                this.applyToAllNear(new PotionEffect(WitcheryPotionEffects.INSANITY, 3600, 2));
            } else {
                this.applyToAllNear(new PotionEffect(WitcheryPotionEffects.PARALYSED, 200, 2));
                for (int i = 0; i < this.world.rand.nextInt(3) + 2; ++i) {
                    this.spawnBolt(this.world, this.getPos().getX(), this.getPos().getY(), this.getPos().getZ());
                }
            }
        }
    }

    private void applyToAllNear(PotionEffect effect) {
        double R = 16.0;
        double RSq = 256.0;
        AxisAlignedBB bounds = new AxisAlignedBB(this.getPos().add(-R, -R, -R), this.getPos().add(R, R, R));
        List entities = this.world.getEntitiesWithinAABB(EntityLivingBase.class, bounds);
        for (EntityLivingBase entity : entities) {
            if (!(entity.getDistanceSq((double)this.getPos().getX() + 0.5, entity.posY, (double)this.getPos().getZ() + 0.5) < RSq) || entity instanceof IMob || !entity.isNonBoss()) continue;
            ArrayList<Potion> effectsToRemove = new ArrayList<Potion>();
            Collection effects2 = entity.getActivePotionEffects();
            for (PotionEffect buff : effects2) {
                Potion potion = buff.getPotion();
                if (WitcheryPotion.isDebuff(potion)) continue;
                effectsToRemove.add(potion);
            }
            for (Potion potion2 : effectsToRemove) {
                entity.removePotionEffect(potion2);
            }
            entity.addPotionEffect(new PotionEffect(effect));
        }
    }

    private void spawnBolt(World world, int posX, int posY, int posZ) {
        int activeRadius = 3;
        int ax = world.rand.nextInt(activeRadius * 2 + 1);
        if (ax > activeRadius) {
            ax += 2;
        }
        int x = posX - 4 + ax;
        int az = world.rand.nextInt(activeRadius * 2 + 1);
        if (az > activeRadius) {
            az += 2;
        }
        int z = posZ - 4 + az;
        EntityLightningBolt bolt = new EntityLightningBolt(world, (double)x, (double)posY, (double)z, false);
        world.addWeatherEffect((Entity)bolt);
    }

    public boolean isRitualInProgress() {
        return this.ritualTicks > 0;
    }

    public boolean addItem(BrewAction brewAction, ItemStack entityItem) {
        if (this.world.isRemote) {
            return false;
        }
        if (WitcheryBrewEffects.canNotAdd(this, brewAction, this.fluid == 3000)) {
            return false;
        }
        if (brewAction != null) {
            if (!brewAction.removeWhenAddedToCauldron()) {
                this.brewData.getActions().nullifyItems(brewAction);
                this.brewData.getActions().items.add(entityItem);
                this.brewData.getActions().actions.add(brewAction);
                this.power += brewAction.getPowerCost();
                this.brewData.setDrinkingSpeed(this.brewData.getDrinkingSpeed() + brewAction.getDrinkSpeedModifiers());
            }
            if (brewAction.createsSplash()) {
                this.brewData.setSplash(true);
            }
            if (brewAction.lingers()) {
                this.brewData.setLingering(true);
            }
            if (brewAction.triggersRitual()) {
                this.brewData.setRitualTriggered(true);
                this.ritualTicks = 0;
            }
        }
        this.notifyBlockUpdate(true);
        this.addedStacks.add(entityItem);
        List<CauldronRecipe> recipes = WitcheryUtils.getRecipeManager(this.world).getRecipes(WitcheryRecipeTypes.CAULDRON, this, this.world);
        if (!recipes.isEmpty()) {
            this.recipeCandidates = recipes;
            this.brewData.setRitualTriggered(true);
            this.ritualTicks = 0;
        }
        return true;
    }

    public boolean explodeBrew(EntityPlayer nearestPlayer) {
        if (this.world.isRemote || nearestPlayer == null) {
            return false;
        }
        if (!this.isFilled()) {
            return false;
        }
        if (this.brewData.getActions().items.isEmpty()) {
            return false;
        }
        this.world.createExplosion((Entity)nearestPlayer, 0.5 + (double)this.getPos().getX(), 1.5 + (double)this.getPos().getY(), 0.5 + (double)this.getPos().getZ(), Math.min(1.0f + (float)this.brewData.getActions().size() * 0.5f, 10.0f), false);
        return true;
    }

    public int getColor() {
        return WitcheryUtils.getBrewColor(this.getActions().items);
    }

    public int getPower() {
        return this.power;
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{new FluidTankProperties(new FluidStack(this.brewData.getActions().size() > 0 ? WitcheryFluids.BREW : FluidRegistry.WATER, 3000), 3000)};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.isFluidEqual(resource)) {
            int filled = Math.min(resource.amount, 3000);
            if (filled > 3000 - this.fluid) {
                filled = 3000 - this.fluid;
            }
            if (doFill) {
                this.fluid += filled;
                this.notifyBlockUpdate(false);
            }
            return filled;
        }
        return 0;
    }

    private boolean isFluidEqual(FluidStack stack) {
        if (this.canFill(stack.getFluid())) {
            if (stack.tag == null) {
                return this.brewData.getActions().size() == 0;
            }
            NBTTagList items = stack.tag.getTagList("Items", 10);
            if (items.tagCount() != this.brewData.getActions().size()) {
                return false;
            }
            for (int i = 0; i < items.tagCount(); ++i) {
                if (this.brewData.getActions().items.get(i).isItemEqual(new ItemStack(items.getCompoundTagAt(i)))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource == null || !this.isFluidEqual(resource)) {
            return null;
        }
        return this.drain(resource.amount, doDrain);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        int drained = Math.min(maxDrain, this.fluid);
        if (drained > 0) {
            FluidStack stack = new FluidStack(this.brewData.getActions().size() == 0 ? FluidRegistry.WATER : WitcheryFluids.BREW, drained);
            if (doDrain) {
                this.fluid -= stack.amount;
            }
            if (this.fluid <= 0) {
                this.fluid = 0;
                this.powered = false;
                this.ritualTicks = 0;
                this.brewData = new CauldronBrewData();
                this.power = 0;
                this.recipeCandidates = null;
                this.currentRecipe = null;
            }
            this.notifyBlockUpdate(false);
            return stack;
        }
        return null;
    }

    public boolean canFill(Fluid fluid) {
        return fluid != null && (fluid == FluidRegistry.WATER || fluid == WitcheryFluids.BREW);
    }

    public boolean isFilled() {
        return this.fluid > 0;
    }

    public int getLiquidQuantity() {
        return this.fluid;
    }

    public double getPercentFilled() {
        return (double)this.fluid / 3000.0;
    }

    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.getPos(), 1, this.getUpdateTag());
    }

    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet2) {
        super.onDataPacket(net, packet2);
        this.readFromNBT(packet2.getNbtCompound());
        this.world.markBlockRangeForRenderUpdate(this.getPos(), this.getPos());
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.brewData.read(tag);
        this.fluid = tag.getInteger("Fluid");
        this.power = tag.getInteger("Power");
        this.ticksHeated = tag.getInteger("TicksHeated");
        this.powered = tag.getBoolean("Powered");
        this.ritualTicks = tag.getInteger("RitualTicks");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.setInteger("TicksHeated", this.ticksHeated);
        tag.setBoolean("Powered", this.powered);
        tag.setInteger("RitualTicks", this.ritualTicks);
        tag.setInteger("Fluid", this.fluid);
        tag.setInteger("Power", this.power);
        return this.writeFluid(tag);
    }

    public NBTTagCompound writeFluid(NBTTagCompound compound) {
        this.brewData.write(compound);
        return compound;
    }

    public int getRitualSeconds() {
        return this.ritualTicks;
    }

    @Override
    public int getQuantity() {
        return 3000;
    }

    public BrewActionList getActions() {
        return this.brewData.getActions();
    }

    public EffectLevelCounter getEffectCounter() {
        return this.brewData.getEffectCounter();
    }

    public boolean isRitualTriggered() {
        return this.brewData.isRitualTriggered();
    }

    public boolean isSplash() {
        return this.brewData.isSplash();
    }

    public boolean isLingering() {
        return this.brewData.isSplash() && this.brewData.isLingering();
    }

    public int getSizeInventory() {
        return this.addedStacks.size();
    }

    public boolean isEmpty() {
        return this.addedStacks.stream().allMatch(ItemStack::isEmpty);
    }

    public ItemStack getStackInSlot(int index) {
        return this.addedStacks.get(index);
    }

    public ItemStack decrStackSize(int index, int count) {
        return ItemStack.EMPTY;
    }

    public ItemStack removeStackFromSlot(int index) {
        return ItemStack.EMPTY;
    }

    public void setInventorySlotContents(int index, ItemStack stack) {
    }

    public int getInventoryStackLimit() {
        return 1;
    }

    public boolean isUsableByPlayer(EntityPlayer player) {
        return true;
    }

    public void openInventory(EntityPlayer player) {
    }

    public void closeInventory(EntityPlayer player) {
    }

    public boolean isItemValidForSlot(int index, ItemStack stack) {
        for (CauldronRecipe recipe : WitcheryUtils.getRecipeManager(this.world).getRecipesForType(WitcheryRecipeTypes.CAULDRON)) {
            if (!recipe.isItemValid(stack)) continue;
            return true;
        }
        return false;
    }

    public int getField(int id) {
        return 0;
    }

    public void setField(int id, int value) {
    }

    public int getFieldCount() {
        return 0;
    }

    public void clear() {
    }

    @Nonnull
    public ITextComponent getDisplayName() {
        return new TextComponentTranslation(this.getName(), new Object[0]);
    }

    public String getName() {
        return "witchery.cauldron";
    }

    public boolean hasCustomName() {
        return false;
    }

    public ItemStack getTopStack() {
        return this.addedStacks.isEmpty() ? ItemStack.EMPTY : this.addedStacks.get(this.addedStacks.size() - 1);
    }
}

