/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block.entity;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.msrandom.witchery.block.entity.TileEntityAltar;
import net.msrandom.witchery.block.entity.WitcheryTileEntity;
import net.msrandom.witchery.common.IPowerSource;
import net.msrandom.witchery.common.PowerSources;
import net.msrandom.witchery.init.data.recipes.WitcheryRecipeTypes;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.recipe.brazier.BrazierRecipe;
import net.msrandom.witchery.util.BlockUtil;
import net.msrandom.witchery.util.WitcheryUtils;

public class TileEntityBrazier
extends WitcheryTileEntity
implements ISidedInventory {
    private static final float POWER_PER_TICK = 1.0f;
    private static final int SLOT_1 = 0;
    private static final int SLOT_2 = 1;
    private static final int SLOT_3 = 2;
    private static final int SLOT_RESULT = 3;
    private static final int[] slots_top = new int[]{0, 1, 2};
    private static final int[] slots_bottom = new int[]{0, 1, 2};
    private static final int[] slots_sides = new int[]{0, 1, 2};
    private final Set<EntityPlayer> players = new HashSet<EntityPlayer>();
    public boolean previousRedstoneState;
    public int powerLevel;
    private NonNullList<ItemStack> slots = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    private int furnaceCookTime = 0;
    private BlockPos powerSourceCoord;
    private long storage;
    private BrazierRecipe recipe;

    public int getSizeInventory() {
        return this.slots.size();
    }

    public void begin() {
        this.setInventorySlotContents(3, new ItemStack(WitcheryIngredientItems.WOOD_ASH));
    }

    public ItemStack getStackInSlot(int slot) {
        return (ItemStack)this.slots.get(slot);
    }

    public boolean isBurning() {
        for (int i = 0; i < this.getSizeInventory(); ++i) {
            if (!this.getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack decrStackSize(int slot, int quantity) {
        return ItemStackHelper.getAndSplit(this.slots, (int)slot, (int)quantity);
    }

    public boolean isEmpty() {
        for (int slot = 0; slot < 3; ++slot) {
            if (this.getStackInSlot(slot).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public int getIngredientCount() {
        int count = 0;
        for (int slot = 0; slot < 3; ++slot) {
            if (this.getStackInSlot(slot).isEmpty()) continue;
            ++count;
        }
        return count;
    }

    public void reset() {
        for (int slot = 0; slot < this.getSizeInventory(); ++slot) {
            this.setInventorySlotContents(slot, ItemStack.EMPTY);
        }
    }

    public ItemStack removeStackFromSlot(int slot) {
        return ItemStackHelper.getAndRemove(this.slots, (int)slot);
    }

    public void setInventorySlotContents(int slot, ItemStack stack) {
        this.slots.set(slot, (Object)stack);
        if (!stack.isEmpty() && stack.getCount() > this.getInventoryStackLimit()) {
            stack.setCount(this.getInventoryStackLimit());
        }
        this.markDirty();
        WitcheryUtils.getRecipeManager(this.world).getRecipe(WitcheryRecipeTypes.BRAZIER, this, this.world).ifPresent(it -> {
            this.recipe = it;
        });
    }

    public String getName() {
        return this.getBlockType().getLocalizedName();
    }

    public boolean hasCustomName() {
        return true;
    }

    public void readFromNBT(NBTTagCompound nbtRoot) {
        super.readFromNBT(nbtRoot);
        NBTTagList nbtSlotList = nbtRoot.getTagList("Items", 10);
        this.slots = NonNullList.withSize((int)this.getSizeInventory(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < nbtSlotList.tagCount(); ++i) {
            NBTTagCompound nbtSlot = nbtSlotList.getCompoundTagAt(i);
            byte b0 = nbtSlot.getByte("Slot");
            if (b0 < 0 || b0 >= this.slots.size()) continue;
            this.slots.set((int)b0, (Object)new ItemStack(nbtSlot));
        }
        this.furnaceCookTime = nbtRoot.getShort("CookTime");
        this.powerLevel = nbtRoot.getShort("PowerLevel");
        this.storage = nbtRoot.getLong("PowerStorage");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbtRoot) {
        super.writeToNBT(nbtRoot);
        nbtRoot.setShort("CookTime", (short)this.furnaceCookTime);
        nbtRoot.setShort("PowerLevel", (short)this.powerLevel);
        nbtRoot.setLong("PowerStorage", this.storage);
        NBTTagList nbtSlotList = new NBTTagList();
        for (int i = 0; i < this.slots.size(); ++i) {
            if (((ItemStack)this.slots.get(i)).isEmpty()) continue;
            NBTTagCompound nbtSlot = new NBTTagCompound();
            nbtSlot.setByte("Slot", (byte)i);
            ((ItemStack)this.slots.get(i)).writeToNBT(nbtSlot);
            nbtSlotList.appendTag((NBTBase)nbtSlot);
        }
        nbtRoot.setTag("Items", (NBTBase)nbtSlotList);
        return nbtRoot;
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    private IPowerSource getPowerSource() {
        if (this.powerSourceCoord == null || this.ticks % 100L == 0L) {
            return this.findNewPowerSource();
        }
        TileEntity tileEntity = this.world.getTileEntity(this.powerSourceCoord);
        if (!(tileEntity instanceof TileEntityAltar)) {
            return this.findNewPowerSource();
        }
        TileEntityAltar altarTileEntity = (TileEntityAltar)tileEntity;
        if (!altarTileEntity.isValid()) {
            return this.findNewPowerSource();
        }
        return altarTileEntity;
    }

    private IPowerSource findNewPowerSource() {
        List<PowerSources.RelativePowerSource> sources = PowerSources.instance().get(this.world, this.pos);
        return sources != null && sources.size() > 0 ? sources.get(0).source() : null;
    }

    @Override
    public void update() {
        super.update();
        boolean update = false;
        if (!this.world.isRemote) {
            boolean powered;
            boolean bl = powered = this.powerLevel > 0;
            if (this.recipe != null && !this.getStackInSlot(3).isEmpty()) {
                IPowerSource powerSource = this.getPowerSource();
                this.powerSourceCoord = powerSource != null && powerSource.isLocationEqual(this.powerSourceCoord) ? powerSource.getLocation() : null;
                boolean needsPower = this.recipe.getNeedsPower();
                int n = this.powerLevel = !needsPower || powerSource != null ? 1 : 0;
                if (!this.recipe.getNeedsPower() || powerSource != null && powerSource.consumePower(1.0f)) {
                    update = this.furnaceCookTime == 0;
                    ++this.furnaceCookTime;
                    if ((long)this.furnaceCookTime == (long)this.recipe.getBurnTime() + this.storage * 400L) {
                        this.furnaceCookTime = 0;
                        this.recipe.onBurnt(this.world, this.getPos());
                        this.setInventorySlotContents(0, ItemStack.EMPTY);
                        this.setInventorySlotContents(1, ItemStack.EMPTY);
                        this.setInventorySlotContents(2, ItemStack.EMPTY);
                        this.players.forEach(this.recipe::removePlayer);
                        this.players.clear();
                        update = true;
                    } else {
                        for (EntityPlayer player : this.world.getEntitiesWithinAABB(EntityPlayer.class, new AxisAlignedBB((double)(this.pos.getX() - 70), (double)(this.pos.getY() - 68), (double)(this.pos.getZ() - 70), (double)(this.pos.getX() + 70), (double)(this.pos.getY() + 68), (double)(this.pos.getZ() + 70)))) {
                            if (this.players.contains(player)) continue;
                            this.players.add(player);
                            this.recipe.addPlayer(player);
                        }
                        this.storage += (long)this.recipe.onBurning(this.world, this.getPos(), this.ticks);
                        if (this.storage == Long.MAX_VALUE) {
                            this.storage = 0L;
                        }
                    }
                    if (powered != this.powerLevel > 0) {
                        update = true;
                    }
                } else {
                    this.powerLevel = 0;
                    if (powered) {
                        update = true;
                    }
                }
            } else {
                if (!this.getStackInSlot(3).isEmpty()) {
                    this.reset();
                    this.world.playSound(null, this.pos, SoundEvents.BLOCK_FIRE_EXTINGUISH, SoundCategory.BLOCKS, 0.5f, 0.4f / (this.world.rand.nextFloat() * 0.4f + 0.8f));
                    WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)this.getPos().getX() + 0.5, (double)this.getPos().getY() + 1.0, (double)this.getPos().getZ() + 0.5, 0.5f, 0.5f, EnumParticleTypes.SMOKE_NORMAL), this.world, this.pos, 8.0);
                }
                if (this.ticks % 40L == 0L) {
                    IPowerSource powerSource = this.getPowerSource();
                    if (powerSource != null && powerSource.isLocationEqual(this.powerSourceCoord)) {
                        this.powerSourceCoord = powerSource.getLocation();
                    }
                    int n = this.powerLevel = powerSource != null ? 1 : 0;
                }
                update = this.furnaceCookTime > 0 || powered != this.powerLevel > 0;
                this.furnaceCookTime = 0;
            }
        }
        if (update) {
            this.markDirty();
        }
    }

    public void markDirty() {
        super.markDirty();
        if (!this.world.isRemote) {
            BlockUtil.notifyBlockUpdate(this.world, this.getPos());
        }
    }

    public SPacketUpdateTileEntity getUpdatePacket() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.writeToNBT(nbtTag);
        return new SPacketUpdateTileEntity(this.getPos(), 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet2) {
        super.onDataPacket(net, packet2);
        this.readFromNBT(packet2.getNbtCompound());
        this.world.markBlockRangeForRenderUpdate(this.getPos(), this.getPos());
    }

    public boolean isUsableByPlayer(EntityPlayer par1EntityPlayer) {
        return this.world.getTileEntity(this.getPos()) == this && par1EntityPlayer.getDistanceSq(this.getPos()) <= 64.0;
    }

    public void openInventory(EntityPlayer player) {
    }

    public void closeInventory(EntityPlayer player) {
    }

    public boolean isItemValidForSlot(int slot, ItemStack itemstack) {
        return slot != 3 && !itemstack.isEmpty() && itemstack.getCount() == 1 && slot >= 0 && slot < this.slots.size() && ((ItemStack)this.slots.get(slot)).isEmpty();
    }

    public int getField(int id) {
        return 0;
    }

    public void setField(int id, int value) {
    }

    public int getFieldCount() {
        return 0;
    }

    public void clear() {
        this.slots.clear();
    }

    public int[] getSlotsForFace(EnumFacing side) {
        return side == EnumFacing.DOWN ? slots_bottom : (side == EnumFacing.UP ? slots_top : slots_sides);
    }

    public boolean canInsertItem(int slot, ItemStack itemstack, EnumFacing par3) {
        return this.isItemValidForSlot(slot, itemstack);
    }

    public boolean canExtractItem(int slot, ItemStack stack, EnumFacing side) {
        return false;
    }
}

