/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block.entity;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ,\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0016J\u000e\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\nJ\u000e\u0010\u001b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001d"}, d2={"Lnet/msrandom/witchery/block/entity/TileEntityBloodTrap;", "Lnet/minecraft/tileentity/TileEntity;", "()V", "players", "", "Ljava/util/UUID;", "getPlayers", "()Ljava/util/List;", "popUserExcept", "usingPlayer", "Lnet/minecraft/entity/player/EntityPlayer;", "readFromNBT", "", "tag", "Lnet/minecraft/nbt/NBTTagCompound;", "readPlayers", "shouldRefresh", "", "world", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "oldState", "Lnet/minecraft/block/state/IBlockState;", "newState", "storePlayer", "player", "writePlayers", "writeToNBT", "WitcheryResurrected"})
public class TileEntityBloodTrap
extends TileEntity {
    @NotNull
    private final List<UUID> players;

    @NotNull
    public final List<UUID> getPlayers() {
        return this.players;
    }

    public final void storePlayer(@NotNull EntityPlayer player) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        if (!this.world.isRemote && !this.players.contains(player.getUniqueID())) {
            UUID uUID = player.getUniqueID();
            Intrinsics.checkExpressionValueIsNotNull((Object)uUID, (String)"player.uniqueID");
            this.players.add(uUID);
            while (this.players.size() > 3) {
                this.players.remove(0);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final UUID popUserExcept(@NotNull EntityPlayer usingPlayer) {
        block8: {
            Intrinsics.checkParameterIsNotNull((Object)usingPlayer, (String)"usingPlayer");
            MinecraftServer minecraftServer = usingPlayer.getServer();
            if (minecraftServer == null || (minecraftServer = minecraftServer.getPlayerProfileCache()) == null) break block8;
            MinecraftServer minecraftServer2 = minecraftServer;
            boolean bl = false;
            boolean bl2 = false;
            MinecraftServer it = minecraftServer2;
            boolean bl3 = false;
            World world = usingPlayer.world;
            if (world instanceof WorldServer) {
                StringBuilder missingPlayers = new StringBuilder();
                int n = ((Collection)this.players).size();
                --n;
                boolean bl4 = false;
                while (n >= 0) {
                    void i;
                    UUID foundId = this.players.get((int)i);
                    if (Intrinsics.areEqual((Object)foundId, (Object)usingPlayer.getUniqueID()) ^ true) {
                        if (((WorldServer)world).getEntityFromUuid(foundId) != null) {
                            this.players.remove((int)i);
                            return foundId;
                        }
                        if (it.getProfileByUUID(foundId) != null) {
                            GameProfile gameProfile;
                            boolean bl5 = false;
                            boolean bl6 = false;
                            GameProfile profile = gameProfile;
                            boolean bl7 = false;
                            GameProfile gameProfile2 = profile;
                            Intrinsics.checkExpressionValueIsNotNull((Object)gameProfile2, (String)"profile");
                            missingPlayers.append(gameProfile2.getName()).append(" ");
                        }
                    } else if (this.players.size() == 1) {
                        usingPlayer.sendStatusMessage(new TextComponentTranslation(WitcheryGeneralItems.TAGLOCK_KIT.getTranslationKey() + ".own_taglock", new Object[0]).setStyle(new Style().setColor(TextFormatting.RED)), true);
                        return null;
                    }
                    --i;
                }
                CharSequence charSequence = missingPlayers;
                bl4 = false;
                if (charSequence.length() > 0) {
                    usingPlayer.sendStatusMessage(new TextComponentTranslation(WitcheryGeneralItems.TAGLOCK_KIT.getTranslationKey() + ".player_absent", new Object[]{missingPlayers.toString()}).setStyle(new Style().setColor(TextFormatting.RED)), true);
                }
            }
        }
        return null;
    }

    public void readFromNBT(@NotNull NBTTagCompound tag) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        super.readFromNBT(tag);
        this.readPlayers(tag);
    }

    @NotNull
    public NBTTagCompound writeToNBT(@NotNull NBTTagCompound tag) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        super.writeToNBT(tag);
        this.writePlayers(tag);
        return tag;
    }

    /*
     * WARNING - void declaration
     */
    public final void readPlayers(@NotNull NBTTagCompound tag) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        this.players.clear();
        NBTTagList list2 = tag.getTagList("Players", 8);
        int n = 0;
        int n2 = list2.tagCount();
        while (n < n2) {
            void i;
            UUID uUID = UUID.fromString(list2.getStringTagAt((int)i));
            Intrinsics.checkExpressionValueIsNotNull((Object)uUID, (String)"UUID.fromString(list.getStringTagAt(i))");
            this.players.add(uUID);
            ++i;
        }
    }

    public final void writePlayers(@NotNull NBTTagCompound tag) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        NBTTagList list2 = new NBTTagList();
        for (UUID player : this.players) {
            list2.appendTag((NBTBase)new NBTTagString(player.toString()));
        }
        tag.setTag("Players", (NBTBase)list2);
    }

    public boolean shouldRefresh(@Nullable World world, @Nullable BlockPos pos, @NotNull IBlockState oldState, @NotNull IBlockState newState) {
        Intrinsics.checkParameterIsNotNull((Object)oldState, (String)"oldState");
        Intrinsics.checkParameterIsNotNull((Object)newState, (String)"newState");
        return Intrinsics.areEqual((Object)oldState.getBlock(), (Object)newState.getBlock());
    }

    public TileEntityBloodTrap() {
        List list2;
        TileEntityBloodTrap tileEntityBloodTrap = this;
        boolean bl = false;
        tileEntityBloodTrap.players = list2 = (List)new ArrayList();
    }
}

