/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block.entity;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.msrandom.witchery.util.BlockUtil;

public class TileEntityBloodCrucible
extends TileEntity {
    private static final int MAX_BLOOD_LEVEL = 20;
    private int bloodLevel;

    public boolean isFull() {
        return this.bloodLevel == 20;
    }

    public void drainAll() {
        this.bloodLevel = 0;
        this.notifyBlockUpdate(false);
    }

    public int getBloodLevel() {
        return this.bloodLevel;
    }

    public void increaseBloodLevel() {
        if (this.bloodLevel < 20) {
            this.bloodLevel = Math.min(5 + this.bloodLevel, 20);
            this.notifyBlockUpdate(false);
        }
    }

    public float getPercentFilled() {
        return (float)this.bloodLevel / 20.0f;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbtRoot) {
        super.writeToNBT(nbtRoot);
        nbtRoot.setInteger("BloodLevel", this.bloodLevel);
        return nbtRoot;
    }

    public void readFromNBT(NBTTagCompound nbtRoot) {
        super.readFromNBT(nbtRoot);
        this.bloodLevel = nbtRoot.getInteger("BloodLevel");
    }

    public void notifyBlockUpdate(boolean notifyNeighbours) {
        BlockUtil.notifyBlockUpdate(this.world, this.getPos());
        if (notifyNeighbours && this.world != null) {
            this.world.notifyNeighborsRespectDebug(this.getPos(), this.getBlockType(), true);
        }
    }

    public SPacketUpdateTileEntity getUpdatePacket() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.writeToNBT(nbtTag);
        return new SPacketUpdateTileEntity(this.getPos(), 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet2) {
        super.onDataPacket(net, packet2);
        this.readFromNBT(packet2.getNbtCompound());
        this.world.markBlockRangeForRenderUpdate(this.getPos(), this.getPos());
    }
}

