/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block.entity;

import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.WitcheryTileEntity;
import net.msrandom.witchery.entity.EntityWerewolf;
import net.msrandom.witchery.infusion.Infusion;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.util.CreatureUtil;

public class TileEntityBeartrap
extends WitcheryTileEntity {
    public GameProfile owner;
    public long setTime;
    private boolean silvered;
    private long startTime;
    private UUID spawnedWolfID;

    public TileEntityBeartrap setSilvered(boolean silvered) {
        this.silvered = silvered;
        return this;
    }

    public boolean tryTrapWolf(EntityLivingBase living) {
        if (this.silvered && living instanceof EntityWerewolf) {
            EntityWerewolf wolf = (EntityWerewolf)living;
            if (this.spawnedWolfID != null && wolf.getPersistentID().equals(this.spawnedWolfID)) {
                this.world.playSound(null, this.pos, WitcherySounds.ENTITY_WEREWOLF_LORD, living.getSoundCategory(), 1.0f, 0.4f / (this.world.rand.nextFloat() * 0.4f + 0.8f));
                wolf.setInfectious();
                return true;
            }
        }
        return false;
    }

    @Override
    public void update() {
        if (this.silvered) {
            super.update();
            if (!this.world.isRemote && (this.getBlockMetadata() & 2) == 0 && this.spawnedWolfID == null && this.ticks % 200L == 0L) {
                if (this.baitFound() && CreatureUtil.isFullMoon(this.world)) {
                    long time = this.world.getTotalWorldTime();
                    if (this.startTime > 0L) {
                        EntityCreature creature;
                        long activateTime = this.startTime;
                        if (time > activateTime && CreatureUtil.isFullMoon(this.world) && (creature = Infusion.spawnCreature(this.world, EntityWerewolf.class, this.getPos(), null, 16, 32, EnumParticleTypes.SMOKE_NORMAL, WitcherySounds.ENTITY_WEREWOLF_AMBIENT)) != null) {
                            creature.enablePersistence();
                            this.spawnedWolfID = creature.getPersistentID();
                        }
                    } else {
                        this.startTime = time;
                    }
                } else {
                    this.startTime = 0L;
                }
            }
        }
    }

    private boolean baitFound() {
        double R = 8.0;
        double RSQ = 64.0;
        boolean foundSheep = false;
        AxisAlignedBB bounds = new AxisAlignedBB(this.getPos().add(-R, -R, -R), this.getPos().add(R, R, R));
        List sheep = this.world.getEntitiesWithinAABB(EntitySheep.class, bounds);
        for (EntitySheep aSheep : sheep) {
            if (!(aSheep.getDistanceSq(this.getPos()) <= RSQ) || !aSheep.getLeashed()) continue;
            foundSheep = true;
            break;
        }
        boolean wolfaltar = this.world.getBlockState(this.getPos().east()).getBlock() == WitcheryBlocks.WOLF_ALTAR || this.world.getBlockState(this.getPos().west()).getBlock() == WitcheryBlocks.WOLF_ALTAR || this.world.getBlockState(this.getPos().south()).getBlock() == WitcheryBlocks.WOLF_ALTAR || this.world.getBlockState(this.getPos().north()).getBlock() == WitcheryBlocks.WOLF_ALTAR;
        return wolfaltar && foundSheep;
    }

    public boolean invisibleTo(EntityPlayer player) {
        return (this.getBlockMetadata() & 2) > 0 && this.owner != null && !this.silvered && (player == null || !player.getGameProfile().equals((Object)this.owner));
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbtRoot) {
        super.writeToNBT(nbtRoot);
        nbtRoot.setLong("WolftrapStart", this.startTime);
        if (this.spawnedWolfID != null) {
            nbtRoot.setUniqueId("Wolf", this.spawnedWolfID);
        }
        if (this.owner != null) {
            NBTTagCompound nbtPlayer = new NBTTagCompound();
            NBTUtil.writeGameProfile((NBTTagCompound)nbtPlayer, (GameProfile)this.owner);
            nbtRoot.setTag("Owner", (NBTBase)nbtPlayer);
        }
        return nbtRoot;
    }

    public void readFromNBT(NBTTagCompound nbtRoot) {
        super.readFromNBT(nbtRoot);
        this.startTime = nbtRoot.getLong("WolftrapStart");
        this.owner = nbtRoot.hasKey("Owner", 10) ? NBTUtil.readGameProfileFromNBT((NBTTagCompound)nbtRoot.getCompoundTag("Owner")) : null;
        this.spawnedWolfID = nbtRoot.hasUniqueId("Wolf") && nbtRoot.hasKey("Wolf") ? nbtRoot.getUniqueId("Wolf") : null;
    }

    public SPacketUpdateTileEntity getUpdatePacket() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.writeToNBT(nbtTag);
        return new SPacketUpdateTileEntity(this.getPos(), 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet2) {
        super.onDataPacket(net, packet2);
        this.readFromNBT(packet2.getNbtCompound());
        this.world.markBlockRangeForRenderUpdate(this.getPos(), this.getPos());
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.getBlock() == newState.getBlock();
    }
}

