/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block.entity;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;

public class TileEntityBarrier
extends TileEntity
implements ITickable {
    private static final String KEY_REMAINING_TICKS = "remainingTicks";
    private static final String KEY_BLOCKS_PLAYERS = "blocksPlayers";
    private static final String KEY_OWNER_NAME = "owner";
    private int ticksUntilExpiration = 60;
    private boolean blocksPlayers;
    private String ownerName = "";

    public void update() {
        if (--this.ticksUntilExpiration <= 0 && !this.world.isRemote) {
            this.world.setBlockState(this.getPos(), Blocks.AIR.getDefaultState(), 3);
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbtTag) {
        super.writeToNBT(nbtTag);
        nbtTag.setInteger(KEY_REMAINING_TICKS, this.ticksUntilExpiration);
        nbtTag.setBoolean(KEY_BLOCKS_PLAYERS, this.blocksPlayers);
        nbtTag.setString(KEY_OWNER_NAME, this.ownerName);
        return nbtTag;
    }

    public void readFromNBT(NBTTagCompound nbtTag) {
        super.readFromNBT(nbtTag);
        this.ticksUntilExpiration = nbtTag.getInteger(KEY_REMAINING_TICKS);
        this.blocksPlayers = nbtTag.getBoolean(KEY_BLOCKS_PLAYERS);
        this.ownerName = nbtTag.getString(KEY_OWNER_NAME);
    }

    public void setTicksUntilExpiration(int ticksUntilExpiration) {
        this.ticksUntilExpiration = ticksUntilExpiration;
    }

    public boolean getBlocksPlayers() {
        return this.blocksPlayers;
    }

    public void setBlocksPlayers(boolean blocksPlayers) {
        this.blocksPlayers = blocksPlayers;
    }

    public void setOwner(EntityPlayer owner) {
        this.ownerName = owner == null ? "" : owner.getName();
    }

    public boolean isOwner(EntityPlayer player) {
        return player != null && player.getName().equals(this.ownerName);
    }
}

