/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import kotlin.ranges.RangesKt;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockFlower;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;
import net.msrandom.witchery.block.BlockChalice;
import net.msrandom.witchery.block.BlockPlacedItem;
import net.msrandom.witchery.block.entity.TileEntityPlacedItem;
import net.msrandom.witchery.block.entity.WitcheryTileEntity;
import net.msrandom.witchery.common.IPowerSource;
import net.msrandom.witchery.common.PowerSources;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.WitcheryWoodTypes;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.util.BlockUtil;

public class TileEntityAltar
extends WitcheryTileEntity
implements IPowerSource {
    private static final int SCAN_DISTANCE = 14;
    long lastPowerUpdate = 0L;
    private BlockPos core;
    private float power;
    private float maxPower;
    private int powerScale;
    private int rechargeScale;
    private int enhancementLevel;
    private int rangeScale = 1;
    private ArrayList<Block> extraNatureIDs = null;

    @Override
    public boolean isPowerInvalid() {
        return this.isInvalid();
    }

    @Override
    protected void initiate() {
        super.initiate();
        if (!this.world.isRemote && this.isCore() && this.world.getBlockState(this.getPos()).getBlock() == WitcheryBlocks.ALTAR) {
            PowerSources.instance().registerPowerSource(this);
        }
    }

    public void invalidate() {
        super.invalidate();
        if (!this.world.isRemote) {
            PowerSources.instance().removePowerSource(this);
        }
    }

    @Override
    public void update() {
        super.update();
        if (!this.world.isRemote) {
            float maxPowerScaled = this.maxPower * (float)this.powerScale;
            if (this.isCore()) {
                if (this.power < maxPowerScaled) {
                    float basePowerPerUpdate = 10.0f;
                    if (this.ticks % 20L == 0L) {
                        this.power = (int)Math.min(this.power + basePowerPerUpdate * (float)this.rechargeScale, maxPowerScaled);
                        BlockUtil.notifyBlockUpdate(this.world, this.getPos());
                    }
                } else if (this.power > maxPowerScaled && this.ticks % 20L == 0L) {
                    this.power = maxPowerScaled;
                    BlockUtil.notifyBlockUpdate(this.world, this.getPos());
                }
            }
        }
    }

    @Override
    public float getRange() {
        return 16 * this.rangeScale;
    }

    public boolean isValidAndUpdate() {
        if (!this.isValid() || this.world.isRemote) {
            return this.isValid();
        }
        TileEntity tile = this.world.getTileEntity(this.core);
        if (tile instanceof TileEntityAltar) {
            TileEntityAltar tileEntity = (TileEntityAltar)tile;
            tileEntity.updateArtefacts();
            tileEntity.updatePower(true);
            return true;
        }
        return false;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbtTag) {
        if (this.core != null) {
            NBTTagCompound corePos = new NBTTagCompound();
            corePos.setInteger("X", this.core.getX());
            corePos.setInteger("Y", this.core.getY());
            corePos.setInteger("Z", this.core.getZ());
            nbtTag.setTag("Core", (NBTBase)corePos);
        }
        if (this.isCore()) {
            nbtTag.setFloat("Power", this.power);
            nbtTag.setFloat("MaxPower", this.maxPower);
            nbtTag.setInteger("PowerScale", this.powerScale);
            nbtTag.setInteger("RechargeScale", this.rechargeScale);
            nbtTag.setInteger("RangeScale", this.rangeScale);
            nbtTag.setInteger("EnhancementLevel", this.enhancementLevel);
        }
        return super.writeToNBT(nbtTag);
    }

    public void readFromNBT(NBTTagCompound nbtTag) {
        if (nbtTag.hasKey("Core")) {
            NBTTagCompound corePos = nbtTag.getCompoundTag("Core");
            this.core = new BlockPos(corePos.getInteger("X"), corePos.getInteger("Y"), corePos.getInteger("Z"));
        }
        this.power = nbtTag.getFloat("Power");
        this.maxPower = nbtTag.getFloat("MaxPower");
        this.powerScale = nbtTag.getInteger("PowerScale");
        this.rechargeScale = nbtTag.getInteger("RechargeScale");
        this.rangeScale = nbtTag.hasKey("RangeScale") ? nbtTag.getInteger("RangeScale") : 1;
        this.enhancementLevel = nbtTag.hasKey("EnhancementLevel") ? nbtTag.getInteger("EnhancementLevel") : 0;
        super.readFromNBT(nbtTag);
    }

    private boolean isCore() {
        return this.core != null && this.core.equals((Object)this.getPos());
    }

    public void setCore(BlockPos coord) {
        this.core = coord;
        if (this.isCore()) {
            this.updatePower(false);
            PowerSources.instance().registerPowerSource(this);
        }
        if (coord == null) {
            PowerSources.instance().removePowerSource(this);
            this.power = 0.0f;
            this.maxPower = 0.0f;
            this.powerScale = 1;
            this.rechargeScale = 1;
            this.rangeScale = 1;
            this.enhancementLevel = 0;
        }
    }

    @Nonnull
    public SPacketUpdateTileEntity getUpdatePacket() {
        return new SPacketUpdateTileEntity(this.getPos(), 1, this.getUpdateTag());
    }

    public NBTTagCompound getUpdateTag() {
        return this.writeToNBT(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet2) {
        super.onDataPacket(net, packet2);
        this.handleUpdateTag(packet2.getNbtCompound());
    }

    public float getCorePower() {
        TileEntity te;
        if (this.core != null && (te = this.world.getTileEntity(this.core)) instanceof TileEntityAltar) {
            TileEntityAltar tileEntity = (TileEntityAltar)te;
            return tileEntity.power;
        }
        return 0.0f;
    }

    public void updateCoreArtefacts() {
        TileEntity tile;
        if (this.core != null && (tile = this.world.getTileEntity(this.core)) instanceof TileEntityAltar) {
            TileEntityAltar tileEntity = (TileEntityAltar)tile;
            tileEntity.updateArtefacts();
        }
    }

    @Override
    public boolean consumePower(float power) {
        TileEntityAltar tileEntity;
        if (this.core != null && (tileEntity = (TileEntityAltar)this.world.getTileEntity(this.core)) != null) {
            return tileEntity.consumeOurPower(power);
        }
        return false;
    }

    private boolean consumeOurPower(float requiredPower) {
        if (!this.world.isRemote && this.power >= requiredPower) {
            this.power -= requiredPower;
            return true;
        }
        return false;
    }

    @Override
    public float getCurrentPower() {
        TileEntityAltar tileEntity;
        if (this.core != null && (tileEntity = (TileEntityAltar)this.world.getTileEntity(this.core)) != null) {
            return tileEntity.getOurCurrentPower();
        }
        return -1.0f;
    }

    private float getOurCurrentPower() {
        if (!this.world.isRemote) {
            return this.power;
        }
        return -2.0f;
    }

    public float getCoreMaxPower() {
        TileEntity tile;
        if (this.core != null && (tile = this.world.getTileEntity(this.core)) instanceof TileEntityAltar) {
            TileEntityAltar tileEntity = (TileEntityAltar)tile;
            return tileEntity.maxPower * (float)tileEntity.powerScale;
        }
        return 0.0f;
    }

    public int getCoreSpeed() {
        TileEntity tile;
        if (this.core != null && (tile = this.world.getTileEntity(this.core)) instanceof TileEntityAltar) {
            TileEntityAltar tileEntity = (TileEntityAltar)tile;
            return tileEntity.rechargeScale;
        }
        return 0;
    }

    public boolean isValid() {
        return this.core != null;
    }

    @Override
    public World getCurrentWorld() {
        return this.world;
    }

    @Override
    public BlockPos getLocation() {
        return this.getPos();
    }

    @Override
    public boolean isLocationEqual(BlockPos position) {
        return position == null || !position.equals((Object)this.getPos());
    }

    private void updatePower(boolean throttle) {
        if (!(this.world.isRemote || throttle && this.ticks - this.lastPowerUpdate > 0L && this.ticks - this.lastPowerUpdate <= 100L)) {
            Block block;
            this.lastPowerUpdate = this.ticks;
            HashMap<Block, PowerSource> powerObjectTable = new HashMap<Block, PowerSource>();
            for (ItemStack blockItem : OreDictionary.getOres((String)"treeSapling")) {
                block = Block.getBlockFromItem((Item)blockItem.getItem());
                this.createInMap(powerObjectTable, block, 4, 20);
            }
            for (ItemStack blockItem : OreDictionary.getOres((String)"logWood")) {
                block = Block.getBlockFromItem((Item)blockItem.getItem());
                this.createInMap(powerObjectTable, block, 2, 50);
            }
            for (ItemStack blockItem : OreDictionary.getOres((String)"treeLeaves")) {
                block = Block.getBlockFromItem((Item)blockItem.getItem());
                this.createInMap(powerObjectTable, block, 3, 100);
            }
            this.createInMap(powerObjectTable, (Block)Blocks.GRASS, 2, 80);
            this.createInMap(powerObjectTable, Blocks.DIRT, 1, 80);
            this.createInMap(powerObjectTable, Blocks.FARMLAND, 1, 100);
            this.createInMap(powerObjectTable, (Block)Blocks.TALLGRASS, 3, 50);
            this.createInMap(powerObjectTable, (Block)Blocks.YELLOW_FLOWER, 4, 30);
            this.createInMap(powerObjectTable, (Block)Blocks.RED_FLOWER, 4, 30);
            this.createInMap(powerObjectTable, Blocks.WHEAT, 4, 20);
            this.createInMap(powerObjectTable, (Block)Blocks.WATER, 1, 50);
            this.createInMap(powerObjectTable, (Block)Blocks.RED_MUSHROOM, 3, 20);
            this.createInMap(powerObjectTable, (Block)Blocks.BROWN_MUSHROOM, 3, 20);
            this.createInMap(powerObjectTable, (Block)Blocks.CACTUS, 3, 50);
            this.createInMap(powerObjectTable, (Block)Blocks.REEDS, 3, 50);
            this.createInMap(powerObjectTable, Blocks.PUMPKIN, 4, 20);
            this.createInMap(powerObjectTable, Blocks.PUMPKIN_STEM, 3, 20);
            this.createInMap(powerObjectTable, Blocks.BROWN_MUSHROOM_BLOCK, 3, 20);
            this.createInMap(powerObjectTable, Blocks.RED_MUSHROOM_BLOCK, 3, 20);
            this.createInMap(powerObjectTable, Blocks.MELON_BLOCK, 4, 20);
            this.createInMap(powerObjectTable, Blocks.MELON_STEM, 3, 20);
            this.createInMap(powerObjectTable, Blocks.VINE, 2, 50);
            this.createInMap(powerObjectTable, (Block)Blocks.MYCELIUM, 1, 80);
            this.createInMap(powerObjectTable, Blocks.DRAGON_EGG, 250, 1);
            this.createInMap(powerObjectTable, (Block)WitcheryBlocks.DEMON_HEART, 40, 2);
            this.createInMap(powerObjectTable, Blocks.COCOA, 3, 20);
            this.createInMap(powerObjectTable, Blocks.CARROTS, 4, 20);
            this.createInMap(powerObjectTable, Blocks.POTATOES, 4, 20);
            this.createInMap(powerObjectTable, (Block)WitcheryBlocks.BELLADONNA_SEEDS, 4, 20);
            this.createInMap(powerObjectTable, (Block)WitcheryBlocks.MANDRAKE_SEEDS, 4, 20);
            this.createInMap(powerObjectTable, (Block)WitcheryBlocks.ARTICHOKE_SEEDS, 4, 20);
            this.createInMap(powerObjectTable, (Block)WitcheryBlocks.SNOWBELL_SEEDS, 4, 20);
            this.createInMap(powerObjectTable, (Block)WitcheryBlocks.EMBER_MOSS, 4, 20);
            this.createInMap(powerObjectTable, (Block)WitcheryWoodTypes.ROWAN.getLeaves(), 4, 50);
            this.createInMap(powerObjectTable, (Block)WitcheryWoodTypes.ALDER.getLeaves(), 4, 50);
            this.createInMap(powerObjectTable, (Block)WitcheryWoodTypes.HAWTHORN.getLeaves(), 4, 50);
            this.createInMap(powerObjectTable, WitcheryWoodTypes.ROWAN.getLog(), 3, 100);
            this.createInMap(powerObjectTable, WitcheryWoodTypes.ALDER.getLog(), 3, 100);
            this.createInMap(powerObjectTable, WitcheryWoodTypes.HAWTHORN.getLog(), 3, 100);
            this.createInMap(powerObjectTable, (Block)WitcheryBlocks.SPANISH_MOSS, 3, 20);
            this.createInMap(powerObjectTable, (Block)WitcheryBlocks.GLINT_WEED, 2, 20);
            this.createInMap(powerObjectTable, WitcheryBlocks.EMPTY_CRITTER_SNARE, 2, 10);
            this.createInMap(powerObjectTable, (Block)WitcheryBlocks.BLOOD_POPPY, 2, 10);
            this.createInMap(powerObjectTable, (Block)WitcheryBlocks.GRASSPER, 2, 10);
            this.createInMap(powerObjectTable, (Block)WitcheryBlocks.WISPY_COTTON, 3, 20);
            this.createInMap(powerObjectTable, (Block)WitcheryBlocks.INFINITY_EGG, 1000, 1);
            if (this.extraNatureIDs == null) {
                this.extraNatureIDs = new ArrayList();
                for (Block block2 : ForgeRegistries.BLOCKS) {
                    if (!(block2 instanceof BlockFlower) && !(block2 instanceof BlockCrops) || powerObjectTable.containsKey(block2)) continue;
                    this.extraNatureIDs.add(block2);
                }
            }
            for (Block block2 : this.extraNatureIDs) {
                this.createInMap(powerObjectTable, block2, 2, 4);
            }
            for (int y = this.getPos().getY() - 14; y <= this.getPos().getY() + 14; ++y) {
                for (int z = this.getPos().getZ() + 14; z >= this.getPos().getZ() - 14; --z) {
                    for (int x = this.getPos().getX() - 14; x <= this.getPos().getX() + 14; ++x) {
                        Block block3 = this.world.getBlockState(new BlockPos(x, y, z)).getBlock();
                        PowerSource source = (PowerSource)powerObjectTable.get(block3);
                        if (source == null) continue;
                        ++source.count;
                    }
                }
            }
            float newMax = 0.0f;
            for (PowerSource source2 : powerObjectTable.values()) {
                newMax += (float)source2.getPower();
            }
            if (newMax != this.maxPower) {
                this.maxPower = newMax;
                BlockUtil.notifyBlockUpdate(this.world, this.getPos());
            }
        }
    }

    private void updateArtefacts() {
        ArrayList<BlockPos> visited = new ArrayList<BlockPos>();
        ArrayList<BlockPos> toVisit = new ArrayList<BlockPos>();
        toVisit.add(this.getPos());
        boolean headfound = false;
        boolean candlefound = false;
        boolean cupfound = false;
        boolean knifeFound = false;
        boolean wandFound = false;
        boolean pentacleFound = false;
        boolean infinityFound = false;
        int newPowerScale = 1;
        int newRechargeScale = 1;
        int newRangeScale = 1;
        int newEnhancementLevel = 0;
        while (toVisit.size() > 0) {
            BlockPos coord = (BlockPos)toVisit.get(0);
            toVisit.remove(0);
            for (BlockPos newCoord : new BlockPos[]{coord.north(), coord.south(), coord.east(), coord.west()}) {
                if (this.world.getBlockState(newCoord).getBlock() != WitcheryBlocks.ALTAR || visited.contains(newCoord) || toVisit.contains(newCoord)) continue;
                toVisit.add(newCoord);
            }
            visited.add(coord);
            BlockPos offset = coord.up();
            Block block = this.world.getBlockState(offset).getBlock();
            if (!headfound && block == Blocks.SKULL) {
                TileEntity tile = this.world.getTileEntity(offset);
                if (!(tile instanceof TileEntitySkull)) continue;
                TileEntitySkull skullTileEntity = (TileEntitySkull)tile;
                switch (skullTileEntity.getSkullType()) {
                    case 0: {
                        ++newRechargeScale;
                        ++newPowerScale;
                        headfound = true;
                        break;
                    }
                    case 1: {
                        newRechargeScale += 2;
                        newPowerScale += 2;
                        headfound = true;
                        break;
                    }
                    case 3: {
                        newRechargeScale += 3;
                        newPowerScale += 3;
                        headfound = true;
                    }
                }
                continue;
            }
            if (!candlefound && block == WitcheryBlocks.CANDELABRA) {
                candlefound = true;
                newRechargeScale += 2;
                continue;
            }
            if (!candlefound && block == Blocks.TORCH) {
                candlefound = true;
                ++newRechargeScale;
                continue;
            }
            if (block instanceof BlockPlacedItem) {
                TileEntityPlacedItem item = WitcheryTileEntities.PLACED_ITEM.getAt((IBlockAccess)this.world, offset);
                if (item == null) continue;
                ItemStack placedStack = item.getStack();
                if (!knifeFound && placedStack.getItem() == WitcheryGeneralItems.ARTHANA) {
                    knifeFound = true;
                    ++newRangeScale;
                    continue;
                }
                if (!wandFound && placedStack.getItem() == WitcheryGeneralItems.MYSTIC_BRANCH) {
                    wandFound = true;
                    ++newEnhancementLevel;
                    continue;
                }
                if (pentacleFound || placedStack.getItem() != WitcheryIngredientItems.KOBOLDITE_PENTACLE) continue;
                pentacleFound = true;
                continue;
            }
            if (!cupfound && block instanceof BlockChalice) {
                cupfound = true;
                newPowerScale += ((BlockChalice)block).isFull ? 2 : 1;
                continue;
            }
            if (infinityFound || block != WitcheryBlocks.INFINITY_EGG) continue;
            infinityFound = true;
        }
        if (pentacleFound) {
            newRechargeScale *= 2;
        }
        if (infinityFound) {
            newRechargeScale *= 10;
            newPowerScale *= 10;
        }
        if (newRechargeScale != this.rechargeScale || newPowerScale != this.powerScale || newRangeScale != this.rangeScale || newEnhancementLevel != this.enhancementLevel) {
            this.rechargeScale = newRechargeScale;
            this.powerScale = newPowerScale;
            this.rangeScale = newRangeScale;
            this.enhancementLevel = newEnhancementLevel;
            if (!this.world.isRemote) {
                BlockUtil.notifyBlockUpdate(this.world, this.getPos());
            }
        }
    }

    private void createInMap(Map<Block, PowerSource> map, Block block, int factor, int limit) {
        PowerSource source = new PowerSource(factor, (int)(RangesKt.coerceAtLeast((double)((double)this.enhancementLevel * 1.18), (double)1.0) * (double)limit));
        map.put(block, source);
    }

    static class PowerSource {
        private final int factor;
        private final int limit;
        private int count;

        public PowerSource(int factor, int limit) {
            this.factor = factor;
            this.limit = limit;
            this.count = 0;
        }

        public int getPower() {
            return Math.min(this.count, this.limit) * this.factor;
        }
    }
}

