/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block.entity;

import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.BlockAlluringSkull;
import net.msrandom.witchery.block.entity.WitcheryTileEntity;

public class TileEntityAlluringSkull
extends WitcheryTileEntity {
    private int skullRotation;
    private int quad = 0;

    @Override
    public void update() {
        super.update();
        if (!this.world.isRemote && (this.getBlockMetadata() & 8) > 0 && this.ticks % 100L == 0L) {
            if (++this.quad >= 8) {
                this.quad = 0;
            }
            BlockAlluringSkull.allure(this.world, this.getPos(), this.quad);
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.setByte("Rot", (byte)(this.skullRotation & 0xFF));
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.skullRotation = tag.getByte("Rot");
    }

    public SPacketUpdateTileEntity getUpdatePacket() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.writeToNBT(nbtTag);
        return new SPacketUpdateTileEntity(this.getPos(), 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet2) {
        super.onDataPacket(net, packet2);
        this.handleUpdateTag(packet2.getNbtCompound());
    }

    @SideOnly(value=Side.CLIENT)
    public int getSkullRotation() {
        return this.skullRotation;
    }

    public void setSkullRotation(int par1) {
        this.skullRotation = par1;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.getBlock() == newState.getBlock();
    }
}

