/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 !2\u00020\u0001:\u0002!\"B8\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012!\u0010\u0006\u001a\u001d\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u00010\u0007\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0014J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0017H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u0017H\u0016J\u0014\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001d2\u0006\u0010\u001e\u001a\u00020\u000fH\u0016J\f\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030 H\u0016J\b\u0010\u0004\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0006\u001a\u001d\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lnet/msrandom/witchery/block/WitcheryBlockSlab;", "Lnet/minecraft/block/BlockSlab;", "material", "Lnet/minecraft/block/material/Material;", "isDouble", "", "singleSlab", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "slab", "(Lnet/minecraft/block/material/Material;ZLkotlin/jvm/functions/Function1;)V", "createBlockState", "Lnet/minecraft/block/state/BlockStateContainer;", "getItem", "Lnet/minecraft/item/ItemStack;", "worldIn", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "state", "Lnet/minecraft/block/state/IBlockState;", "getMetaFromState", "", "getStateFromMeta", "meta", "getTranslationKey", "", "getTypeForItem", "", "stack", "getVariantProperty", "Lnet/minecraft/block/properties/IProperty;", "Companion", "Variant", "WitcheryResurrected"})
public class WitcheryBlockSlab
extends BlockSlab {
    private final boolean isDouble;
    private final Function1<BlockSlab, BlockSlab> singleSlab;
    private static final PropertyEnum<Variant> PROPERTY;
    @JvmField
    @NotNull
    public static final IProperty<?> VARIANT;
    public static final Companion Companion;

    @NotNull
    public ItemStack getItem(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull IBlockState state) {
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        return new ItemStack((Block)this.singleSlab.invoke((Object)this));
    }

    @NotNull
    public String getTranslationKey(int meta) {
        String string = super.getTranslationKey();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"super.getTranslationKey()");
        return string;
    }

    public boolean isDouble() {
        return this.isDouble;
    }

    @NotNull
    public IProperty<?> getVariantProperty() {
        PropertyEnum<Variant> propertyEnum = PROPERTY;
        Intrinsics.checkExpressionValueIsNotNull(propertyEnum, (String)"PROPERTY");
        return (IProperty)propertyEnum;
    }

    @NotNull
    public Comparable<?> getTypeForItem(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return (Comparable)((Object)Variant.DEFAULT);
    }

    @NotNull
    protected BlockStateContainer createBlockState() {
        return this.isDouble ? new BlockStateContainer((Block)this, new IProperty[]{(IProperty)PROPERTY}) : new BlockStateContainer((Block)this, new IProperty[]{(IProperty)BlockSlab.HALF, (IProperty)PROPERTY});
    }

    @NotNull
    public IBlockState getStateFromMeta(int meta) {
        IBlockState state = this.getDefaultState();
        if (!this.isDouble) {
            state = state.withProperty((IProperty)BlockSlab.HALF, (Comparable)((meta & 8) == 0 ? BlockSlab.EnumBlockHalf.BOTTOM : BlockSlab.EnumBlockHalf.TOP));
        }
        IBlockState iBlockState = state;
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"state");
        return iBlockState;
    }

    public int getMetaFromState(@NotNull IBlockState state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        int i = 0;
        if (!this.isDouble && (BlockSlab.EnumBlockHalf)state.getValue((IProperty)BlockSlab.HALF) == BlockSlab.EnumBlockHalf.TOP) {
            i |= 8;
        }
        return i;
    }

    public WitcheryBlockSlab(@NotNull Material material, boolean isDouble, @NotNull Function1<? super BlockSlab, ? extends BlockSlab> singleSlab) {
        Intrinsics.checkParameterIsNotNull((Object)material, (String)"material");
        Intrinsics.checkParameterIsNotNull(singleSlab, (String)"singleSlab");
        super(material);
        this.isDouble = isDouble;
        this.singleSlab = singleSlab;
        if (!this.isDouble) {
            BlockStateContainer blockStateContainer = this.blockState;
            Intrinsics.checkExpressionValueIsNotNull((Object)blockStateContainer, (String)"blockState");
            this.setDefaultState(blockStateContainer.getBaseState().withProperty((IProperty)BlockSlab.HALF, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM));
        }
        this.setDefaultState(this.getDefaultState().withProperty((IProperty)PROPERTY, (Comparable)((Object)Variant.DEFAULT)));
        this.setCreativeTab(WitcheryGeneralItems.TAB);
    }

    static {
        Companion = new Companion(null);
        PROPERTY = PropertyEnum.create((String)"variant", Variant.class);
        PropertyEnum<Variant> propertyEnum = PROPERTY;
        Intrinsics.checkExpressionValueIsNotNull(propertyEnum, (String)"PROPERTY");
        VARIANT = (IProperty)propertyEnum;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lnet/msrandom/witchery/block/WitcheryBlockSlab$Variant;", "", "Lnet/minecraft/util/IStringSerializable;", "(Ljava/lang/String;I)V", "getName", "", "DEFAULT", "WitcheryResurrected"})
    private static final class Variant
    extends Enum<Variant>
    implements IStringSerializable {
        public static final /* enum */ Variant DEFAULT;
        private static final /* synthetic */ Variant[] $VALUES;

        static {
            Variant[] variantArray = new Variant[1];
            Variant[] variantArray2 = variantArray;
            variantArray[0] = DEFAULT = new Variant();
            $VALUES = variantArray;
        }

        @NotNull
        public String getName() {
            return "default";
        }

        public static Variant[] values() {
            return (Variant[])$VALUES.clone();
        }

        public static Variant valueOf(String string) {
            return Enum.valueOf(Variant.class, string);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lnet/msrandom/witchery/block/WitcheryBlockSlab$Companion;", "", "()V", "PROPERTY", "Lnet/minecraft/block/properties/PropertyEnum;", "Lnet/msrandom/witchery/block/WitcheryBlockSlab$Variant;", "kotlin.jvm.PlatformType", "VARIANT", "Lnet/minecraft/block/properties/IProperty;", "WitcheryResurrected"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

