/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockPressurePlate;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.TileEntityCursedBlock;
import net.msrandom.witchery.brewing.ModifiersImpact;
import net.msrandom.witchery.init.WitcheryTileEntities;

public class WitcheryBlockPressurePlate
extends BlockContainer {
    public static final PropertyBool POWERED = PropertyBool.create((String)"powered");
    private static final AxisAlignedBB PRESSED_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.03125, 0.9375);
    private static final AxisAlignedBB UNPRESSED_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.0625, 0.9375);
    private static final AxisAlignedBB PRESSURE_AABB = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.25, 0.875);
    private final BlockPressurePlate.Sensitivity sensitivity;
    private final Block original;

    public WitcheryBlockPressurePlate(Block original, BlockPressurePlate.Sensitivity sensitivity) {
        super(original.getDefaultState().getMaterial());
        this.setDefaultState(this.getDefaultState().withProperty((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
        this.sensitivity = sensitivity;
        this.original = original;
        this.setHardness(0.5f);
        this.setTickRandomly(true);
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        boolean flag = this.getRedstoneStrength(state) > 0;
        return flag ? PRESSED_AABB : UNPRESSED_AABB;
    }

    public int tickRate(World worldIn) {
        return 20;
    }

    @Nullable
    public AxisAlignedBB getCollisionBoundingBox(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return NULL_AABB;
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public boolean isPassable(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public boolean canSpawnInBlock() {
        return true;
    }

    public boolean canPlaceBlockAt(World worldIn, BlockPos pos) {
        return this.canBePlacedOn(worldIn, pos.down());
    }

    public void neighborChanged(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canBePlacedOn(worldIn, pos.down())) {
            this.dropBlockAsItem(worldIn, pos, state, 0);
            worldIn.setBlockToAir(pos);
        }
    }

    private boolean canBePlacedOn(World worldIn, BlockPos pos) {
        return worldIn.getBlockState(pos).isTopSolid() || worldIn.getBlockState(pos).getBlock() instanceof BlockFence;
    }

    public void randomTick(World worldIn, BlockPos pos, IBlockState state, Random random) {
    }

    public void updateTick(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        int i;
        if (!worldIn.isRemote && (i = this.getRedstoneStrength(state)) > 0) {
            this.updateState(worldIn, pos, state, i, null);
        }
    }

    public void onEntityCollision(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        int i;
        if (!worldIn.isRemote && (i = this.getRedstoneStrength(state)) == 0) {
            this.updateState(worldIn, pos, state, i, entityIn);
        }
    }

    private void updateState(World worldIn, BlockPos pos, IBlockState state, int oldRedstoneStrength, Entity entity) {
        TileEntityCursedBlock tile;
        boolean flag1;
        int i = this.computeRedstoneStrength(worldIn, pos);
        boolean flag = oldRedstoneStrength > 0;
        boolean bl = flag1 = i > 0;
        if (oldRedstoneStrength != i && !worldIn.isRemote && (tile = WitcheryTileEntities.CURSED_BLOCK.getAt((IBlockAccess)worldIn, pos)) != null && entity != null && tile.applyToEntityAndDestroy(entity)) {
            state = this.setRedstoneStrength(state, i);
            worldIn.setBlockState(pos, state, 2);
            this.updateNeighbors(worldIn, pos);
            worldIn.markBlockRangeForRenderUpdate(pos, pos);
        }
        if (!flag1 && flag) {
            this.playClickOffSound(worldIn, pos);
        } else if (flag1 && !flag) {
            this.playClickOnSound(worldIn, pos);
        }
        if (flag1) {
            worldIn.scheduleUpdate(new BlockPos((Vec3i)pos), (Block)this, this.tickRate(worldIn));
        }
    }

    public void breakBlock(World worldIn, BlockPos pos, IBlockState state) {
        if (this.getRedstoneStrength(state) > 0) {
            this.updateNeighbors(worldIn, pos);
        }
        super.breakBlock(worldIn, pos, state);
    }

    private void updateNeighbors(World worldIn, BlockPos pos) {
        worldIn.notifyNeighborsOfStateChange(pos, (Block)this, false);
        worldIn.notifyNeighborsOfStateChange(pos.down(), (Block)this, false);
    }

    public int getWeakPower(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return this.getRedstoneStrength(blockState);
    }

    public int getStrongPower(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.UP ? this.getRedstoneStrength(blockState) : 0;
    }

    public boolean canProvidePower(IBlockState state) {
        return true;
    }

    public EnumPushReaction getPushReaction(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public BlockFaceShape getBlockFaceShape(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public void replaceButton(World world, BlockPos pos, ModifiersImpact impactModifiers, NBTTagCompound nbtBrew) {
        IBlockState state = world.getBlockState(pos);
        world.setBlockState(pos, this.getDefaultState().withProperty((IProperty)POWERED, state.getValue((IProperty)POWERED)), 3);
        world.scheduleUpdate(pos, (Block)this, this.tickRate(world));
        TileEntityCursedBlock tile = WitcheryTileEntities.CURSED_BLOCK.getAt((IBlockAccess)world, pos);
        if (tile != null) {
            tile.initialize(impactModifiers, nbtBrew);
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(this.original);
    }

    public Item getItemDropped(IBlockState state, Random rand, int fortune) {
        return Item.getItemFromBlock((Block)this.original);
    }

    private int getRedstoneStrength(IBlockState state) {
        return (Boolean)state.getValue((IProperty)POWERED) != false ? 15 : 0;
    }

    private IBlockState setRedstoneStrength(IBlockState state, int strength) {
        return state.withProperty((IProperty)POWERED, (Comparable)Boolean.valueOf(strength > 0));
    }

    private void playClickOnSound(World worldIn, BlockPos color2) {
        if (this.material == Material.WOOD) {
            worldIn.playSound(null, color2, SoundEvents.BLOCK_WOOD_PRESSPLATE_CLICK_ON, SoundCategory.BLOCKS, 0.3f, 0.8f);
        } else {
            worldIn.playSound(null, color2, SoundEvents.BLOCK_STONE_PRESSPLATE_CLICK_ON, SoundCategory.BLOCKS, 0.3f, 0.6f);
        }
    }

    private void playClickOffSound(World worldIn, BlockPos pos) {
        if (this.material == Material.WOOD) {
            worldIn.playSound(null, pos, SoundEvents.BLOCK_WOOD_PRESSPLATE_CLICK_OFF, SoundCategory.BLOCKS, 0.3f, 0.7f);
        } else {
            worldIn.playSound(null, pos, SoundEvents.BLOCK_STONE_PRESSPLATE_CLICK_OFF, SoundCategory.BLOCKS, 0.3f, 0.5f);
        }
    }

    private int computeRedstoneStrength(World worldIn, BlockPos pos) {
        List list2;
        AxisAlignedBB axisalignedbb = PRESSURE_AABB.offset(pos);
        switch (this.sensitivity) {
            case EVERYTHING: {
                list2 = worldIn.getEntitiesWithinAABBExcludingEntity(null, axisalignedbb);
                break;
            }
            case MOBS: {
                list2 = worldIn.getEntitiesWithinAABB(EntityLivingBase.class, axisalignedbb);
                break;
            }
            default: {
                return 0;
            }
        }
        if (!list2.isEmpty()) {
            for (Entity entity : list2) {
                if (entity.doesEntityNotTriggerPressurePlate()) continue;
                return 15;
            }
        }
        return 0;
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty((IProperty)POWERED, (Comparable)Boolean.valueOf(meta == 1));
    }

    public int getMetaFromState(IBlockState state) {
        return (Boolean)state.getValue((IProperty)POWERED) != false ? 1 : 0;
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{POWERED}).build();
    }

    @Nullable
    public TileEntity createNewTileEntity(World worldIn, int meta) {
        return WitcheryTileEntities.CURSED_BLOCK.create();
    }
}

