/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockLever;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.TileEntityCursedBlock;
import net.msrandom.witchery.brewing.ModifiersImpact;
import net.msrandom.witchery.init.WitcheryTileEntities;

public class WitcheryBlockLever
extends BlockContainer {
    public WitcheryBlockLever() {
        super(Material.CIRCUITS);
        this.setDefaultState(this.blockState.getBaseState().withProperty((IProperty)BlockLever.FACING, (Comparable)BlockLever.EnumOrientation.NORTH).withProperty((IProperty)BlockLever.POWERED, (Comparable)Boolean.valueOf(false)));
        this.setHardness(0.5f);
        this.setSoundType(SoundType.WOOD);
    }

    protected static boolean canAttachTo(World worldIn, BlockPos pos, EnumFacing direction) {
        BlockPos blockpos = pos.offset(direction.getOpposite());
        IBlockState iblockstate = worldIn.getBlockState(blockpos);
        boolean flag = iblockstate.getBlockFaceShape((IBlockAccess)worldIn, blockpos, direction) == BlockFaceShape.SOLID;
        Block block = iblockstate.getBlock();
        if (direction == EnumFacing.UP) {
            return iblockstate.isTopSolid() || !WitcheryBlockLever.isExceptionBlockForAttaching((Block)block) && flag;
        }
        return !WitcheryBlockLever.isExceptBlockForAttachWithPiston((Block)block) && flag;
    }

    @Nullable
    public AxisAlignedBB getCollisionBoundingBox(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return NULL_AABB;
    }

    public Item getItemDropped(IBlockState p_149650_1_, Random p_149650_2_, int p_149650_3_) {
        return Item.getItemFromBlock((Block)Blocks.LEVER);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(Blocks.LEVER);
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public void replaceButton(World world, BlockPos pos, ModifiersImpact impactModifiers, NBTTagCompound nbtBrew) {
        IBlockState meta = world.getBlockState(pos);
        world.setBlockState(pos, this.getDefaultState().withProperty((IProperty)BlockLever.POWERED, meta.getValue((IProperty)BlockLever.POWERED)).withProperty((IProperty)BlockLever.FACING, meta.getValue((IProperty)BlockLever.FACING)), 3);
        TileEntityCursedBlock tile = WitcheryTileEntities.CURSED_BLOCK.getAt((IBlockAccess)world, pos);
        if (tile != null) {
            tile.initialize(impactModifiers, nbtBrew);
        }
    }

    public boolean canPlaceBlockOnSide(World world, BlockPos pos, EnumFacing dir) {
        return WitcheryBlockLever.canAttachTo(world, pos, dir);
    }

    public boolean canPlaceBlockAt(World worldIn, BlockPos pos) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (!WitcheryBlockLever.canAttachTo(worldIn, pos, enumfacing)) continue;
            return true;
        }
        return false;
    }

    public IBlockState getStateForPlacement(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState iblockstate = this.getDefaultState().withProperty((IProperty)BlockLever.POWERED, (Comparable)Boolean.valueOf(false));
        if (WitcheryBlockLever.canAttachTo(worldIn, pos, facing)) {
            return iblockstate.withProperty((IProperty)BlockLever.FACING, (Comparable)BlockLever.EnumOrientation.forFacings((EnumFacing)facing, (EnumFacing)placer.getHorizontalFacing()));
        }
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            if (enumfacing == facing || !WitcheryBlockLever.canAttachTo(worldIn, pos, enumfacing)) continue;
            return iblockstate.withProperty((IProperty)BlockLever.FACING, (Comparable)BlockLever.EnumOrientation.forFacings((EnumFacing)enumfacing, (EnumFacing)placer.getHorizontalFacing()));
        }
        if (worldIn.getBlockState(pos.down()).isTopSolid()) {
            return iblockstate.withProperty((IProperty)BlockLever.FACING, (Comparable)BlockLever.EnumOrientation.forFacings((EnumFacing)EnumFacing.UP, (EnumFacing)placer.getHorizontalFacing()));
        }
        return iblockstate;
    }

    public void neighborChanged(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (this.checkCanSurvive(worldIn, pos, state) && !WitcheryBlockLever.canAttachTo(worldIn, pos, ((BlockLever.EnumOrientation)state.getValue((IProperty)BlockLever.FACING)).getFacing())) {
            this.dropBlockAsItem(worldIn, pos, state, 0);
            worldIn.setBlockToAir(pos);
        }
    }

    private boolean checkCanSurvive(World worldIn, BlockPos pos, IBlockState state) {
        if (this.canPlaceBlockAt(worldIn, pos)) {
            return true;
        }
        this.dropBlockAsItem(worldIn, pos, state, 0);
        worldIn.setBlockToAir(pos);
        return false;
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        return Blocks.LEVER.getBoundingBox(state, source, pos);
    }

    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntityCursedBlock tile;
        if (!worldIn.isRemote && (tile = WitcheryTileEntities.CURSED_BLOCK.getAt((IBlockAccess)worldIn, pos)) != null && tile.nbtEffect != null && tile.applyToEntityAndDestroy((Entity)playerIn)) {
            state = state.cycleProperty((IProperty)BlockLever.POWERED);
            worldIn.setBlockState(pos, state, 3);
            float f = (Boolean)state.getValue((IProperty)BlockLever.POWERED) != false ? 0.6f : 0.5f;
            worldIn.playSound(null, pos, SoundEvents.BLOCK_LEVER_CLICK, SoundCategory.BLOCKS, 0.3f, f);
            worldIn.notifyNeighborsOfStateChange(pos, (Block)this, false);
            EnumFacing enumfacing = ((BlockLever.EnumOrientation)state.getValue((IProperty)BlockLever.FACING)).getFacing();
            worldIn.notifyNeighborsOfStateChange(pos.offset(enumfacing.getOpposite()), (Block)this, false);
        }
        return true;
    }

    public void breakBlock(World worldIn, BlockPos pos, IBlockState state) {
        if (((Boolean)state.getValue((IProperty)BlockLever.POWERED)).booleanValue()) {
            worldIn.notifyNeighborsOfStateChange(pos, (Block)this, false);
            EnumFacing enumfacing = ((BlockLever.EnumOrientation)state.getValue((IProperty)BlockLever.FACING)).getFacing();
            worldIn.notifyNeighborsOfStateChange(pos.offset(enumfacing.getOpposite()), (Block)this, false);
        }
        super.breakBlock(worldIn, pos, state);
    }

    public int getWeakPower(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return (Boolean)blockState.getValue((IProperty)BlockLever.POWERED) != false ? 15 : 0;
    }

    public int getStrongPower(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (!((Boolean)blockState.getValue((IProperty)BlockLever.POWERED)).booleanValue()) {
            return 0;
        }
        return ((BlockLever.EnumOrientation)blockState.getValue((IProperty)BlockLever.FACING)).getFacing() == side ? 15 : 0;
    }

    public boolean canProvidePower(IBlockState state) {
        return true;
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty((IProperty)BlockLever.FACING, (Comparable)BlockLever.EnumOrientation.byMetadata((int)(meta & 7))).withProperty((IProperty)BlockLever.POWERED, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public int getMetaFromState(IBlockState state) {
        int i = 0;
        i |= ((BlockLever.EnumOrientation)state.getValue((IProperty)BlockLever.FACING)).getMetadata();
        if (((Boolean)state.getValue((IProperty)BlockLever.POWERED)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    public IBlockState withRotation(IBlockState state, Rotation rot) {
        return Blocks.LEVER.withRotation(state, rot);
    }

    public IBlockState withMirror(IBlockState state, Mirror mirrorIn) {
        return state.withRotation(mirrorIn.toRotation(((BlockLever.EnumOrientation)state.getValue((IProperty)BlockLever.FACING)).getFacing()));
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{BlockLever.FACING, BlockLever.POWERED}).build();
    }

    public BlockFaceShape getBlockFaceShape(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Nullable
    public TileEntity createNewTileEntity(World worldIn, int meta) {
        return WitcheryTileEntities.CURSED_BLOCK.create();
    }
}

