/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.TileEntityCursedBlock;
import net.msrandom.witchery.brewing.ModifiersImpact;
import net.msrandom.witchery.init.WitcheryTileEntities;

public class WitcheryBlockButton
extends BlockContainer {
    private static final PropertyDirection FACING = PropertyDirection.create((String)"facing");
    private static final PropertyBool POWERED = PropertyBool.create((String)"powered");
    private static final AxisAlignedBB AABB_DOWN_OFF = new AxisAlignedBB(0.3125, 0.875, 0.375, 0.6875, 1.0, 0.625);
    private static final AxisAlignedBB AABB_UP_OFF = new AxisAlignedBB(0.3125, 0.0, 0.375, 0.6875, 0.125, 0.625);
    private static final AxisAlignedBB AABB_NORTH_OFF = new AxisAlignedBB(0.3125, 0.375, 0.875, 0.6875, 0.625, 1.0);
    private static final AxisAlignedBB AABB_SOUTH_OFF = new AxisAlignedBB(0.3125, 0.375, 0.0, 0.6875, 0.625, 0.125);
    private static final AxisAlignedBB AABB_WEST_OFF = new AxisAlignedBB(0.875, 0.375, 0.3125, 1.0, 0.625, 0.6875);
    private static final AxisAlignedBB AABB_EAST_OFF = new AxisAlignedBB(0.0, 0.375, 0.3125, 0.125, 0.625, 0.6875);
    private static final AxisAlignedBB AABB_DOWN_ON = new AxisAlignedBB(0.3125, 0.9375, 0.375, 0.6875, 1.0, 0.625);
    private static final AxisAlignedBB AABB_UP_ON = new AxisAlignedBB(0.3125, 0.0, 0.375, 0.6875, 0.0625, 0.625);
    private static final AxisAlignedBB AABB_NORTH_ON = new AxisAlignedBB(0.3125, 0.375, 0.9375, 0.6875, 0.625, 1.0);
    private static final AxisAlignedBB AABB_SOUTH_ON = new AxisAlignedBB(0.3125, 0.375, 0.0, 0.6875, 0.625, 0.0625);
    private static final AxisAlignedBB AABB_WEST_ON = new AxisAlignedBB(0.9375, 0.375, 0.3125, 1.0, 0.625, 0.6875);
    private static final AxisAlignedBB AABB_EAST_ON = new AxisAlignedBB(0.0, 0.375, 0.3125, 0.0625, 0.625, 0.6875);
    private final boolean isWood;

    public WitcheryBlockButton(boolean wooden) {
        super(Material.CIRCUITS);
        this.setDefaultState(this.blockState.getBaseState().withProperty((IProperty)FACING, (Comparable)EnumFacing.NORTH).withProperty((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
        this.setTickRandomly(true);
        this.isWood = wooden;
        this.setHardness(0.5f);
        this.setSoundType(SoundType.STONE);
    }

    public void replaceButton(World world, BlockPos pos, ModifiersImpact impactModifiers, NBTTagCompound nbtBrew) {
        IBlockState meta = world.getBlockState(pos);
        world.setBlockState(pos, this.getDefaultState().withProperty((IProperty)POWERED, meta.getValue((IProperty)POWERED)).withProperty((IProperty)FACING, meta.getValue((IProperty)FACING)), 3);
        TileEntityCursedBlock tile = WitcheryTileEntities.CURSED_BLOCK.getAt((IBlockAccess)world, pos);
        if (tile != null) {
            tile.initialize(impactModifiers, nbtBrew);
        }
    }

    public Item getItemDropped(IBlockState p_149650_1_, Random p_149650_2_, int p_149650_3_) {
        return Item.getItemFromBlock((Block)(this.isWood ? Blocks.WOODEN_BUTTON : Blocks.STONE_BUTTON));
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(this.isWood ? Blocks.WOODEN_BUTTON : Blocks.STONE_BUTTON);
    }

    public int tickRate(World world) {
        return this.isWood ? 30 : 20;
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public boolean canPlaceBlockOnSide(World worldIn, BlockPos pos, EnumFacing side) {
        return this.canPlaceBlock(worldIn, pos, side);
    }

    public boolean canPlaceBlockAt(World worldIn, BlockPos pos) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (!this.canPlaceBlock(worldIn, pos, enumfacing)) continue;
            return true;
        }
        return false;
    }

    private boolean canPlaceBlock(World worldIn, BlockPos pos, EnumFacing direction) {
        BlockPos blockpos = pos.offset(direction.getOpposite());
        IBlockState iblockstate = worldIn.getBlockState(blockpos);
        boolean flag = iblockstate.getBlockFaceShape((IBlockAccess)worldIn, blockpos, direction) == BlockFaceShape.SOLID;
        Block block = iblockstate.getBlock();
        if (direction == EnumFacing.UP) {
            return iblockstate.isTopSolid() || !WitcheryBlockButton.isExceptionBlockForAttaching((Block)block) && flag;
        }
        return !WitcheryBlockButton.isExceptBlockForAttachWithPiston((Block)block) && flag;
    }

    public IBlockState getStateForPlacement(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.canPlaceBlock(worldIn, pos, facing) ? this.getDefaultState().withProperty((IProperty)FACING, (Comparable)facing).withProperty((IProperty)POWERED, (Comparable)Boolean.valueOf(false)) : this.getDefaultState().withProperty((IProperty)FACING, (Comparable)EnumFacing.DOWN).withProperty((IProperty)POWERED, (Comparable)Boolean.valueOf(false));
    }

    public void neighborChanged(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (this.checkForDrop(worldIn, pos, state) && !this.canPlaceBlock(worldIn, pos, (EnumFacing)state.getValue((IProperty)FACING))) {
            this.dropBlockAsItem(worldIn, pos, state, 0);
            worldIn.setBlockToAir(pos);
        }
    }

    private boolean checkForDrop(World worldIn, BlockPos pos, IBlockState state) {
        if (this.canPlaceBlockAt(worldIn, pos)) {
            return true;
        }
        this.dropBlockAsItem(worldIn, pos, state, 0);
        worldIn.setBlockToAir(pos);
        return false;
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing enumfacing = (EnumFacing)state.getValue((IProperty)FACING);
        boolean flag = (Boolean)state.getValue((IProperty)POWERED);
        switch (enumfacing) {
            case EAST: {
                return flag ? AABB_EAST_ON : AABB_EAST_OFF;
            }
            case WEST: {
                return flag ? AABB_WEST_ON : AABB_WEST_OFF;
            }
            case SOUTH: {
                return flag ? AABB_SOUTH_ON : AABB_SOUTH_OFF;
            }
            default: {
                return flag ? AABB_NORTH_ON : AABB_NORTH_OFF;
            }
            case UP: {
                return flag ? AABB_UP_ON : AABB_UP_OFF;
            }
            case DOWN: 
        }
        return flag ? AABB_DOWN_ON : AABB_DOWN_OFF;
    }

    public AxisAlignedBB getCollisionBoundingBox(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return NULL_AABB;
    }

    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!((Boolean)state.getValue((IProperty)POWERED)).booleanValue()) {
            TileEntityCursedBlock tile;
            if (!worldIn.isRemote && (tile = WitcheryTileEntities.CURSED_BLOCK.getAt((IBlockAccess)worldIn, pos)) != null && tile.nbtEffect != null && tile.applyToEntityAndDestroy((Entity)playerIn)) {
                worldIn.setBlockState(pos, state.withProperty((IProperty)POWERED, (Comparable)Boolean.valueOf(true)), 3);
                worldIn.markBlockRangeForRenderUpdate(pos, pos);
            }
            this.playClickSound(playerIn, worldIn, pos);
            this.notifyNeighbors(worldIn, pos, (EnumFacing)state.getValue((IProperty)FACING));
            worldIn.scheduleUpdate(pos, (Block)this, this.tickRate(worldIn));
        }
        return true;
    }

    private void playClickSound(@Nullable EntityPlayer player, World worldIn, BlockPos pos) {
        if (this.isWood) {
            worldIn.playSound(player, pos, SoundEvents.BLOCK_WOOD_BUTTON_CLICK_ON, SoundCategory.BLOCKS, 0.3f, 0.6f);
        } else {
            worldIn.playSound(player, pos, SoundEvents.BLOCK_STONE_BUTTON_CLICK_ON, SoundCategory.BLOCKS, 0.3f, 0.6f);
        }
    }

    private void playReleaseSound(World worldIn, BlockPos pos) {
        if (this.isWood) {
            worldIn.playSound(null, pos, SoundEvents.BLOCK_WOOD_BUTTON_CLICK_OFF, SoundCategory.BLOCKS, 0.3f, 0.5f);
        } else {
            worldIn.playSound(null, pos, SoundEvents.BLOCK_STONE_BUTTON_CLICK_OFF, SoundCategory.BLOCKS, 0.3f, 0.5f);
        }
    }

    public void breakBlock(World worldIn, BlockPos pos, IBlockState state) {
        if (((Boolean)state.getValue((IProperty)POWERED)).booleanValue()) {
            this.notifyNeighbors(worldIn, pos, (EnumFacing)state.getValue((IProperty)FACING));
        }
        super.breakBlock(worldIn, pos, state);
    }

    public int getWeakPower(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return (Boolean)blockState.getValue((IProperty)POWERED) != false ? 15 : 0;
    }

    public int getStrongPower(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (!((Boolean)blockState.getValue((IProperty)POWERED)).booleanValue()) {
            return 0;
        }
        return blockState.getValue((IProperty)FACING) == side ? 15 : 0;
    }

    public boolean canProvidePower(IBlockState state) {
        return true;
    }

    public void randomTick(World worldIn, BlockPos pos, IBlockState state, Random random) {
    }

    public void updateTick(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.isRemote && ((Boolean)state.getValue((IProperty)POWERED)).booleanValue()) {
            if (this.isWood) {
                this.checkPressed(state, worldIn, pos);
            } else {
                worldIn.setBlockState(pos, state.withProperty((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
                this.notifyNeighbors(worldIn, pos, (EnumFacing)state.getValue((IProperty)FACING));
                this.playReleaseSound(worldIn, pos);
                worldIn.markBlockRangeForRenderUpdate(pos, pos);
            }
        }
    }

    public void onEntityCollision(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (!worldIn.isRemote && this.isWood && !((Boolean)state.getValue((IProperty)POWERED)).booleanValue()) {
            this.checkPressed(state, worldIn, pos);
        }
    }

    private void checkPressed(IBlockState state, World worldIn, BlockPos pos) {
        List list2 = worldIn.getEntitiesWithinAABB(EntityArrow.class, state.getBoundingBox((IBlockAccess)worldIn, pos).offset(pos));
        boolean flag = !list2.isEmpty();
        boolean flag1 = (Boolean)state.getValue((IProperty)POWERED);
        if (flag && !flag1) {
            worldIn.setBlockState(pos, state.withProperty((IProperty)POWERED, (Comparable)Boolean.valueOf(true)));
            this.notifyNeighbors(worldIn, pos, (EnumFacing)state.getValue((IProperty)FACING));
            worldIn.markBlockRangeForRenderUpdate(pos, pos);
            this.playClickSound(null, worldIn, pos);
        }
        if (!flag && flag1) {
            worldIn.setBlockState(pos, state.withProperty((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
            this.notifyNeighbors(worldIn, pos, (EnumFacing)state.getValue((IProperty)FACING));
            worldIn.markBlockRangeForRenderUpdate(pos, pos);
            this.playReleaseSound(worldIn, pos);
        }
        if (flag) {
            worldIn.scheduleUpdate(new BlockPos((Vec3i)pos), (Block)this, this.tickRate(worldIn));
        }
    }

    private void notifyNeighbors(World worldIn, BlockPos pos, EnumFacing facing) {
        worldIn.notifyNeighborsOfStateChange(pos, (Block)this, false);
        worldIn.notifyNeighborsOfStateChange(pos.offset(facing.getOpposite()), (Block)this, false);
    }

    public IBlockState getStateFromMeta(int meta) {
        EnumFacing enumfacing;
        switch (meta & 7) {
            case 0: {
                enumfacing = EnumFacing.DOWN;
                break;
            }
            case 1: {
                enumfacing = EnumFacing.EAST;
                break;
            }
            case 2: {
                enumfacing = EnumFacing.WEST;
                break;
            }
            case 3: {
                enumfacing = EnumFacing.SOUTH;
                break;
            }
            case 4: {
                enumfacing = EnumFacing.NORTH;
                break;
            }
            default: {
                enumfacing = EnumFacing.UP;
            }
        }
        return this.getDefaultState().withProperty((IProperty)FACING, (Comparable)enumfacing).withProperty((IProperty)POWERED, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public int getMetaFromState(IBlockState state) {
        int i;
        switch ((EnumFacing)state.getValue((IProperty)FACING)) {
            case EAST: {
                i = 1;
                break;
            }
            case WEST: {
                i = 2;
                break;
            }
            case SOUTH: {
                i = 3;
                break;
            }
            case NORTH: {
                i = 4;
                break;
            }
            default: {
                i = 5;
                break;
            }
            case DOWN: {
                i = 0;
            }
        }
        if (((Boolean)state.getValue((IProperty)POWERED)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    public IBlockState withRotation(IBlockState state, Rotation rot) {
        return state.withProperty((IProperty)FACING, (Comparable)rot.rotate((EnumFacing)state.getValue((IProperty)FACING)));
    }

    public IBlockState withMirror(IBlockState state, Mirror mirrorIn) {
        return state.withRotation(mirrorIn.toRotation((EnumFacing)state.getValue((IProperty)FACING)));
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{FACING, POWERED}).build();
    }

    public BlockFaceShape getBlockFaceShape(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Nullable
    public TileEntity createNewTileEntity(World worldIn, int meta) {
        return WitcheryTileEntities.CURSED_BLOCK.create();
    }
}

