/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.Random;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.msrandom.witchery.block.BlockWitchCrop;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u0001:\u0002\u001a\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0016J \u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0014J \u0010\u0010\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J(\u0010\u0017\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016\u00a8\u0006\u001c"}, d2={"Lnet/msrandom/witchery/block/BlockWormwoodCrop;", "Lnet/msrandom/witchery/block/BlockWitchCrop;", "()V", "canGrow", "", "worldIn", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "state", "Lnet/minecraft/block/state/IBlockState;", "isClient", "changeSize", "world", "createBlockState", "Lnet/minecraft/block/state/BlockStateContainer;", "getActualState", "Lnet/minecraft/world/IBlockAccess;", "getBoundingBox", "Lnet/minecraft/util/math/AxisAlignedBB;", "source", "grow", "", "updateTick", "rand", "Ljava/util/Random;", "Companion", "State", "WitcheryResurrected"})
public final class BlockWormwoodCrop
extends BlockWitchCrop {
    private static final PropertyEnum<State> STATE;
    public static final Companion Companion;

    @NotNull
    public AxisAlignedBB getBoundingBox(@NotNull IBlockState state, @NotNull IBlockAccess source, @NotNull BlockPos pos) {
        AxisAlignedBB axisAlignedBB;
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        if ((State)((Object)state.getValue((IProperty)STATE)) == State.BOTTOM) {
            AxisAlignedBB axisAlignedBB2 = BlockWitchCrop.FULL_BLOCK_AABB;
            axisAlignedBB = axisAlignedBB2;
            Intrinsics.checkExpressionValueIsNotNull((Object)axisAlignedBB2, (String)"FULL_BLOCK_AABB");
        } else {
            AxisAlignedBB axisAlignedBB3 = super.getBoundingBox(state, source, pos);
            axisAlignedBB = axisAlignedBB3;
            Intrinsics.checkExpressionValueIsNotNull((Object)axisAlignedBB3, (String)"super.getBoundingBox(state, source, pos)");
        }
        return axisAlignedBB;
    }

    @NotNull
    public IBlockState getActualState(@NotNull IBlockState state, @NotNull IBlockAccess world, @NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        IBlockState defaultState = super.getActualState(state, world, pos);
        if (this.isMaxAge(defaultState)) {
            IBlockState iBlockState = world.getBlockState(pos.down());
            Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"world.getBlockState(pos.down())");
            if (Intrinsics.areEqual((Object)iBlockState.getBlock(), (Object)((Object)this))) {
                defaultState = defaultState.withProperty((IProperty)STATE, (Comparable)((Object)State.TOP));
            } else {
                IBlockState iBlockState2 = world.getBlockState(pos.up());
                Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState2, (String)"world.getBlockState(pos.up())");
                if (Intrinsics.areEqual((Object)iBlockState2.getBlock(), (Object)((Object)this))) {
                    defaultState = defaultState.withProperty((IProperty)STATE, (Comparable)((Object)State.BOTTOM));
                }
            }
        }
        IBlockState iBlockState = defaultState;
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"defaultState");
        return iBlockState;
    }

    public boolean canGrow(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull IBlockState state, boolean isClient) {
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        return super.canGrow(worldIn, pos, state, isClient) || (State)((Object)state.getValue((IProperty)STATE)) == State.NONE;
    }

    @Override
    public void grow(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState state) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        if (world.isRemote) {
            return;
        }
        if (!this.changeSize(world, pos, state)) {
            super.grow(world, pos, state);
        }
    }

    public void updateTick(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState state, @NotNull Random rand) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)rand, (String)"rand");
        super.updateTick(world, pos, state, rand);
        if (world.getLightFromNeighbors(pos.up()) >= 9) {
            this.changeSize(world, pos, state);
        }
    }

    private final boolean changeSize(World world, BlockPos pos, IBlockState state) {
        int age;
        if ((State)((Object)state.getValue((IProperty)STATE)) == State.NONE && (age = this.getAge(state)) >= this.getMaxAge()) {
            IBlockState iBlockState = world.getBlockState(pos.down());
            Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"world.getBlockState(pos.down())");
            Block blockBelow = iBlockState.getBlock();
            if (blockBelow != this && world.isAirBlock(pos.up())) {
                world.setBlockState(pos, state.withProperty((IProperty)STATE, (Comparable)((Object)State.BOTTOM)), 3);
                world.setBlockState(pos.up(), this.getDefaultState().withProperty((IProperty)STATE, (Comparable)((Object)State.TOP)), 3);
                return true;
            }
        }
        return false;
    }

    @Override
    @NotNull
    protected BlockStateContainer createBlockState() {
        BlockStateContainer blockStateContainer = new BlockStateContainer.Builder((Block)this).add(new IProperty[]{(IProperty)this.getAgeProperty(), (IProperty)STATE}).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)blockStateContainer, (String)"BlockStateContainer.Buil\u2026eProperty, STATE).build()");
        return blockStateContainer;
    }

    public BlockWormwoodCrop() {
        super((Function0<Item>)((Function0)1.INSTANCE));
        BlockStateContainer blockStateContainer = this.blockState;
        Intrinsics.checkExpressionValueIsNotNull((Object)blockStateContainer, (String)"blockState");
        this.setDefaultState(blockStateContainer.getBaseState().withProperty((IProperty)STATE, (Comparable)((Object)State.NONE)));
    }

    static {
        Companion = new Companion(null);
        STATE = PropertyEnum.create((String)"state", State.class);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lnet/msrandom/witchery/block/BlockWormwoodCrop$State;", "", "Lnet/minecraft/util/IStringSerializable;", "(Ljava/lang/String;I)V", "getName", "", "NONE", "BOTTOM", "TOP", "WitcheryResurrected"})
    public static final class State
    extends Enum<State>
    implements IStringSerializable {
        public static final /* enum */ State NONE;
        public static final /* enum */ State BOTTOM;
        public static final /* enum */ State TOP;
        private static final /* synthetic */ State[] $VALUES;

        static {
            State[] stateArray = new State[3];
            State[] stateArray2 = stateArray;
            stateArray[0] = NONE = new State();
            stateArray[1] = BOTTOM = new State();
            stateArray[2] = TOP = new State();
            $VALUES = stateArray;
        }

        @NotNull
        public String getName() {
            String string = this.name();
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
            return string3;
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string) {
            return Enum.valueOf(State.class, string);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lnet/msrandom/witchery/block/BlockWormwoodCrop$Companion;", "", "()V", "STATE", "Lnet/minecraft/block/properties/PropertyEnum;", "Lnet/msrandom/witchery/block/BlockWormwoodCrop$State;", "kotlin.jvm.PlatformType", "WitcheryResurrected"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

