/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.entity.TileEntityWolfAltar;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.WitcheryTransformations;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.transformation.WerewolfTransformation;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.Nullable;

public class BlockWolfAltar
extends BlockContainer {
    private static final PropertyDirection FACING = BlockHorizontal.FACING;
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 2.0, 1.0);

    public BlockWolfAltar() {
        super(Material.ROCK);
        this.setCreativeTab(WitcheryGeneralItems.TAB);
        this.setDefaultState(this.getBlockState().getBaseState().withProperty((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.setResistance(1000.0f);
        this.setHardness(2.5f);
        this.setSoundType(SoundType.STONE);
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public IBlockState getStateForPlacement(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.getDefaultState().withProperty((IProperty)FACING, (Comparable)placer.getHorizontalFacing().getOpposite());
    }

    public void onBlockPlacedBy(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.setBlockState(pos, state.withProperty((IProperty)FACING, (Comparable)placer.getHorizontalFacing().getOpposite()), 2);
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty((IProperty)FACING, (Comparable)EnumFacing.byHorizontalIndex((int)(meta & 3)));
    }

    public int getMetaFromState(IBlockState state) {
        return ((EnumFacing)state.getValue((IProperty)FACING)).getHorizontalIndex();
    }

    public IBlockState withRotation(IBlockState state, Rotation rot) {
        return state.withProperty((IProperty)FACING, (Comparable)rot.rotate((EnumFacing)state.getValue((IProperty)FACING)));
    }

    public IBlockState withMirror(IBlockState state, Mirror mirrorIn) {
        return state.withRotation(mirrorIn.toRotation((EnumFacing)state.getValue((IProperty)FACING)));
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{FACING}).build();
    }

    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (hand == EnumHand.MAIN_HAND && !world.isRemote) {
            TileEntityWolfAltar statue = WitcheryTileEntities.WOLF_ALTAR.getAt((IBlockAccess)world, pos);
            if (statue != null) {
                EnumFacing direction = (EnumFacing)state.getValue((IProperty)FACING);
                BlockPos offset = pos.offset(direction);
                PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
                ItemStack heldStack = player.getHeldItem(hand);
                WitcheryUtils.playSoundAt(player, WitcherySounds.ENTITY_WEREWOLF_LORD, SoundCategory.BLOCKS, 1.0f, 1.0f);
                WerewolfTransformation transformation = playerEx.getTransformation(WitcheryTransformations.WEREWOLF);
                int level = transformation.getLevel();
                int GOLD_REQUIRED = 3;
                if (level >= 2 && !heldStack.isEmpty() && heldStack.getItem() == Items.GOLD_INGOT && heldStack.getCount() >= GOLD_REQUIRED) {
                    double motion;
                    player.sendMessage(new TextComponentTranslation("witchery.werewolf.mooncharmcrafted", new Object[0]).setStyle(new Style().setColor(TextFormatting.GOLD)));
                    heldStack.splitStack(GOLD_REQUIRED);
                    EntityItem itemEntity = new EntityItem(world, (double)offset.getX() + 0.5, (double)(offset.getY() + 1), (double)offset.getZ() + 0.5, new ItemStack((Item)WitcheryGeneralItems.MOON_CHARM));
                    itemEntity.motionZ = motion = 0.0;
                    itemEntity.motionY = motion;
                    itemEntity.motionX = motion;
                    world.spawnEntity((Entity)itemEntity);
                    itemEntity.world.playSound(null, itemEntity.getPosition(), SoundEvents.ENTITY_EXPERIENCE_ORB_PICKUP, player.getSoundCategory(), 0.5f, 0.4f / (itemEntity.world.rand.nextFloat() * 0.4f + 0.8f));
                    WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(itemEntity.posX, itemEntity.posY, itemEntity.posZ, 0.2f, 0.2f, EnumParticleTypes.REDSTONE), (Entity)itemEntity);
                } else {
                    switch (level) {
                        case 0: {
                            WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(player.posX, player.posY, player.posZ, 1.0f, 1.0f, EnumParticleTypes.SPELL_MOB), (Entity)player);
                            player.addPotionEffect(new PotionEffect(MobEffects.MINING_FATIGUE, 1200, 0));
                            player.sendMessage(new TextComponentTranslation("witchery.werewolf.unworthy", new Object[0]).setStyle(new Style().setColor(TextFormatting.GOLD)));
                            break;
                        }
                        case 1: {
                            if (heldStack.isEmpty() || heldStack.getItem() != Items.GOLD_INGOT) {
                                player.sendMessage(new TextComponentTranslation("witchery.werewolf.level2begin", new Object[]{GOLD_REQUIRED}).setStyle(new Style().setColor(TextFormatting.GOLD)));
                                break;
                            }
                            if (heldStack.getCount() >= GOLD_REQUIRED) {
                                double motion;
                                player.sendMessage(new TextComponentTranslation("witchery.werewolf.level2complete", new Object[0]).setStyle(new Style().setColor(TextFormatting.GOLD)));
                                heldStack.splitStack(GOLD_REQUIRED);
                                EntityItem itemEntity = new EntityItem(world, (double)offset.getX() + 0.5, (double)(offset.getY() + 1), (double)offset.getZ() + 0.5, new ItemStack((Item)WitcheryGeneralItems.MOON_CHARM));
                                itemEntity.motionZ = motion = 0.0;
                                itemEntity.motionY = motion;
                                itemEntity.motionX = motion;
                                world.spawnEntity((Entity)itemEntity);
                                itemEntity.world.playSound(null, itemEntity.getPosition(), SoundEvents.ENTITY_PLAYER_LEVELUP, player.getSoundCategory(), 0.5f, 0.4f / (itemEntity.world.rand.nextFloat() * 0.4f + 0.8f));
                                WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(itemEntity.posX, itemEntity.posY, itemEntity.posZ, 0.2f, 0.2f, EnumParticleTypes.REDSTONE), (Entity)itemEntity);
                                if (!transformation.levelUp()) break;
                                playerEx.sync();
                                break;
                            }
                            player.sendMessage(new TextComponentTranslation("witchery.werewolf.level2progress", new Object[]{GOLD_REQUIRED, GOLD_REQUIRED - heldStack.getCount()}).setStyle(new Style().setColor(TextFormatting.GOLD)));
                            break;
                        }
                        case 2: {
                            int MUTTON_REQUIRED = 30;
                            if (heldStack.isEmpty() || heldStack.getItem() != WitcheryIngredientItems.SHEEP_LIVER) {
                                player.sendMessage(new TextComponentTranslation("witchery.werewolf.level3begin", new Object[]{MUTTON_REQUIRED}).setStyle(new Style().setColor(TextFormatting.GOLD)));
                                break;
                            }
                            if (heldStack.getCount() >= MUTTON_REQUIRED) {
                                player.sendMessage(new TextComponentTranslation("witchery.werewolf.level3complete", new Object[0]).setStyle(new Style().setColor(TextFormatting.GOLD)));
                                heldStack.splitStack(MUTTON_REQUIRED);
                                world.playSound(null, (double)offset.getX() + 0.5, (double)(offset.getY() + 1), (double)offset.getZ() + 0.5, SoundEvents.ENTITY_PLAYER_LEVELUP, player.getSoundCategory(), 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                                WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)offset.getX() + 0.5, (double)(offset.getY() + 1), (double)offset.getZ() + 0.5, 0.2f, 0.2f, EnumParticleTypes.REDSTONE), world, (double)offset.getX() + 0.5, offset.getY() + 1, (double)offset.getZ() + 0.5);
                                if (!transformation.levelUp()) break;
                                playerEx.sync();
                                break;
                            }
                            player.sendMessage(new TextComponentTranslation("witchery.werewolf.level3progress", new Object[]{MUTTON_REQUIRED, MUTTON_REQUIRED - heldStack.getCount()}).setStyle(new Style().setColor(TextFormatting.GOLD)));
                            break;
                        }
                        case 3: {
                            int TONGUES_REQUIRED = 10;
                            if (heldStack.isEmpty() || heldStack.getItem() != WitcheryIngredientItems.DOG_TONGUE) {
                                player.sendMessage(new TextComponentTranslation("witchery.werewolf.level4begin", new Object[]{TONGUES_REQUIRED}).setStyle(new Style().setColor(TextFormatting.GOLD)));
                                break;
                            }
                            if (heldStack.getCount() >= TONGUES_REQUIRED) {
                                player.sendMessage(new TextComponentTranslation("witchery.werewolf.level4complete", new Object[0]).setStyle(new Style().setColor(TextFormatting.GOLD)));
                                heldStack.splitStack(TONGUES_REQUIRED);
                                world.playSound(null, (double)offset.getX() + 0.5, (double)(offset.getY() + 1), (double)offset.getZ() + 0.5, SoundEvents.ENTITY_PLAYER_LEVELUP, player.getSoundCategory(), 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                                WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)offset.getX() + 0.5, (double)(offset.getY() + 1), (double)offset.getZ() + 0.5, 0.2f, 0.2f, EnumParticleTypes.REDSTONE), world, offset.up(), 16.0);
                                if (!transformation.levelUp()) break;
                                playerEx.sync();
                                break;
                            }
                            player.sendMessage(new TextComponentTranslation("witchery.werewolf.level4progress", new Object[]{TONGUES_REQUIRED, TONGUES_REQUIRED - heldStack.getCount()}).setStyle(new Style().setColor(TextFormatting.GOLD)));
                            break;
                        }
                        case 4: {
                            switch (transformation.getQuestState()) {
                                case NOT_STATED: {
                                    double motion;
                                    player.sendMessage(new TextComponentTranslation("witchery.werewolf.level5begin", new Object[0]).setStyle(new Style().setColor(TextFormatting.GOLD)));
                                    EntityItem itemEntity = new EntityItem(world, (double)offset.getX() + 0.5, (double)(offset.getY() + 1), (double)offset.getZ() + 0.5, new ItemStack((Item)WitcheryGeneralItems.HORN_OF_THE_HUNT));
                                    itemEntity.motionZ = motion = 0.0;
                                    itemEntity.motionY = motion;
                                    itemEntity.motionX = motion;
                                    world.spawnEntity((Entity)itemEntity);
                                    itemEntity.world.playSound(null, itemEntity.getPosition(), SoundEvents.BLOCK_FIRE_EXTINGUISH, player.getSoundCategory(), 0.5f, 0.4f / (itemEntity.world.rand.nextFloat() * 0.4f + 0.8f));
                                    WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(itemEntity.posX, itemEntity.posY, itemEntity.posZ, 0.2f, 0.2f, EnumParticleTypes.REDSTONE), (Entity)itemEntity);
                                    transformation.setQuestState(WerewolfTransformation.QuestState.STARTED);
                                    break;
                                }
                                case STARTED: {
                                    player.sendMessage(new TextComponentTranslation("witchery.werewolf.level5progress", new Object[0]).setStyle(new Style().setColor(TextFormatting.GOLD)));
                                    break;
                                }
                                case COMPLETE: {
                                    player.sendMessage(new TextComponentTranslation("witchery.werewolf.level5complete", new Object[0]).setStyle(new Style().setColor(TextFormatting.GOLD)));
                                    world.playSound(null, (double)offset.getX() + 0.5, (double)(offset.getY() + 1), (double)offset.getZ() + 0.5, SoundEvents.ENTITY_PLAYER_LEVELUP, player.getSoundCategory(), 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                                    WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)offset.getX() + 0.5, (double)(offset.getY() + 1), (double)offset.getZ() + 0.5, 0.2f, 0.2f, EnumParticleTypes.REDSTONE), world, (double)offset.getX() + 0.5, offset.getY() + 1, (double)offset.getZ() + 0.5, 16.0);
                                    if (!transformation.levelUp()) break;
                                    playerEx.sync();
                                }
                            }
                            break;
                        }
                        case 5: {
                            int KILLS_REQUIRED = 10;
                            if (transformation.getQuestCount() >= KILLS_REQUIRED) {
                                transformation.setQuestState(WerewolfTransformation.QuestState.COMPLETE);
                            }
                            switch (transformation.getQuestState()) {
                                case NOT_STATED: {
                                    player.sendMessage(new TextComponentTranslation("witchery.werewolf.level6begin", new Object[]{KILLS_REQUIRED}).setStyle(new Style().setColor(TextFormatting.GOLD)));
                                    transformation.setQuestState(WerewolfTransformation.QuestState.STARTED);
                                    break;
                                }
                                case STARTED: {
                                    player.sendMessage(new TextComponentTranslation("witchery.werewolf.level6progress", new Object[]{KILLS_REQUIRED, KILLS_REQUIRED - transformation.getQuestCount()}).setStyle(new Style().setColor(TextFormatting.GOLD)));
                                    break;
                                }
                                case COMPLETE: {
                                    player.sendMessage(new TextComponentTranslation("witchery.werewolf.level6complete", new Object[0]).setStyle(new Style().setColor(TextFormatting.GOLD)));
                                    world.playSound(null, (double)offset.getX() + 0.5, (double)(offset.getY() + 1), (double)offset.getZ() + 0.5, SoundEvents.ENTITY_PLAYER_LEVELUP, player.getSoundCategory(), 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                                    WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)offset.getX() + 0.5, (double)(offset.getY() + 1), (double)offset.getZ() + 0.5, 0.2f, 0.2f, EnumParticleTypes.REDSTONE), world, (double)offset.getX() + 0.5, offset.getY() + 1, (double)offset.getZ() + 0.5, 16.0);
                                    if (!transformation.levelUp()) break;
                                    playerEx.sync();
                                }
                            }
                            break;
                        }
                        case 6: {
                            int PLACES_HOWLED_AT = 16;
                            if (transformation.getQuestCount() >= PLACES_HOWLED_AT) {
                                transformation.setQuestState(WerewolfTransformation.QuestState.COMPLETE);
                            }
                            switch (transformation.getQuestState()) {
                                case NOT_STATED: {
                                    player.sendMessage(new TextComponentTranslation("witchery.werewolf.level7begin", new Object[]{PLACES_HOWLED_AT}).setStyle(new Style().setColor(TextFormatting.GOLD)));
                                    transformation.setQuestState(WerewolfTransformation.QuestState.STARTED);
                                    break;
                                }
                                case STARTED: {
                                    player.sendMessage(new TextComponentTranslation("witchery.werewolf.level7progress", new Object[]{PLACES_HOWLED_AT, PLACES_HOWLED_AT - transformation.getQuestCount()}).setStyle(new Style().setColor(TextFormatting.GOLD)));
                                    break;
                                }
                                case COMPLETE: {
                                    player.sendMessage(new TextComponentTranslation("witchery.werewolf.level7complete", new Object[0]).setStyle(new Style().setColor(TextFormatting.GOLD)));
                                    world.playSound(null, (double)offset.getX() + 0.5, (double)(offset.getY() + 1), (double)offset.getZ() + 0.5, SoundEvents.ENTITY_PLAYER_LEVELUP, player.getSoundCategory(), 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                                    WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)offset.getX() + 0.5, (double)(offset.getY() + 1), (double)offset.getZ() + 0.5, 0.2f, 0.2f, EnumParticleTypes.REDSTONE), world, (double)offset.getX() + 0.5, offset.getY() + 1, (double)offset.getZ() + 0.5, 16.0);
                                    if (!transformation.levelUp()) break;
                                    playerEx.sync();
                                }
                            }
                            break;
                        }
                        case 7: {
                            int WOLVES_TAMED = 6;
                            if (transformation.getQuestCount() >= WOLVES_TAMED) {
                                transformation.setQuestState(WerewolfTransformation.QuestState.COMPLETE);
                            }
                            switch (transformation.getQuestState()) {
                                case NOT_STATED: {
                                    player.sendMessage(new TextComponentTranslation("witchery.werewolf.level8begin", new Object[]{WOLVES_TAMED}).setStyle(new Style().setColor(TextFormatting.GOLD)));
                                    transformation.setQuestState(WerewolfTransformation.QuestState.STARTED);
                                    break;
                                }
                                case STARTED: {
                                    player.sendMessage(new TextComponentTranslation("witchery.werewolf.level8progress", new Object[]{WOLVES_TAMED, WOLVES_TAMED - transformation.getQuestCount()}).setStyle(new Style().setColor(TextFormatting.GOLD)));
                                    break;
                                }
                                case COMPLETE: {
                                    player.sendMessage(new TextComponentTranslation("witchery.werewolf.level8complete", new Object[0]).setStyle(new Style().setColor(TextFormatting.GOLD)));
                                    world.playSound(null, (double)offset.getX() + 0.5, (double)(offset.getY() + 1), (double)offset.getZ() + 0.5, SoundEvents.ENTITY_PLAYER_LEVELUP, player.getSoundCategory(), 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                                    WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)offset.getX() + 0.5, (double)(offset.getY() + 1), (double)offset.getZ() + 0.5, 0.2f, 0.2f, EnumParticleTypes.REDSTONE), world, (double)offset.getX() + 0.5, offset.getY() + 1, (double)offset.getZ() + 0.5);
                                    if (!transformation.levelUp()) break;
                                    playerEx.sync();
                                }
                            }
                            break;
                        }
                        case 8: {
                            int PIGMEN_KILLED = 30;
                            if (transformation.getQuestCount() >= PIGMEN_KILLED) {
                                transformation.setQuestState(WerewolfTransformation.QuestState.COMPLETE);
                            }
                            switch (transformation.getQuestState()) {
                                case NOT_STATED: {
                                    player.sendMessage(new TextComponentTranslation("witchery.werewolf.level9begin", new Object[]{PIGMEN_KILLED}).setStyle(new Style().setColor(TextFormatting.GOLD)));
                                    transformation.setQuestState(WerewolfTransformation.QuestState.STARTED);
                                    break;
                                }
                                case STARTED: {
                                    player.sendMessage(new TextComponentTranslation("witchery.werewolf.level9progress", new Object[]{PIGMEN_KILLED, PIGMEN_KILLED - transformation.getQuestCount()}).setStyle(new Style().setColor(TextFormatting.GOLD)));
                                    break;
                                }
                                case COMPLETE: {
                                    player.sendMessage(new TextComponentTranslation("witchery.werewolf.level9complete", new Object[0]).setStyle(new Style().setColor(TextFormatting.GOLD)));
                                    world.playSound(null, (double)offset.getX() + 0.5, (double)(offset.getY() + 1), (double)offset.getZ() + 0.5, SoundEvents.ENTITY_PLAYER_LEVELUP, player.getSoundCategory(), 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                                    WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)offset.getX() + 0.5, (double)(offset.getY() + 1), (double)offset.getZ() + 0.5, 0.2f, 0.2f, EnumParticleTypes.REDSTONE), world, (double)offset.getX() + 0.5, offset.getY() + 1, (double)offset.getZ() + 0.5);
                                    if (!transformation.levelUp()) break;
                                    playerEx.sync();
                                }
                            }
                            break;
                        }
                        case 9: {
                            int PEOPLE_KILLED = 1;
                            if (transformation.getQuestCount() >= PEOPLE_KILLED) {
                                transformation.setQuestState(WerewolfTransformation.QuestState.COMPLETE);
                            }
                            switch (transformation.getQuestState()) {
                                case NOT_STATED: {
                                    player.sendMessage(new TextComponentTranslation("witchery.werewolf.level10begin", new Object[]{PEOPLE_KILLED}).setStyle(new Style().setColor(TextFormatting.GOLD)));
                                    transformation.setQuestState(WerewolfTransformation.QuestState.STARTED);
                                    break;
                                }
                                case STARTED: {
                                    player.sendMessage(new TextComponentTranslation("witchery.werewolf.level10progress", new Object[]{PEOPLE_KILLED, PEOPLE_KILLED - transformation.getQuestCount()}).setStyle(new Style().setColor(TextFormatting.GOLD)));
                                    break;
                                }
                                case COMPLETE: {
                                    player.sendMessage(new TextComponentTranslation("witchery.werewolf.level10complete", new Object[0]).setStyle(new Style().setColor(TextFormatting.GOLD)));
                                    world.playSound(null, (double)offset.getX() + 0.5, (double)(offset.getY() + 1), (double)offset.getZ() + 0.5, SoundEvents.ENTITY_PLAYER_LEVELUP, player.getSoundCategory(), 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                                    WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)offset.getX() + 0.5, (double)(offset.getY() + 1), (double)offset.getZ() + 0.5, 0.2f, 0.2f, EnumParticleTypes.REDSTONE), world, (double)offset.getX() + 0.5, offset.getY() + 1, (double)offset.getZ() + 0.5);
                                    if (!transformation.levelUp()) break;
                                    playerEx.sync();
                                }
                            }
                            break;
                        }
                        case 10: {
                            WitcheryUtils.playSoundAt(player, WitcherySounds.ENTITY_WEREWOLF_LORD, SoundCategory.BLOCKS, 1.0f, 1.0f);
                            player.sendMessage(new TextComponentTranslation("witchery.werewolf.level10complete", new Object[0]).setStyle(new Style().setColor(TextFormatting.GOLD)));
                        }
                    }
                }
            }
            return true;
        }
        return false;
    }

    public int quantityDropped(Random rand) {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockState blockState, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(IBlockState stateIn, World world, BlockPos pos, Random rand) {
    }

    @Nullable
    public TileEntity createNewTileEntity(World worldIn, int meta) {
        return WitcheryTileEntities.WOLF_ALTAR.create();
    }
}

