/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLilyPad;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class BlockWitchLilyPad
extends BlockLilyPad {
    public static final PropertyInteger GROWTH = PropertyInteger.create((String)"growth", (int)0, (int)4);
    private static final int[][] DIRECTIONS = new int[][]{{-1, -1}, {-1, -1}, {-1, 0}, {-1, 1}, {-1, 1}, {0, -1}, {0, 1}, {1, -1}, {1, -1}, {1, 0}, {1, 1}, {1, 1}};

    public BlockWitchLilyPad() {
        this.setDefaultState(this.getBlockState().getBaseState().withProperty((IProperty)GROWTH, (Comparable)Integer.valueOf(0)));
        this.setSoundType(SoundType.PLANT);
    }

    public void onBlockAdded(World world, BlockPos pos, IBlockState state) {
        world.scheduleUpdate(pos, (Block)this, 20);
    }

    public void updateTick(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.isRemote && this.canSpread(state)) {
            int[] d = DIRECTIONS[world.rand.nextInt(DIRECTIONS.length)];
            BlockPos p = pos.add(d[0], 0, d[1]);
            if (this.canBlockStay(world, p, world.getBlockState(p))) {
                int growth = (Integer)state.getValue((IProperty)GROWTH);
                if (world.rand.nextInt(growth) == 0) {
                    world.setBlockState(pos, state.withProperty((IProperty)GROWTH, (Comparable)Integer.valueOf(growth - 1)), 3);
                }
                world.setBlockState(p, state.withProperty((IProperty)GROWTH, (Comparable)Integer.valueOf(growth - 1)), 3);
            }
            world.scheduleUpdate(pos, (Block)this, 20);
        }
        super.updateTick(world, pos, state, rand);
    }

    private boolean canSpread(IBlockState meta) {
        return (Integer)meta.getValue((IProperty)GROWTH) > 0;
    }

    public int quantityDropped(Random rand) {
        return 1;
    }

    public Item getItemDropped(IBlockState metadata, Random rand, int fortune) {
        return rand.nextInt(4) == 0 ? Item.getItemFromBlock((Block)Blocks.WATERLILY) : null;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(Blocks.WATERLILY);
    }

    protected boolean canSilkHarvest() {
        return false;
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty((IProperty)GROWTH, (Comparable)Integer.valueOf(meta));
    }

    public int getMetaFromState(IBlockState state) {
        return (Integer)state.getValue((IProperty)GROWTH);
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{GROWTH}).build();
    }
}

