/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.List;
import java.util.Random;
import kotlin.jvm.functions.Function0;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.msrandom.witchery.entity.monster.EntityMandrake;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;

public class BlockWitchCrop
extends BlockCrops {
    protected static final PropertyInteger AGE5 = PropertyInteger.create((String)"age", (int)0, (int)5);
    public static final PropertyInteger AGE4 = PropertyInteger.create((String)"age", (int)0, (int)4);
    private final int growthStages;
    private final boolean canFertilize;
    private final Function0<Item> crop;
    private String translationKey;

    public BlockWitchCrop(Function0<Item> crop) {
        this(crop, 4, true);
    }

    public BlockWitchCrop(Function0<Item> crop, int growthStages, boolean canFertilize) {
        this.setDefaultState(this.getDefaultState().withProperty((IProperty)this.getAgeProperty(), (Comparable)Integer.valueOf(0)));
        this.setCreativeTab(WitcheryGeneralItems.TAB);
        this.growthStages = growthStages;
        this.canFertilize = canFertilize;
        this.crop = crop;
    }

    protected PropertyInteger getAgeProperty() {
        return AGE4;
    }

    protected Item getSeed() {
        return Item.getItemFromBlock((Block)this);
    }

    public Item getCrop() {
        return this.crop == null ? this.getSeed() : (Item)this.crop.invoke();
    }

    public int getMaxAge() {
        return this.growthStages;
    }

    protected boolean canSustainBush(IBlockState state) {
        return super.canSustainBush(state) || state.getBlock() == this;
    }

    public void grow(World world, BlockPos pos, IBlockState state) {
        int l;
        if (world.isRemote) {
            return;
        }
        int stages = this.getMaxAge();
        int current = this.getAge(state);
        if (current == stages) {
            return;
        }
        int n = l = this.canFertilize ? current + MathHelper.getInt((Random)world.rand, (int)2, (int)stages) : current + 1;
        if (l > stages) {
            l = stages;
        }
        world.setBlockState(pos, state.withProperty((IProperty)this.getAgeProperty(), (Comparable)Integer.valueOf(l)), 2);
    }

    public void getDrops(NonNullList<ItemStack> ret, IBlockAccess access, BlockPos pos, IBlockState state, int fortune) {
        block7: {
            Random rand;
            block4: {
                World world;
                block5: {
                    block6: {
                        world = access instanceof World ? (World)access : null;
                        Random random = rand = world != null ? world.rand : RANDOM;
                        if (this.getAge(state) < this.getMaxAge()) break block4;
                        if (!(this.getCrop() != WitcheryIngredientItems.MANDRAKE_ROOT || world == null || world.getDifficulty() == EnumDifficulty.PEACEFUL || world.provider.isDaytime() && world.rand.nextDouble() > 0.9) && (world.provider.isDaytime() || !(world.rand.nextDouble() > 0.1))) break block5;
                        if (this != WitcheryBlocks.MANDRAKE_SEEDS) break block6;
                        ret.add((Object)new ItemStack((Block)this));
                        if (rand.nextInt(4) == 0) {
                            ret.add((Object)new ItemStack(this.getCrop()));
                        }
                        break block7;
                    }
                    for (int n = 0; n < 3 + fortune; ++n) {
                        if (rand.nextInt(15) > 7) continue;
                        ret.add((Object)new ItemStack((Block)this));
                    }
                    for (int i = 0; i < this.quantityDropped(rand); ++i) {
                        ret.add((Object)new ItemStack(this.getCrop()));
                    }
                    if (this != WitcheryBlocks.SNOWBELL_SEEDS || !(rand.nextDouble() <= 0.2)) break block7;
                    ret.add((Object)new ItemStack(WitcheryIngredientItems.ICY_NEEDLE));
                    break block7;
                }
                if (world.isRemote) break block7;
                EntityMandrake mandrake = new EntityMandrake(world);
                mandrake.setLocationAndAngles((double)pos.getX() + 0.5, (double)pos.getY() + 0.05, (double)pos.getZ() + 0.5, 0.0f, 0.0f);
                world.spawnEntity((Entity)mandrake);
                WitcheryNetworkChannel.sendToAllTracking(new PacketParticles((Entity)mandrake, 0.5f, 1.0f, EnumParticleTypes.EXPLOSION_NORMAL), (Entity)mandrake);
                break block7;
            }
            for (int i = 0; i < this.quantityDropped(rand); ++i) {
                ret.add((Object)new ItemStack((Block)this));
            }
        }
    }

    public void dropBlockAsItemWithChance(World world, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (!world.isRemote && !world.restoringBlockSnapshots && world.getGameRules().getBoolean("doTileDrops")) {
            NonNullList drops = NonNullList.create();
            this.getDrops((NonNullList<ItemStack>)drops, (IBlockAccess)world, pos, state, fortune);
            chance = ForgeEventFactory.fireBlockHarvesting((List)drops, (World)world, (BlockPos)pos, (IBlockState)state, (int)fortune, (float)chance, (boolean)false, (EntityPlayer)((EntityPlayer)this.harvesters.get()));
            for (ItemStack drop : drops) {
                if (!(world.rand.nextFloat() <= chance)) continue;
                if (((Boolean)captureDrops.get()).booleanValue()) {
                    ((NonNullList)capturedDrops.get()).add((Object)drop);
                    return;
                }
                double f = 0.5;
                double d0 = world.rand.nextDouble() * f + 0.25;
                double d1 = world.rand.nextDouble() * f + 0.25;
                double d2 = world.rand.nextDouble() * f + 0.25;
                EntityItem item = new EntityItem(world, (double)pos.getX() + d0, (double)pos.getY() + d1, (double)pos.getZ() + d2, drop);
                item.setDefaultPickupDelay();
                this.modifyDrop(item);
                world.spawnEntity((Entity)item);
            }
        }
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{this.getAgeProperty()}).build();
    }

    protected void modifyDrop(EntityItem item) {
    }

    public Block setTranslationKey(String translationKey) {
        this.translationKey = translationKey;
        return this;
    }

    public String getTranslationKey() {
        return "item." + this.translationKey;
    }
}

