/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.List;
import java.util.Random;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.entity.TileEntityCauldron;
import net.msrandom.witchery.brewing.EffectLevelCounter;
import net.msrandom.witchery.brewing.ItemKey;
import net.msrandom.witchery.brewing.ModifierYield;
import net.msrandom.witchery.brewing.action.BrewAction;
import net.msrandom.witchery.client.particle.ParticleCauldronBubble;
import net.msrandom.witchery.client.particle.ParticleNaturePower;
import net.msrandom.witchery.common.IPowerSource;
import net.msrandom.witchery.common.PowerSources;
import net.msrandom.witchery.entity.familiar.Familiars;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.init.WitcheryFluids;
import net.msrandom.witchery.init.WitcheryPotionEffects;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.data.WitcheryFamiliars;
import net.msrandom.witchery.init.data.brewing.WitcheryBrewEffects;
import net.msrandom.witchery.init.items.WitcheryEquipmentItems;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.item.ItemBrewBottle;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.resources.BrewActionManager;
import net.msrandom.witchery.util.BlockUtil;
import net.msrandom.witchery.util.WitcheryUtils;
import net.msrandom.witchery.util.damage.BoilDamageSource;
import org.jetbrains.annotations.Nullable;

public class BlockWitchCauldron
extends BlockContainer {
    private static final PropertyInteger LEVEL = PropertyInteger.create((String)"level", (int)0, (int)3);
    private static final AxisAlignedBB NORMAL_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)0.85f, 1.0);
    private static final AxisAlignedBB BOTTOM = WitcheryUtils.getBlockShape(3.0, 0.0, 3.0, 13.0, 1.0, 13.0);
    private static final AxisAlignedBB NORTH = WitcheryUtils.getBlockShape(1.0, 0.0, 1.0, 15.0, 14.0, 2.0);
    private static final AxisAlignedBB SOUTH = WitcheryUtils.getBlockShape(1.0, 0.0, 14.0, 15.0, 14.0, 15.0);
    private static final AxisAlignedBB EAST = WitcheryUtils.getBlockShape(14.0, 0.0, 1.0, 15.0, 14.0, 15.0);
    private static final AxisAlignedBB WEST = WitcheryUtils.getBlockShape(1.0, 0.0, 1.0, 2.0, 14.0, 15.0);
    private static final AxisAlignedBB[] INSIDE_AABB = new AxisAlignedBB[]{WitcheryUtils.getBlockShape(2.0, 1.0, 2.0, 14.0, 5.0, 14.0), WitcheryUtils.getBlockShape(2.0, 1.0, 2.0, 14.0, 9.0, 14.0), WitcheryUtils.getBlockShape(2.0, 1.0, 2.0, 14.0, 13.0, 14.0)};

    public BlockWitchCauldron() {
        super(Material.IRON);
        this.setCreativeTab(WitcheryGeneralItems.TAB);
        this.setDefaultState(this.getBlockState().getBaseState().withProperty((IProperty)LEVEL, (Comparable)Integer.valueOf(0)));
        this.setHardness(2.0f);
        this.setSoundType(SoundType.METAL);
    }

    private static ItemStack consumeItem(ItemStack stack) {
        if (stack.getCount() != 1) {
            return stack.splitStack(1);
        }
        if (stack.getItem().hasContainerItem(stack)) {
            return stack.getItem().getContainerItem(stack);
        }
        return ItemStack.EMPTY;
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        return NORMAL_AABB;
    }

    public EnumBlockRenderType getRenderType(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public void addCollisionBoxToList(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @javax.annotation.Nullable Entity entityIn, boolean isActualState) {
        BlockWitchCauldron.addCollisionBoxToList((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BOTTOM);
        BlockWitchCauldron.addCollisionBoxToList((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)WEST);
        BlockWitchCauldron.addCollisionBoxToList((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)NORTH);
        BlockWitchCauldron.addCollisionBoxToList((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)EAST);
        BlockWitchCauldron.addCollisionBoxToList((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)SOUTH);
    }

    public IBlockState getActualState(IBlockState state, IBlockAccess world, BlockPos position) {
        TileEntityCauldron cauldron = WitcheryTileEntities.CAULDRON.getAt(world, position);
        if (cauldron != null) {
            int level = MathKt.roundToInt((double)(cauldron.getPercentFilled() * 3.0));
            if (cauldron.getLiquidQuantity() != 0 && level == 0) {
                level = 1;
            }
            if (cauldron.getLiquidQuantity() != 3000 && level == 3) {
                level = 2;
            }
            state = state.withProperty((IProperty)LEVEL, (Comparable)Integer.valueOf(level));
        }
        return super.getActualState(state, world, position);
    }

    public int getMetaFromState(IBlockState state) {
        return 0;
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(IBlockState stateIn, World world, BlockPos pos, Random rand) {
        TileEntityCauldron cauldron = WitcheryTileEntities.CAULDRON.getAt((IBlockAccess)world, pos);
        if (cauldron != null && cauldron.isBoiling()) {
            double zPos;
            double xPos;
            double width;
            int i;
            double yPos = cauldron.getPercentFilled() * 0.5 + 0.2;
            int color2 = cauldron.getColor();
            if (color2 == -1) {
                color2 = 3694022;
            } else if (rand.nextInt(5) == 0) {
                world.playSound(null, pos, WitcherySounds.BLOCK_CAULDRON_BLOP, SoundCategory.BLOCKS, 0.8f + rand.nextFloat() * 0.2f, 0.8f + rand.nextFloat() * 0.2f);
            }
            float red = (float)(color2 >>> 16 & 0xFF) / 256.0f;
            float green = (float)(color2 >>> 8 & 0xFF) / 256.0f;
            float blue = (float)(color2 & 0xFF) / 256.0f;
            for (i = 0; i < 2; ++i) {
                width = 0.6;
                xPos = 0.2 + rand.nextDouble() * width;
                zPos = 0.2 + rand.nextDouble() * width;
                ParticleCauldronBubble sparkle = new ParticleCauldronBubble(world, (double)pos.getX() + xPos, (double)pos.getY() + yPos, (double)pos.getZ() + zPos);
                sparkle.setScale(0.4f);
                if (rand.nextInt(4) == 0) {
                    sparkle.setGravity(-0.02f);
                    sparkle.setCanMove(true);
                    sparkle.setMaxAge(15 + rand.nextInt(10));
                } else {
                    sparkle.setGravity(0.0f);
                    sparkle.setCanMove(false);
                    sparkle.setMaxAge(10 + rand.nextInt(10));
                }
                sparkle.setRBGColorF(red, green, blue);
                sparkle.setAlphaF(0.2f);
                Minecraft.getMinecraft().effectRenderer.addEffect((Particle)sparkle);
            }
            if (cauldron.isPowered()) {
                for (i = 0; i < 1 + Math.min(cauldron.getRitualSeconds(), 5); ++i) {
                    width = 0.4;
                    xPos = 0.3 + rand.nextDouble() * width;
                    zPos = 0.3 + rand.nextDouble() * width;
                    double d0 = (double)pos.getX() + xPos;
                    double d2 = (double)pos.getY() + yPos;
                    double d3 = (double)pos.getZ() + zPos;
                    double maxSpeed = 0.04;
                    double doubleSpeed = 0.08;
                    ParticleNaturePower sparkle2 = new ParticleNaturePower(world, d0, d2, d3, rand.nextDouble() * doubleSpeed - maxSpeed, rand.nextDouble() * 0.05 + 0.08, rand.nextDouble() * doubleSpeed - maxSpeed);
                    sparkle2.setCircling(cauldron.isRitualInProgress());
                    sparkle2.setScale(0.6f);
                    sparkle2.setGravity(0.25f);
                    sparkle2.setCanMove(true);
                    sparkle2.setMaxAge(25 + rand.nextInt(10));
                    float maxColorShift = 0.2f;
                    float doubleColorShift = maxColorShift * 2.0f;
                    float colorshiftR = rand.nextFloat() * doubleColorShift - maxColorShift;
                    float colorshiftG = rand.nextFloat() * doubleColorShift - maxColorShift;
                    float colorshiftB = rand.nextFloat() * doubleColorShift - maxColorShift;
                    sparkle2.setRBGColorF(red + colorshiftR, green + colorshiftG, blue + colorshiftB);
                    sparkle2.setAlphaF(0.1f);
                    Minecraft.getMinecraft().effectRenderer.addEffect((Particle)sparkle2);
                }
            }
        }
    }

    public void onEntityCollision(World world, BlockPos pos, IBlockState state, Entity entity) {
        TileEntityCauldron cauldron;
        if (!world.isRemote && (cauldron = WitcheryTileEntities.CAULDRON.getAt((IBlockAccess)world, pos)) != null) {
            if (entity instanceof EntityItem) {
                EntityItem itemEntity = (EntityItem)entity;
                int x = pos.getX();
                int y = pos.getY();
                int z = pos.getZ();
                if (cauldron.isFilled()) {
                    BrewAction brewAction;
                    if (itemEntity.getItem().getItem() == WitcheryIngredientItems.GYPSUM) {
                        entity.setDead();
                        world.playSound(null, pos, SoundEvents.BLOCK_FIRE_EXTINGUISH, SoundCategory.BLOCKS, 1.0f, 2.0f);
                        WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)pos.getX() + 0.5, (double)pos.getY() + 0.6, (double)pos.getZ() + 0.5, 0.5f, 1.0f, EnumParticleTypes.SMOKE_NORMAL), world, pos.getX(), (double)pos.getY() + 0.5, pos.getZ());
                        cauldron.drain(cauldron.getLiquidQuantity(), true);
                        cauldron.notifyBlockUpdate(true);
                    } else if (itemEntity.getItem().getItem() == WitcheryIngredientItems.QUICKLIME) {
                        EntityPlayer nearestPlayer = (EntityPlayer)world.findNearestEntityWithinAABB(EntityPlayer.class, entity.getEntityBoundingBox().expand(5.0, 5.0, 5.0), entity);
                        if (nearestPlayer != null && cauldron.explodeBrew(nearestPlayer)) {
                            WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)pos.getX() + 0.5, (double)pos.getY() + 0.6, (double)pos.getZ() + 0.5, 0.5f, 1.0f, EnumParticleTypes.SMOKE_NORMAL), world, pos.getX(), (double)pos.getY() + 0.5, pos.getZ());
                            cauldron.drain(cauldron.getLiquidQuantity(), true);
                            entity.setDead();
                            cauldron.notifyBlockUpdate(true);
                        }
                    } else if (cauldron.isBoiling() && ((brewAction = BrewActionManager.INSTANCE.getAction(ItemKey.fromStack(itemEntity.getItem()))) != null || cauldron.isItemValidForSlot(-1, itemEntity.getItem())) && cauldron.addItem(brewAction, itemEntity.getItem())) {
                        Item containerItem = itemEntity.getItem().getItem().getContainerItem();
                        if (containerItem != null) {
                            world.spawnEntity((Entity)new EntityItem(world, 0.5 + (double)x, 1.0 + (double)y, 0.5 + (double)z, new ItemStack(containerItem)));
                        }
                        entity.setDead();
                        world.playSound(null, pos, SoundEvents.ENTITY_PLAYER_SPLASH, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                        WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)pos.getX() + 0.5, (double)pos.getY() + 0.6, (double)pos.getZ() + 0.5, 0.5f, 1.0f, EnumParticleTypes.SMOKE_NORMAL), world, pos.getX(), (double)pos.getY() + 0.5, pos.getZ());
                    }
                }
            } else if (entity instanceof EntityPlayer && cauldron.isBoiling() && entity.getEntityBoundingBox().intersects(INSIDE_AABB[(Integer)state.getValue((IProperty)LEVEL)].offset(pos))) {
                entity.attackEntityFrom((DamageSource)new BoilDamageSource(cauldron.getActions()), 1.0f);
            }
        }
    }

    public boolean hasComparatorInputOverride(IBlockState state) {
        return true;
    }

    public int getComparatorInputOverride(IBlockState state, World world, BlockPos pos) {
        TileEntityCauldron cauldron = WitcheryTileEntities.CAULDRON.getAt((IBlockAccess)world, pos);
        int signal = 0;
        if (cauldron != null) {
            return cauldron.getRedstoneSignalStrength();
        }
        return signal;
    }

    public boolean tryFillWith(World world, BlockPos pos, FluidStack fluidStack) {
        if (world.isRemote) {
            return true;
        }
        TileEntityCauldron cauldron = WitcheryTileEntities.CAULDRON.getAt((IBlockAccess)world, pos);
        if (cauldron != null && cauldron.canFill(fluidStack.getFluid())) {
            int quantity = cauldron.fill(fluidStack, true);
            fluidStack.amount -= quantity;
            if (fluidStack.amount < 0) {
                fluidStack.amount = 0;
            }
            if (quantity > 0) {
                world.playSound(null, pos, SoundEvents.ENTITY_PLAYER_SWIM, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                cauldron.notifyBlockUpdate(true);
            }
            return quantity > 0;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntityCauldron cauldron = WitcheryTileEntities.CAULDRON.getAt((IBlockAccess)world, pos);
        ItemStack heldStack = player.getHeldItem(hand);
        if (cauldron == null || heldStack.isEmpty()) return super.onBlockActivated(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
        FluidStack fluidStackToFill = FluidUtil.getFluidContained((ItemStack)heldStack);
        IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)heldStack);
        if (fluidStackToFill != null) {
            int quantityFilled;
            if (world.isRemote) {
                return true;
            }
            if (!cauldron.canFill(fluidStackToFill.getFluid())) return true;
            if (heldStack.hasTagCompound()) {
                fluidStackToFill.tag = heldStack.getTagCompound().copy();
            }
            if ((quantityFilled = cauldron.fill(fluidStackToFill, true)) == 0) return true;
            player.addStat(StatList.CAULDRON_USED);
            boolean drained = player.capabilities.isCreativeMode;
            if (!drained) {
                ItemStack container = heldStack.getItem().getContainerItem(heldStack);
                boolean bl = drained = handler != null && handler.drain(quantityFilled, true) != null;
                if (!container.isEmpty()) {
                    heldStack.shrink(1);
                    if (heldStack.isEmpty()) {
                        player.setHeldItem(hand, container);
                    } else if (!player.inventory.addItemStackToInventory(container)) {
                        player.dropItem(container, false);
                    }
                }
            }
            if (!player.capabilities.isCreativeMode && !drained) return true;
            world.playSound(null, player.getPosition(), SoundEvents.ENTITY_PLAYER_SWIM, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
            cauldron.notifyBlockUpdate(true);
            return true;
        }
        if (heldStack.getItem() == Items.POTIONITEM && PotionUtils.getPotionFromItem((ItemStack)heldStack) == PotionTypes.WATER) {
            if (world.isRemote) {
                return true;
            }
            if (cauldron.getLiquidQuantity() >= 3000 || !cauldron.getActions().actions.isEmpty()) return true;
            if (!player.capabilities.isCreativeMode) {
                ItemStack stack = new ItemStack(Items.GLASS_BOTTLE);
                player.addStat(StatList.CAULDRON_USED);
                player.setHeldItem(hand, stack);
            }
            world.playSound(null, pos, SoundEvents.ITEM_BOTTLE_EMPTY, SoundCategory.BLOCKS, 1.0f, 1.0f);
            cauldron.fill(new FluidStack(FluidRegistry.WATER, 334), true);
            return true;
        }
        FluidStack fluidStackInCauldron = cauldron.getTankProperties()[0].getContents();
        if (handler != null && handler.getTankProperties()[0].getContents() == null) {
            if (fluidStackInCauldron == null) return super.onBlockActivated(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
            if (world.isRemote) {
                return true;
            }
            NBTTagCompound nbtFluid = cauldron.writeFluid(new NBTTagCompound());
            FluidStack drain = cauldron.drain(1000, !player.capabilities.isCreativeMode);
            if (!player.capabilities.isCreativeMode) {
                handler.fill(drain, true);
                if (heldStack.getItem() == Items.BUCKET) {
                    if (fluidStackInCauldron.getFluid() == WitcheryFluids.BREW) {
                        if (WitcheryGeneralItems.BREW_BUCKET.getRegistryName() == null) return true;
                        ItemStack filledBucketStack = new ItemStack((Item)WitcheryGeneralItems.BREW_BUCKET);
                        player.addStat(StatList.CAULDRON_USED);
                        filledBucketStack.setTagCompound(nbtFluid.copy());
                        if (heldStack.getCount() > 1) {
                            if (!player.inventory.addItemStackToInventory(filledBucketStack)) {
                                return false;
                            }
                            player.setHeldItem(hand, BlockWitchCauldron.consumeItem(heldStack));
                        } else {
                            player.setHeldItem(hand, filledBucketStack);
                        }
                    } else {
                        ItemStack filledBucketStack = FluidUtil.getFilledBucket((FluidStack)fluidStackInCauldron);
                        player.addStat(StatList.CAULDRON_USED);
                        if (heldStack.getCount() > 1) {
                            if (!player.inventory.addItemStackToInventory(filledBucketStack)) {
                                return false;
                            }
                            player.setHeldItem(hand, BlockWitchCauldron.consumeItem(heldStack));
                        } else {
                            player.setHeldItem(hand, filledBucketStack);
                        }
                    }
                } else {
                    heldStack.setTagCompound(nbtFluid.copy());
                }
            }
            world.playSound(null, player.getPosition(), SoundEvents.ENTITY_PLAYER_SWIM, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
            cauldron.notifyBlockUpdate(true);
            return super.onBlockActivated(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
        } else {
            ItemStack brewStack;
            boolean enoughLiquid;
            int drainAmount;
            if (heldStack.getItem() != Items.GLASS_BOTTLE) return super.onBlockActivated(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
            if (world.isRemote) {
                return true;
            }
            NBTTagCompound nbtFluid = cauldron.writeFluid(new NBTTagCompound());
            int n = drainAmount = cauldron.getActions().actions.isEmpty() ? RangesKt.coerceAtMost((int)cauldron.getLiquidQuantity(), (int)333) : this.getDrainAmount(player, nbtFluid);
            if (drainAmount <= 0 || !cauldron.isPowered() || !cauldron.isBoiling() || cauldron.isRitualTriggered()) return super.onBlockActivated(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
            boolean bl = enoughLiquid = drainAmount <= cauldron.getLiquidQuantity();
            if (!enoughLiquid) return super.onBlockActivated(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
            IPowerSource source = PowerSources.findClosestPowerSource(cauldron);
            int power = cauldron.getPower();
            if (power != 0 && (source == null || !source.consumePower(cauldron.getPower()))) return super.onBlockActivated(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
            Item result2 = this.getItem(cauldron);
            player.addStat(StatList.CAULDRON_USED);
            cauldron.drain(Math.min(drainAmount, cauldron.getLiquidQuantity()), true);
            world.playSound(null, player.getPosition(), SoundEvents.ENTITY_PLAYER_SWIM, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
            cauldron.notifyBlockUpdate(true);
            if (result2 instanceof ItemBrewBottle) {
                this.processSkillChanges(player, nbtFluid);
                brewStack = new ItemStack(result2);
                brewStack.setTagCompound(nbtFluid.copy());
            } else {
                brewStack = new ItemStack((Item)Items.POTIONITEM);
                PotionUtils.addPotionToItemStack((ItemStack)brewStack, (PotionType)PotionTypes.WATER);
            }
            if (!player.capabilities.isCreativeMode) {
                heldStack.shrink(1);
            }
            if (heldStack.isEmpty()) {
                player.setHeldItem(hand, brewStack);
                return true;
            } else {
                if (player.inventory.addItemStackToInventory(brewStack)) return true;
                player.dropItem(brewStack, false);
            }
            return true;
        }
    }

    public ItemStack fillBottleFromCauldron(World world, BlockPos pos) {
        TileEntityCauldron cauldron = WitcheryTileEntities.CAULDRON.getAt((IBlockAccess)world, pos);
        if (cauldron != null) {
            int drainAmount = cauldron.getActions().actions.isEmpty() ? RangesKt.coerceAtMost((int)cauldron.getLiquidQuantity(), (int)333) : 3000;
            if (cauldron.getLiquidQuantity() > 0 && cauldron.isPowered() && cauldron.isBoiling() && !cauldron.isRitualTriggered()) {
                NBTTagCompound nbtFluid = cauldron.writeFluid(new NBTTagCompound());
                boolean enoughLiquid = drainAmount <= cauldron.getLiquidQuantity();
                Item item = this.getItem(cauldron);
                cauldron.drain(Math.min(drainAmount, cauldron.getLiquidQuantity()), true);
                world.playSound(null, pos, SoundEvents.ENTITY_PLAYER_SWIM, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                cauldron.notifyBlockUpdate(true);
                if (enoughLiquid) {
                    ItemStack brewStack = new ItemStack(item);
                    if (item instanceof ItemBrewBottle) {
                        brewStack.setTagCompound(nbtFluid);
                    }
                    return brewStack;
                }
            }
        }
        return ItemStack.EMPTY;
    }

    private Item getItem(TileEntityCauldron cauldron) {
        if (cauldron.getActions().actions.isEmpty()) {
            return Items.POTIONITEM;
        }
        if (cauldron.isLingering()) {
            return WitcheryGeneralItems.LINGERING_BREW_BOTTLE;
        }
        return cauldron.isSplash() ? WitcheryGeneralItems.SPLASH_BREW_BOTTLE : WitcheryGeneralItems.BREW_BOTTLE;
    }

    private void processSkillChanges(EntityPlayer player, NBTTagCompound nbtBrew) {
        int currentLevel;
        PlayerExtendedData props = WitcheryUtils.getExtension(player);
        EffectLevelCounter levels = WitcheryBrewEffects.getBrewLevel(nbtBrew);
        if (levels.canIncreasePlayerSkill(currentLevel = props.getBottlingSkill())) {
            props.increaseBottlingSkill();
        }
    }

    private int getDrainAmount(EntityPlayer player, NBTTagCompound nbtFluid) {
        ModifierYield yieldModifier = WitcheryBrewEffects.getYieldModifier(nbtFluid);
        int[][] yieldLevels = new int[][]{{1, 3000}, {2, 1500}, {3, 1000}, {4, 750}, {5, 600}, {6, 500}, {8, 375}, {10, 300}, {15, 200}, {30, 100}};
        int yield = 0;
        PlayerExtendedData props = WitcheryUtils.getExtension(player);
        if (props != null) {
            boolean familiarLevel;
            int levelSkill = props.getBottlingSkill() / 30;
            PotionEffect potionEffect = player.getActivePotionEffect(WitcheryPotionEffects.BREWING_EXPERT);
            int levelPotion = potionEffect != null ? potionEffect.getAmplifier() + 1 : 0;
            int gearLevel = 0;
            if (WitcheryEquipmentItems.WITCH_HAT.isHatWorn(player)) {
                ++gearLevel;
            }
            if (WitcheryEquipmentItems.BABAS_HAT.isHatWorn(player)) {
                gearLevel += 2;
            }
            if (WitcheryEquipmentItems.WITCH_ROBES.isRobeWorn(player)) {
                ++gearLevel;
            }
            if (WitcheryEquipmentItems.NECROMANCERS_ROBES.isRobeWorn(player)) {
                ++gearLevel;
            }
            boolean bl = familiarLevel = Familiars.hasFamiliarPower(player, WitcheryFamiliars.BREW_MASTERY);
            if (levelSkill == 1) {
                yield = gearLevel >= 1 || levelPotion >= 1 ? 2 : 1;
            } else if (levelSkill >= 2) {
                yield = gearLevel >= 3 && levelPotion >= 3 && familiarLevel >= true ? 9 : (gearLevel >= 2 && levelPotion >= 3 && familiarLevel >= true ? 8 : (gearLevel >= 2 && levelPotion >= 3 ? 7 : (gearLevel >= 2 && levelPotion >= 2 ? 6 : (gearLevel >= 2 && levelPotion >= 1 ? 5 : (gearLevel >= 2 || levelPotion >= 1 ? 4 : (gearLevel >= 1 ? 3 : 2))))));
            }
        }
        return yieldLevels[Math.max(yield - yieldModifier.getYieldModification(), 0)][1];
    }

    public void fillWithRain(World world, BlockPos position) {
        if (world.rand.nextInt(20) == 1) {
            TileEntityCauldron cauldron;
            float temperature = world.getBiome(position).getTemperature(position);
            if (world.getBiomeProvider().getTemperatureAtHeight(temperature, position.getY()) >= 0.15f && (cauldron = WitcheryTileEntities.CAULDRON.getAt((IBlockAccess)world, position)) != null) {
                cauldron.fill(new FluidStack(FluidRegistry.WATER, 334), true);
                BlockUtil.notifyBlockUpdate(world, position);
            }
        }
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{LEVEL}).build();
    }

    @Nullable
    public TileEntity createNewTileEntity(World worldIn, int meta) {
        return WitcheryTileEntities.CAULDRON.create();
    }
}

