/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockRotatedPillar;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.entity.monster.EntityHornedHuntsman;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;

public class BlockWickerBundle
extends BlockRotatedPillar {
    public BlockWickerBundle() {
        super(Material.WOOD);
        this.setDefaultState(this.getBlockState().getBaseState().withProperty((IProperty)AXIS, (Comparable)EnumFacing.Axis.X));
        this.setHardness(0.5f);
        this.setSoundType(SoundType.PLANT);
        this.setCreativeTab(WitcheryGeneralItems.TAB);
        Blocks.FIRE.setFireInfo((Block)this, 20, 20);
    }

    public static boolean tryIgniteMan(World world, BlockPos pos, float rotationYaw) {
        boolean xleft = world.getBlockState(pos.west()).getBlock() instanceof BlockWickerBundle;
        boolean xright = world.getBlockState(pos.east()).getBlock() instanceof BlockWickerBundle;
        boolean zleft = world.getBlockState(pos.north()).getBlock() instanceof BlockWickerBundle;
        boolean zright = world.getBlockState(pos.south()).getBlock() instanceof BlockWickerBundle;
        BlockPos dp = pos;
        int fz = 0;
        int fx = 0;
        if ((xleft || xright) && (zleft || zright) || !xleft && !xright && !zleft && !zright) {
            return false;
        }
        if (xleft || xright) {
            if (xleft && !xright) {
                dp = dp.east();
            } else if (!xleft) {
                dp = dp.west();
            }
            while (world.getBlockState(dp.down()).getBlock() instanceof BlockWickerBundle) {
                dp = dp.down();
            }
            while (world.getBlockState(dp.west()).getBlock() instanceof BlockWickerBundle) {
                dp = dp.west();
            }
            fx = 1;
        } else {
            if (zleft && !zright) {
                dp = dp.north();
            } else if (!zleft) {
                dp = dp.south();
            }
            while (world.getBlockState(dp.down()).getBlock() instanceof BlockWickerBundle) {
                dp = dp.down();
            }
            while (world.getBlockState(dp.north()).getBlock() instanceof BlockWickerBundle) {
                dp = dp.north();
            }
            fz = 1;
        }
        int dx = dp.getX();
        int dy = dp.getY();
        int dz = dp.getZ();
        if (!BlockWickerBundle.wicker(world, dx, dy + 7, dz) && !BlockWickerBundle.wicker(world, dx + fx, dy + 7, dz + fz) && !BlockWickerBundle.wicker(world, dx - fx, dy + 6, dz - fz) && BlockWickerBundle.wicker(world, dx, dy + 6, dz) && BlockWickerBundle.wicker(world, dx + fx, dy + 6, dz + fz) && !BlockWickerBundle.wicker(world, dx + 2 * fx, dy + 6, dz + 2 * fz) && !BlockWickerBundle.wicker(world, dx - fx, dy + 5, dz - fz) && BlockWickerBundle.wicker(world, dx, dy + 5, dz) && BlockWickerBundle.wicker(world, dx + fx, dy + 5, dz + fz) && !BlockWickerBundle.wicker(world, dx + 2 * fx, dy + 5, dz + 2 * fz) && !BlockWickerBundle.wicker(world, dx - 2 * fx, dy + 4, dz - 2 * fz) && BlockWickerBundle.wicker(world, dx - fx, dy + 4, dz - fz) && BlockWickerBundle.wicker(world, dx, dy + 4, dz) && BlockWickerBundle.wicker(world, dx + fx, dy + 4, dz + fz) && BlockWickerBundle.wicker(world, dx + 2 * fx, dy + 4, dz + 2 * fz) && !BlockWickerBundle.wicker(world, dx + 3 * fx, dy + 4, dz + 3 * fz) && !BlockWickerBundle.wicker(world, dx - 2 * fx, dy + 3, dz - 2 * fz) && BlockWickerBundle.wicker(world, dx - fx, dy + 3, dz - fz) && BlockWickerBundle.wicker(world, dx, dy + 3, dz) && BlockWickerBundle.wicker(world, dx + fx, dy + 3, dz + fz) && BlockWickerBundle.wicker(world, dx + 2 * fx, dy + 3, dz + 2 * fz) && !BlockWickerBundle.wicker(world, dx + 3 * fx, dy + 3, dz + 3 * fz) && !BlockWickerBundle.wicker(world, dx - 2 * fx, dy + 2, dz - 2 * fz) && BlockWickerBundle.wicker(world, dx - fx, dy + 2, dz - fz) && BlockWickerBundle.wicker(world, dx, dy + 2, dz) && BlockWickerBundle.wicker(world, dx + fx, dy + 2, dz + fz) && BlockWickerBundle.wicker(world, dx + 2 * fx, dy + 2, dz + 2 * fz) && !BlockWickerBundle.wicker(world, dx + 3 * fx, dy + 2, dz + 3 * fz) && !BlockWickerBundle.wicker(world, dx - fx, dy + 1, dz - fz) && BlockWickerBundle.wicker(world, dx, dy + 1, dz) && BlockWickerBundle.wicker(world, dx + fx, dy, dz + fz) && !BlockWickerBundle.wicker(world, dx + 2 * fx, dy + 1, dz + 2 * fz) && !BlockWickerBundle.wicker(world, dx - fx, dy, dz - fz) && BlockWickerBundle.wicker(world, dx, dy, dz) && BlockWickerBundle.wicker(world, dx + fx, dy, dz + fz) && !BlockWickerBundle.wicker(world, dx + 2 * fx, dy, dz + 2 * fz)) {
            world.setBlockState(dp.up(6), Blocks.FIRE.getDefaultState());
            world.setBlockState(dp.add(fx, 6, fz), Blocks.FIRE.getDefaultState());
            world.setBlockState(dp.up(3), Blocks.FIRE.getDefaultState());
            world.setBlockState(dp.add(fx, 3, fz), Blocks.FIRE.getDefaultState());
            world.setBlockState(dp.up(2), Blocks.FIRE.getDefaultState());
            world.setBlockState(dp.add(fx, 2, fz), Blocks.FIRE.getDefaultState());
            world.setBlockState(dp.up(), Blocks.FIRE.getDefaultState());
            world.setBlockState(dp.add(fx, 1, fz), Blocks.FIRE.getDefaultState());
            world.setBlockState(dp, Blocks.FIRE.getDefaultState());
            world.setBlockState(dp.add(fx, 0, fz), Blocks.FIRE.getDefaultState());
            world.setBlockState(dp.add(-fx, 4, -fz), Blocks.FIRE.getDefaultState());
            world.setBlockState(dp.add(2 * fx, 4, 2 * fz), Blocks.FIRE.getDefaultState());
            EntityHornedHuntsman entity = new EntityHornedHuntsman(world);
            entity.setLocationAndAngles((double)dx + 1.0 * (double)fx + 0.5 * (double)fz, (double)dy + 0.1, (double)dz + 1.0 * (double)fz + 0.5 * (double)fx, 180.0f + rotationYaw, 0.0f);
            entity.rotationYawHead = entity.rotationYaw;
            entity.renderYawOffset = entity.rotationYaw;
            entity.enablePersistence();
            entity.ignite();
            entity.playLivingSound();
            if (!world.isRemote) {
                world.spawnEntity((Entity)entity);
            }
            for (int j1 = 0; j1 < 120; ++j1) {
                world.spawnParticle(EnumParticleTypes.SNOWBALL, (double)dp.getX() + world.rand.nextDouble(), (double)(dp.getY() - 2) + world.rand.nextDouble() * 3.9, (double)(dp.getZ() + 1) + world.rand.nextDouble(), 0.0, 0.0, 0.0, new int[0]);
            }
        }
        return true;
    }

    private static boolean wicker(World world, int x, int y, int z) {
        return world.getBlockState(new BlockPos(x, y, z)).getBlock() instanceof BlockWickerBundle;
    }

    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.getHeldItem(hand);
        return heldItem.getItem() == Items.FLINT_AND_STEEL && BlockWickerBundle.tryIgniteMan(world, pos, player.rotationYaw);
    }

    public IBlockState getStateFromMeta(int meta) {
        IBlockState iblockstate = this.getDefaultState();
        switch (meta & 3) {
            default: {
                iblockstate = iblockstate.withProperty((IProperty)AXIS, (Comparable)EnumFacing.Axis.X);
                break;
            }
            case 1: {
                iblockstate = iblockstate.withProperty((IProperty)AXIS, (Comparable)EnumFacing.Axis.Y);
                break;
            }
            case 2: {
                iblockstate = iblockstate.withProperty((IProperty)AXIS, (Comparable)EnumFacing.Axis.Z);
            }
        }
        return iblockstate;
    }

    public int getMetaFromState(IBlockState state) {
        int i;
        switch ((EnumFacing.Axis)state.getValue((IProperty)AXIS)) {
            default: {
                i = 0;
                break;
            }
            case Y: {
                i = 1;
                break;
            }
            case Z: {
                i = 2;
            }
        }
        return i;
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{AXIS}).build();
    }
}

