/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.entity.TileEntityVoidBramble;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.item.ingredients.WitcheryIngredientItem;

public class BlockVoidBramble
extends BlockContainer {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.050000011920928955, 0.0, 0.050000011920928955, (double)0.95f, 1.0, (double)0.95f);

    public BlockVoidBramble() {
        super(Material.PLANTS);
        this.setBlockUnbreakable();
        this.setResistance(1000.0f);
        this.setLightLevel(0.125f);
        this.setSoundType(SoundType.PLANT);
        this.setCreativeTab(WitcheryGeneralItems.TAB);
    }

    public static void teleportRandomly(World world, BlockPos pos, Entity entity, int distance) {
        int doubleDistance = distance * 2;
        pos = pos.add(world.rand.nextInt(doubleDistance) - distance, 0, world.rand.nextInt(doubleDistance) - distance);
        int maxY = Math.min(pos.getY() + 64, 250);
        while (!world.getBlockState(pos).getMaterial().isSolid() && pos.getY() >= 0) {
            pos = pos.down();
        }
        while (!(world.getBlockState(pos).getMaterial().isSolid() && world.getBlockState(pos).getBlock() != Blocks.BEDROCK && world.isAirBlock(pos.up()) && world.isAirBlock(pos.up(2)) && world.isAirBlock(pos.up(3)) || pos.getY() >= maxY)) {
            pos = pos.up();
        }
        if (pos.getY() > 0 && pos.getY() < maxY) {
            WitcheryIngredientItem.teleportToLocation(pos.up(), world.provider.getDimension(), entity, true);
        }
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public AxisAlignedBB getCollisionBoundingBox(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return NULL_AABB;
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public void onEntityCollision(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!world.isRemote && entity instanceof EntityLivingBase) {
            BlockVoidBramble.teleportRandomly(world, pos, entity, 500);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(IBlockState stateIn, World world, BlockPos pos, Random rand) {
        if (rand.nextBoolean()) {
            double d0 = (float)pos.getX() + rand.nextFloat();
            double d2 = (double)((float)pos.getY() + 0.15f + rand.nextFloat() * 0.3f) + 0.5;
            double d3 = (float)pos.getZ() + rand.nextFloat();
            world.spawnParticle(EnumParticleTypes.PORTAL, d0, d2, d3, 0.0, -1.2, 0.0, new int[0]);
        }
    }

    public void onBlockClicked(World world, BlockPos pos, EntityPlayer player) {
        TileEntityVoidBramble tile;
        if (!world.isRemote && (tile = WitcheryTileEntities.VOID_BRAMBLE.getAt((IBlockAccess)world, pos)) != null && (player.capabilities.isCreativeMode || player.getName().equals(tile.getOwner()))) {
            BlockPos dy = pos;
            while (world.getBlockState(dy).getBlock() == this) {
                world.setBlockToAir(dy);
                world.spawnEntity((Entity)new EntityItem(world, 0.5 + (double)dy.getX(), 0.5 + (double)dy.getY(), 0.5 + (double)dy.getZ(), new ItemStack((Block)this)));
                dy = dy.up();
            }
        }
    }

    public void onBlockPlacedBy(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        if (!world.isRemote && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            TileEntityVoidBramble tile = WitcheryTileEntities.VOID_BRAMBLE.getAt((IBlockAccess)world, pos);
            if (tile != null) {
                tile.setOwner(player.getName());
            }
        }
    }

    public TileEntity createNewTileEntity(World world, int metadata) {
        return WitcheryTileEntities.VOID_BRAMBLE.create();
    }

    public EnumBlockRenderType getRenderType(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public BlockRenderLayer getRenderLayer() {
        return BlockRenderLayer.CUTOUT;
    }
}

