/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBreakable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.init.WitcheryDimensions;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.world.dimension.torment.TormentWorldData;
import net.msrandom.witchery.world.dimension.torment.WorldProviderTorment;

public class BlockTormentPortal
extends BlockBreakable {
    private static final PropertyEnum<EnumFacing.Axis> AXIS = PropertyEnum.create((String)"axis", EnumFacing.Axis.class, (Enum[])new EnumFacing.Axis[]{EnumFacing.Axis.X, EnumFacing.Axis.Z});
    private static final AxisAlignedBB X_AABB = new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.0, 0.625);
    private static final AxisAlignedBB Z_AABB = new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.0, 1.0);
    private static final double MORE_TORMENT_CHANCE = 0.05;

    public BlockTormentPortal() {
        super(Material.PORTAL, false);
        this.setDefaultState(this.blockState.getBaseState().withProperty(AXIS, (Comparable)EnumFacing.Axis.X));
        this.setTickRandomly(true);
        this.setBlockUnbreakable();
        this.setResistance(9999.0f);
        this.setSoundType(SoundType.GLASS);
        this.setLightLevel(0.75f);
        this.setCreativeTab(WitcheryGeneralItems.TAB);
    }

    public int getMetaFromState(IBlockState state) {
        return 0;
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{AXIS}).build();
    }

    public AxisAlignedBB getCollisionBoundingBox(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return NULL_AABB;
    }

    public IBlockState getActualState(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.withProperty(AXIS, (Comparable)(world.getBlockState(pos.west()).getBlock() == Blocks.AIR && world.getBlockState(pos.east()).getBlock() == Blocks.AIR ? EnumFacing.Axis.Z : EnumFacing.Axis.X));
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing.Axis)state.getValue(AXIS)) {
            default: {
                return X_AABB;
            }
            case Z: 
        }
        return Z_AABB;
    }

    public void neighborChanged(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.neighborChanged(state, worldIn, pos, blockIn, fromPos);
        worldIn.setBlockState(pos, this.getActualState(state, (IBlockAccess)worldIn, pos));
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockState blockState, IBlockAccess par1IBlockAccess, BlockPos pos, EnumFacing par5) {
        if (par1IBlockAccess.getBlockState(pos).getBlock() == this) {
            return false;
        }
        boolean flag = par1IBlockAccess.getBlockState(pos.west()).getBlock() == this && par1IBlockAccess.getBlockState(pos.west(2)).getBlock() != this;
        boolean flag2 = par1IBlockAccess.getBlockState(pos.east()).getBlock() == this && par1IBlockAccess.getBlockState(pos.east(2)).getBlock() != this;
        boolean flag3 = par1IBlockAccess.getBlockState(pos.north()).getBlock() == this && par1IBlockAccess.getBlockState(pos.north(2)).getBlock() != this;
        boolean flag4 = par1IBlockAccess.getBlockState(pos.south()).getBlock() == this && par1IBlockAccess.getBlockState(pos.south(2)).getBlock() != this;
        boolean flag5 = flag || flag2;
        boolean flag6 = flag3 || flag4;
        return flag5 && par5 == EnumFacing.WEST || flag5 && par5 == EnumFacing.EAST || flag6 && par5 == EnumFacing.NORTH || flag6 && par5 == EnumFacing.SOUTH;
    }

    public int quantityDropped(Random par1Random) {
        return 0;
    }

    public void onEntityCollision(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!world.isRemote && entity instanceof EntityPlayer && entity.getRidingEntity() == null && entity.getPassengers().isEmpty()) {
            if (!WitcheryDimensions.TORMENT.isInDimension(entity) || world.rand.nextDouble() < 0.05) {
                WorldProviderTorment.setPlayerMustTorment((EntityPlayer)entity, TormentWorldData.TormentType.BEGIN, 1);
            } else {
                WorldProviderTorment.setPlayerMustTorment((EntityPlayer)entity, TormentWorldData.TormentType.END, 0);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(IBlockState state, World par1World, BlockPos pos, Random par5Random) {
        if (par5Random.nextInt(100) == 0) {
            par1World.playSound(null, pos, SoundEvents.BLOCK_PORTAL_AMBIENT, SoundCategory.BLOCKS, 0.5f, par5Random.nextFloat() * 0.4f + 0.8f);
        }
        for (int l = 0; l < 2; ++l) {
            double d0 = (float)pos.getX() + par5Random.nextFloat();
            double d2 = (float)pos.getY() + par5Random.nextFloat();
            double d3 = (float)pos.getZ() + par5Random.nextFloat();
            par1World.spawnParticle(EnumParticleTypes.FLAME, d0, d2, d3, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return ItemStack.EMPTY;
    }
}

