/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockDaylightDetector;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;

public class BlockSunCollector
extends Block {
    private static final PropertyInteger POWER = PropertyInteger.create((String)"power", (int)0, (int)15);
    private static final AxisAlignedBB AABB = new AxisAlignedBB((double)0.2f, 0.0, (double)0.2f, (double)0.8f, (double)0.8f, (double)0.8f);
    private static final EnumFacing[] HORIZONTAL = EnumFacing.Plane.HORIZONTAL.facings();

    public BlockSunCollector() {
        super(Material.IRON);
        this.setDefaultState(this.getBlockState().getBaseState().withProperty((IProperty)POWER, (Comparable)Integer.valueOf(0)));
        this.setHardness(3.5f);
        this.setSoundType(SoundType.METAL);
        this.setCreativeTab(WitcheryGeneralItems.TAB);
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer getRenderLayer() {
        return BlockRenderLayer.CUTOUT;
    }

    public BlockFaceShape getBlockFaceShape(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public void neighborChanged(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        int meta;
        if (!world.isRemote && (meta = ((Integer)state.getValue((IProperty)POWER)).intValue()) > 0 && meta < 15) {
            for (EnumFacing direction : HORIZONTAL) {
                BlockPos other = pos.offset(direction);
                IBlockState otherState = world.getBlockState(other);
                Block otherBlock = otherState.getBlock();
                if (!(otherBlock instanceof BlockDaylightDetector)) continue;
                int power = otherState.getWeakPower((IBlockAccess)world, other, direction);
                if (power != meta + 1) break;
                world.setBlockState(pos, state.withProperty((IProperty)POWER, (Comparable)Integer.valueOf(meta + 1)), 3);
                break;
            }
        }
    }

    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.isRemote) {
            int meta = (Integer)state.getValue((IProperty)POWER);
            if (meta == 0) {
                ItemStack stack = player.getHeldItem(hand);
                if (stack.getItem() == WitcheryIngredientItems.QUARTZ_SPHERE) {
                    stack.shrink(1);
                    world.setBlockState(pos, state.withProperty((IProperty)POWER, (Comparable)Integer.valueOf(1)), 3);
                }
            } else if (meta < 15) {
                player.dropItem(new ItemStack(WitcheryIngredientItems.QUARTZ_SPHERE), false);
                world.setBlockState(pos, state.withProperty((IProperty)POWER, (Comparable)Integer.valueOf(0)), 3);
            } else if (meta == 15) {
                player.dropItem(new ItemStack((Item)WitcheryGeneralItems.SUN_GRENADE), false);
                world.setBlockState(pos, state.withProperty((IProperty)POWER, (Comparable)Integer.valueOf(0)), 3);
            }
            return true;
        }
        return true;
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty((IProperty)POWER, (Comparable)Integer.valueOf(meta));
    }

    public int getMetaFromState(IBlockState state) {
        return (Integer)state.getValue((IProperty)POWER);
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{POWER}).build();
    }
}

