/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.TileEntityWorshipStatue;
import net.msrandom.witchery.entity.EntityGoblin;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.item.ItemQuartzGrenade;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import org.jetbrains.annotations.Nullable;

public class BlockStatueOfWorship
extends BlockContainer {
    private static final PropertyDirection FACING = BlockHorizontal.FACING;

    public BlockStatueOfWorship() {
        super(Material.ROCK);
        this.setCreativeTab(WitcheryGeneralItems.TAB);
        this.setDefaultState(this.getDefaultState().withProperty((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.setHardness(3.5f);
        this.setResistance(20.0f);
        this.setSoundType(SoundType.STONE);
    }

    private static UUID getBoundPlayer(ItemStack stack) {
        NBTTagCompound nbtRoot = stack.getTagCompound();
        if (nbtRoot != null) {
            return nbtRoot.getUniqueId("BoundPlayer");
        }
        return null;
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean shouldSideBeRendered(IBlockState blockState, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public void onBlockPlacedBy(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        UUID playerName;
        NBTTagCompound nbtRoot;
        TileEntityWorshipStatue tile;
        worldIn.setBlockState(pos, state.withProperty((IProperty)FACING, (Comparable)EnumFacing.byHorizontalIndex((int)(MathHelper.floor((double)((double)(placer.rotationYaw * 4.0f / 360.0f) + 0.5)) & 3)).getOpposite()));
        if (!stack.isEmpty() && placer instanceof EntityPlayer && (tile = WitcheryTileEntities.WORSHIP_STATUE.getAt((IBlockAccess)worldIn, pos)) != null && (nbtRoot = stack.getTagCompound()) != null && nbtRoot.hasUniqueId("BoundPlayer") && (playerName = nbtRoot.getUniqueId("BoundPlayer")) != null) {
            tile.setOwnerId(playerName);
        }
    }

    public IBlockState getStateForPlacement(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.getDefaultState().withProperty((IProperty)FACING, (Comparable)placer.getHorizontalFacing());
    }

    public int getMetaFromState(IBlockState state) {
        return ((EnumFacing)state.getValue((IProperty)FACING)).getHorizontalIndex();
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty((IProperty)FACING, (Comparable)EnumFacing.byHorizontalIndex((int)(meta & 3)));
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{FACING}).build();
    }

    public IBlockState withRotation(IBlockState state, Rotation rot) {
        return state.withProperty((IProperty)FACING, (Comparable)rot.rotate((EnumFacing)state.getValue((IProperty)FACING)));
    }

    public IBlockState withMirror(IBlockState state, Mirror mirrorIn) {
        return state.withRotation(mirrorIn.toRotation((EnumFacing)state.getValue((IProperty)FACING)));
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileEntityWorshipStatue tile = WitcheryTileEntities.WORSHIP_STATUE.getAt(world, pos);
        if (tile != null) {
            ItemStack stack = new ItemStack((Block)this);
            NBTTagCompound nbtRoot = new NBTTagCompound();
            stack.setTagCompound(nbtRoot);
            if (tile.getOwnerId() != null) {
                nbtRoot.setUniqueId("BoundPlayer", tile.getOwnerId());
            }
            drops.add((Object)stack);
        }
    }

    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.isRemote) {
            int worshippers;
            TileEntityWorshipStatue tile;
            ItemStack item = player.getHeldItem(hand);
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            if (item.getItem() == Items.NETHER_STAR && (tile = WitcheryTileEntities.WORSHIP_STATUE.getAt((IBlockAccess)world, pos)) != null && tile.getOwnerId() != null && tile.getOwnerId().equals(player.getUniqueID()) && (worshippers = tile.updateWorshippersAndGetLevel()) >= 5 && tile.summonGoblinGods(player, 16.0, 8)) {
                if (!player.capabilities.isCreativeMode) {
                    item.shrink(1);
                    double R = 8.0;
                    AxisAlignedBB bb = new AxisAlignedBB((double)x + 0.5 - R, (double)y + 0.5 - R, (double)z + 0.5 - R, (double)x + 0.5 + R, (double)y + 0.5 + R, (double)z + 0.5 + R);
                    List entities = world.getEntitiesWithinAABB(EntityGoblin.class, bb);
                    int iMax = Math.min(entities.size(), 5);
                    for (int i = 0; i < iMax; ++i) {
                        EntityGoblin goblin = (EntityGoblin)entities.get(i);
                        goblin.attackEntityFrom(DamageSource.MAGIC, goblin.getMaxHealth());
                    }
                }
                world.playSound(null, 0.5 + (double)x, 0.5 + (double)y, 0.5 + (double)z, SoundEvents.ENTITY_ENDERDRAGON_GROWL, player.getSoundCategory(), 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                WitcheryNetworkChannel.sendToAllAround(new PacketParticles(0.5 + (double)x, 0.5 + (double)y, 0.5 + (double)z, 0.5f, 0.5f, EnumParticleTypes.FLAME), world, 0.5 + (double)x, 0.5 + (double)y, 0.5 + (double)z);
                return true;
            }
            world.playSound(null, 0.5 + (double)x, 0.5 + (double)y, 0.5 + (double)z, SoundEvents.BLOCK_NOTE_SNARE, player.getSoundCategory(), 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
            WitcheryNetworkChannel.sendToAllAround(new PacketParticles(0.5 + (double)x, 0.5 + (double)y, 0.5 + (double)z, 0.5f, 0.5f, EnumParticleTypes.SMOKE_NORMAL), world, 0.5 + (double)x, 0.5 + (double)y, 0.5 + (double)z);
        }
        return false;
    }

    @Nullable
    public TileEntity createNewTileEntity(World worldIn, int meta) {
        return WitcheryTileEntities.WORSHIP_STATUE.create();
    }

    public static class ClassItemBlock
    extends ItemBlock {
        public ClassItemBlock(Block block) {
            super(block);
        }

        public void addInformation(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
            super.addInformation(stack, world, tooltip, flag);
            UUID boundPlayer = BlockStatueOfWorship.getBoundPlayer(stack);
            if (world != null && boundPlayer != null) {
                EntityPlayer player;
                String name2 = ItemQuartzGrenade.NAME_CACHE.get(boundPlayer);
                if (name2 == null && (player = world.getPlayerEntityByUUID(boundPlayer)) != null) {
                    name2 = player.getName();
                    ItemQuartzGrenade.NAME_CACHE.put(boundPlayer, name2);
                }
                if (name2 != null) {
                    tooltip.add(TextFormatting.LIGHT_PURPLE + name2);
                }
            }
        }
    }
}

