/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.entity.TileEntityStatueGoddess;
import net.msrandom.witchery.extensions.LivingExtendedData;
import net.msrandom.witchery.init.WitcheryDataExtensions;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.rite.curse.Curse;

public class BlockStatueGoddess
extends BlockContainer {
    private static final PropertyDirection FACING = BlockHorizontal.FACING;
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, (double)0.1f, 1.0, 2.0, (double)0.9f);

    public BlockStatueGoddess() {
        super(Material.ROCK);
        this.setCreativeTab(WitcheryGeneralItems.TAB);
        this.setDefaultState(this.getBlockState().getBaseState().withProperty((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.setBlockUnbreakable();
        this.setResistance(1000.0f);
        this.setHardness(2.5f);
        this.setSoundType(SoundType.STONE);
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public IBlockState getStateForPlacement(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.getDefaultState().withProperty((IProperty)FACING, (Comparable)placer.getHorizontalFacing());
    }

    public void onBlockPlacedBy(World par1World, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        par1World.setBlockState(pos, state.withProperty((IProperty)FACING, (Comparable)EnumFacing.byHorizontalIndex((int)(MathHelper.floor((double)((double)(placer.rotationYaw * 4.0f / 360.0f) + 0.5)) & 3)).getOpposite()));
        if (!par1World.isRemote && placer instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)placer;
            TileEntityStatueGoddess tile = WitcheryTileEntities.GODDESS_STATUE.getAt((IBlockAccess)par1World, pos);
            if (tile != null) {
                tile.setOwner(player.getName());
            }
        }
    }

    public IBlockState getStateFromMeta(int meta) {
        EnumFacing enumfacing = EnumFacing.byIndex((int)meta);
        if (enumfacing.getAxis() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.getDefaultState().withProperty((IProperty)FACING, (Comparable)enumfacing);
    }

    public int getMetaFromState(IBlockState state) {
        return ((EnumFacing)state.getValue((IProperty)FACING)).getIndex();
    }

    public IBlockState withRotation(IBlockState state, Rotation rot) {
        return state.withProperty((IProperty)FACING, (Comparable)rot.rotate((EnumFacing)state.getValue((IProperty)FACING)));
    }

    public IBlockState withMirror(IBlockState state, Mirror mirrorIn) {
        return state.withRotation(mirrorIn.toRotation((EnumFacing)state.getValue((IProperty)FACING)));
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{FACING}).build();
    }

    public void onBlockClicked(World world, BlockPos pos, EntityPlayer player) {
        TileEntityStatueGoddess tile;
        if (!world.isRemote && (tile = WitcheryTileEntities.GODDESS_STATUE.getAt((IBlockAccess)world, pos)) != null && (player.capabilities.isCreativeMode || player.getName().equals(tile.getOwner()) && player.isSneaking())) {
            BlockPos p = pos;
            while (world.getBlockState(p).getBlock() == this) {
                world.setBlockToAir(p);
                world.spawnEntity((Entity)new EntityItem(world, 0.5 + (double)p.getX(), 0.5 + (double)p.getY(), 0.5 + (double)p.getZ(), new ItemStack((Block)this)));
                p = p.up();
            }
        }
    }

    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.isRemote) {
            LivingExtendedData livingData = WitcheryDataExtensions.LIVING.get((EntityLivingBase)player);
            if (!livingData.getCurses().isEmpty()) {
                boolean cured = false;
                for (Map.Entry entry2 : Curse.REGISTRY) {
                    if (!livingData.getCurses().containsKey(entry2.getValue())) continue;
                    livingData.getCurses().removeInt(entry2.getValue());
                    player.sendMessage(new TextComponentTranslation("curse." + ((ResourceLocation)entry2.getKey()).getNamespace() + "." + ((ResourceLocation)entry2.getKey()).getPath() + ".goddess_removal", new Object[0]).setStyle(new Style().setColor(TextFormatting.BLUE)));
                    cured = true;
                }
                if (cured) {
                    livingData.syncCurses();
                }
                if (player.isPotionActive(MobEffects.POISON)) {
                    player.removePotionEffect(MobEffects.POISON);
                }
                if (player.isPotionActive(MobEffects.WEAKNESS)) {
                    player.removePotionEffect(MobEffects.WEAKNESS);
                }
                if (player.isPotionActive(MobEffects.BLINDNESS)) {
                    player.removePotionEffect(MobEffects.BLINDNESS);
                }
                if (player.isPotionActive(MobEffects.MINING_FATIGUE)) {
                    player.removePotionEffect(MobEffects.MINING_FATIGUE);
                }
                if (player.isPotionActive(MobEffects.SLOWNESS)) {
                    player.removePotionEffect(MobEffects.SLOWNESS);
                }
                player.playSound(SoundEvents.BLOCK_FIRE_EXTINGUISH, 0.5f, 0.4f / (player.world.rand.nextFloat() * 0.4f + 0.8f));
                WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(player.posX, player.posY, player.posZ, 1.0f, 2.0f, EnumParticleTypes.SPELL_INSTANT), (Entity)player);
            } else {
                world.playSound(null, player.getPosition(), SoundEvents.BLOCK_NOTE_SNARE, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
            }
            return true;
        }
        return super.onBlockActivated(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public int quantityDropped(Random rand) {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return false;
    }

    public TileEntity createNewTileEntity(World worldIn, int meta) {
        return WitcheryTileEntities.GODDESS_STATUE.create();
    }
}

