/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBreakable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryDimensions;
import net.msrandom.witchery.util.WitcheryUtils;
import net.msrandom.witchery.world.dimension.spirit.WorldProviderSpiritWorld;

public class BlockSpiritPortal
extends BlockBreakable {
    private static final PropertyEnum<EnumFacing.Axis> AXIS = PropertyEnum.create((String)"axis", EnumFacing.Axis.class, (Enum[])new EnumFacing.Axis[]{EnumFacing.Axis.X, EnumFacing.Axis.Z});
    private static final AxisAlignedBB X_AABB = new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.0, 0.625);
    private static final AxisAlignedBB Z_AABB = new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.0, 1.0);
    private final Block portalFrameBlock;

    public BlockSpiritPortal(Block portalFrameBlock) {
        super(Material.PORTAL, false);
        this.setDefaultState(this.blockState.getBaseState().withProperty(AXIS, (Comparable)EnumFacing.Axis.X));
        this.setTickRandomly(true);
        this.portalFrameBlock = portalFrameBlock;
        this.setHardness(-1.0f);
        this.setSoundType(SoundType.GLASS);
        this.setLightLevel(0.75f);
    }

    public int getMetaFromState(IBlockState state) {
        return 0;
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{AXIS}).build();
    }

    public AxisAlignedBB getCollisionBoundingBox(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return NULL_AABB;
    }

    public IBlockState getActualState(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.withProperty(AXIS, (Comparable)(world.getBlockState(pos.west()).getBlock() != this && world.getBlockState(pos.east()).getBlock() != this ? EnumFacing.Axis.Z : EnumFacing.Axis.X));
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        return state.getValue(AXIS) == EnumFacing.Axis.X ? X_AABB : Z_AABB;
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public void neighborChanged(IBlockState state, World par1World, BlockPos pos, Block blockIn, BlockPos fromPos) {
        int b0 = 0;
        int b2 = 1;
        if (par1World.getBlockState(pos.west()).getBlock() == this || par1World.getBlockState(pos.east()).getBlock() == this) {
            b0 = 1;
            b2 = 0;
        }
        BlockPos i1 = pos;
        while (par1World.getBlockState(i1.down()).getBlock() == this) {
            i1 = i1.down();
        }
        if (par1World.getBlockState(i1.down()).getBlock() != this.portalFrameBlock) {
            par1World.setBlockToAir(pos);
        } else {
            int j1;
            for (j1 = 1; j1 < 3 && par1World.getBlockState(i1.up(j1)).getBlock() == this; ++j1) {
            }
            if (j1 == 2 && par1World.getBlockState(i1.up(j1)).getBlock() == this.portalFrameBlock) {
                boolean flag2;
                boolean flag = par1World.getBlockState(pos.west()).getBlock() == this || par1World.getBlockState(pos.east()).getBlock() == this;
                boolean bl = flag2 = par1World.getBlockState(pos.north()).getBlock() == this || par1World.getBlockState(pos.south()).getBlock() == this;
                if (flag && flag2) {
                    par1World.setBlockToAir(pos);
                } else if (par1World.getBlockState(pos.add(b0, 0, b2)).getBlock() != this.portalFrameBlock && par1World.getBlockState(pos.add(-b0, 0, -b2)).getBlock() != this.portalFrameBlock) {
                    par1World.setBlockToAir(pos);
                }
            } else {
                par1World.setBlockToAir(pos);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockState blockState, IBlockAccess par1IBlockAccess, BlockPos pos, EnumFacing par5) {
        if (par1IBlockAccess.getBlockState(pos).getBlock() == this) {
            return false;
        }
        boolean flag = par1IBlockAccess.getBlockState(pos.west()).getBlock() == this && par1IBlockAccess.getBlockState(pos.west(2)).getBlock() != this;
        boolean flag2 = par1IBlockAccess.getBlockState(pos.east()).getBlock() == this && par1IBlockAccess.getBlockState(pos.east(2)).getBlock() != this;
        boolean flag3 = par1IBlockAccess.getBlockState(pos.north()).getBlock() == this && par1IBlockAccess.getBlockState(pos.north(2)).getBlock() != this;
        boolean flag4 = par1IBlockAccess.getBlockState(pos.south()).getBlock() == this && par1IBlockAccess.getBlockState(pos.south(2)).getBlock() != this;
        boolean flag5 = flag || flag2;
        boolean flag6 = flag3 || flag4;
        return flag5 && par5 == EnumFacing.WEST || flag5 && par5 == EnumFacing.EAST || flag6 && par5 == EnumFacing.NORTH || flag6 && par5 == EnumFacing.SOUTH;
    }

    public int quantityDropped(Random par1Random) {
        return 0;
    }

    public void onEntityCollision(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!world.isRemote && entity instanceof EntityPlayer && WitcheryDimensions.SPIRIT_WORLD.isInDimension(entity) && entity.getRidingEntity() == null && entity.getPassengers().isEmpty() && WitcheryUtils.getExtension((EntityPlayer)entity).getSpiritData().getManifestationDuration() >= 5) {
            WorldProviderSpiritWorld.manifestPlayerInOverworldAsGhost((EntityPlayer)entity);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(IBlockState state, World par1World, BlockPos pos, Random par5Random) {
        for (int l = 0; l < 2; ++l) {
            double d0 = (float)pos.getX() + par5Random.nextFloat();
            double d2 = (float)pos.getY() + par5Random.nextFloat();
            double d3 = (float)pos.getZ() + par5Random.nextFloat();
            int i1 = par5Random.nextInt(2) * 2 - 1;
            double d4 = ((double)par5Random.nextFloat() - 0.5) * 0.5;
            double d5 = ((double)par5Random.nextFloat() - 0.5) * 0.5;
            double d6 = ((double)par5Random.nextFloat() - 0.5) * 0.5;
            if (par1World.getBlockState(pos.west()).getBlock() != this && par1World.getBlockState(pos.east()).getBlock() != this) {
                d0 = (double)pos.getX() + 0.5 + 0.25 * (double)i1;
                d4 = par5Random.nextFloat() * 2.0f * (float)i1;
            } else {
                d3 = (double)pos.getZ() + 0.5 + 0.25 * (double)i1;
                d6 = par5Random.nextFloat() * 2.0f * (float)i1;
            }
            par1World.spawnParticle(EnumParticleTypes.DRIP_WATER, d0, d2, d3, d4, d5, d6, new int[0]);
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return ItemStack.EMPTY;
    }

    public boolean tryToCreatePortal(World par1World, BlockPos pos) {
        int i1;
        int l;
        int b0 = 0;
        int b2 = 0;
        if (par1World.getBlockState(pos.west()).getBlock() == this.portalFrameBlock || par1World.getBlockState(pos.east()).getBlock() == this.portalFrameBlock) {
            b0 = 1;
        }
        if (par1World.getBlockState(pos.north()).getBlock() == this.portalFrameBlock || par1World.getBlockState(pos.south()).getBlock() == this.portalFrameBlock) {
            b2 = 1;
        }
        if (b0 == b2) {
            return false;
        }
        if (par1World.isAirBlock(pos.add(-b0, 0, -b2))) {
            pos = pos.add(-b0, 0, -b2);
        }
        int WIDTH = 2;
        int HEIGHT = 2;
        for (l = -1; l <= 2; ++l) {
            for (i1 = -1; i1 <= HEIGHT; ++i1) {
                boolean flag;
                boolean bl = flag = l == -1 || l == WIDTH || i1 == -1 || i1 == WIDTH;
                if ((l == -1 || l == HEIGHT) && (i1 == -1 || i1 == HEIGHT)) continue;
                BlockPos p = pos.add(b0 * l, i1, b2 * l);
                Block j1 = par1World.getBlockState(p).getBlock();
                boolean isAirBlock = par1World.isAirBlock(p);
                if (!(flag ? j1 != this.portalFrameBlock : !isAirBlock && j1 != WitcheryBlocks.FLOWING_SPIRIT)) continue;
                return false;
            }
        }
        for (l = 0; l < 2; ++l) {
            for (i1 = 0; i1 < 2; ++i1) {
                par1World.setBlockState(pos.add(b0 * l, i1, b2 * l), this.getDefaultState(), 2);
            }
        }
        return true;
    }
}

