/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.TileEntitySilverVat;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import org.jetbrains.annotations.Nullable;

public class BlockSilverVat
extends BlockContainer {
    public static final ItemStack GOLD_INGOT = new ItemStack(Items.GOLD_INGOT);
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)0.64f, 1.0);

    public BlockSilverVat() {
        super(Material.IRON);
        this.setCreativeTab(WitcheryGeneralItems.TAB);
        this.setHardness(8.0f);
        this.setSoundType(SoundType.METAL);
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean shouldSideBeRendered(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public boolean hasComparatorInputOverride(IBlockState state) {
        return true;
    }

    public int getComparatorInputOverride(IBlockState state, World world, BlockPos pos) {
        TileEntity tile = world.getTileEntity(pos);
        if (tile instanceof IInventory) {
            return Container.calcRedstoneFromInventory((IInventory)((IInventory)tile));
        }
        return 0;
    }

    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.isRemote) {
            ItemStack stack;
            TileEntitySilverVat tile = WitcheryTileEntities.SILVER_VAT.getAt((IBlockAccess)world, pos);
            if (tile != null && !(stack = tile.getStackInSlot(0)).isEmpty()) {
                double motion;
                EntityItem entity = new EntityItem(world, player.posX, player.posY + 1.0, player.posZ, stack);
                entity.motionZ = motion = 0.0;
                entity.motionY = motion;
                entity.motionX = motion;
                world.spawnEntity((Entity)entity);
                tile.setInventorySlotContents(0, ItemStack.EMPTY);
                tile.notifyBlockUpdate(true);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        block9: {
            TileEntitySilverVat vat;
            if (!(pos.getY() != neighbor.getY() || pos.getX() != neighbor.getX() && pos.getZ() != neighbor.getZ() || (vat = WitcheryTileEntities.SILVER_VAT.getAt(world, pos)) == null || vat.reenterLock)) {
                vat.reenterLock = true;
                try {
                    TileEntity tile = world.getTileEntity(neighbor);
                    if (!(tile instanceof ISidedInventory)) break block9;
                    ISidedInventory inv = (ISidedInventory)tile;
                    int offsetX = pos.getX() - neighbor.getZ();
                    int offsetZ = pos.getZ() - neighbor.getZ();
                    EnumFacing side = offsetX == 0 ? (offsetZ > 0 ? EnumFacing.SOUTH : EnumFacing.NORTH) : (offsetX > 0 ? EnumFacing.EAST : EnumFacing.WEST);
                    for (int slot = 0; slot < inv.getSizeInventory(); ++slot) {
                        ItemStack stack;
                        if (!inv.canExtractItem(slot, GOLD_INGOT, side) || inv.canInsertItem(slot, GOLD_INGOT, side) || (stack = inv.getStackInSlot(slot)).isEmpty() || stack.getItem() != Items.GOLD_INGOT) continue;
                        if (stack.getCount() > vat.getLastStackSizeForSide(side) && vat.getWorld().rand.nextInt(5) == 0) {
                            ItemStack silver = vat.getStackInSlot(0);
                            if (silver.isEmpty()) {
                                silver = new ItemStack(WitcheryIngredientItems.SILVER_DUST);
                                vat.setInventorySlotContents(0, silver);
                                vat.notifyBlockUpdate(true);
                            } else if (silver.getCount() < silver.getMaxStackSize()) {
                                silver.grow(1);
                                vat.notifyBlockUpdate(true);
                            }
                        }
                        vat.setLastStackSizeForSide(side, stack.getCount());
                        break;
                    }
                }
                finally {
                    vat.reenterLock = false;
                }
            }
        }
    }

    @Nullable
    public TileEntity createNewTileEntity(World worldIn, int meta) {
        return WitcheryTileEntities.SILVER_VAT.create();
    }
}

