/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.Map;
import java.util.Random;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBreakable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0005H\u0014J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0017J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J0\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\rH\u0016J \u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0016\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lnet/msrandom/witchery/block/BlockShadedGlass;", "Lnet/minecraft/block/BlockBreakable;", "color", "Lnet/minecraft/item/EnumDyeColor;", "shaded", "", "(Lnet/minecraft/item/EnumDyeColor;Z)V", "canSilkHarvest", "getItem", "Lnet/minecraft/item/ItemStack;", "worldIn", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "state", "Lnet/minecraft/block/state/IBlockState;", "getRenderLayer", "Lnet/minecraft/util/BlockRenderLayer;", "isFullCube", "neighborChanged", "", "world", "blockIn", "Lnet/minecraft/block/Block;", "fromPos", "onBlockAdded", "quantityDropped", "", "rand", "Ljava/util/Random;", "updatePoweredState", "WitcheryResurrected"})
public final class BlockShadedGlass
extends BlockBreakable {
    private final EnumDyeColor color;
    private final boolean shaded;

    public void onBlockAdded(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState state) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        this.updatePoweredState(world, pos);
    }

    public int quantityDropped(@NotNull Random rand) {
        Intrinsics.checkParameterIsNotNull((Object)rand, (String)"rand");
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public BlockRenderLayer getRenderLayer() {
        BlockRenderLayer blockRenderLayer;
        if (this.shaded) {
            BlockRenderLayer blockRenderLayer2 = super.getRenderLayer();
            blockRenderLayer = blockRenderLayer2;
            Intrinsics.checkExpressionValueIsNotNull((Object)blockRenderLayer2, (String)"super.getRenderLayer()");
        } else {
            blockRenderLayer = BlockRenderLayer.CUTOUT;
        }
        return blockRenderLayer;
    }

    protected boolean canSilkHarvest() {
        return true;
    }

    public boolean isFullCube(@NotNull IBlockState state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        return false;
    }

    public void neighborChanged(@NotNull IBlockState state, @NotNull World world, @NotNull BlockPos pos, @NotNull Block blockIn, @NotNull BlockPos fromPos) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)blockIn, (String)"blockIn");
        Intrinsics.checkParameterIsNotNull((Object)fromPos, (String)"fromPos");
        this.updatePoweredState(world, pos);
    }

    public final void updatePoweredState(@NotNull World world, @NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        if (world.isBlockPowered(pos)) {
            if (!this.shaded) {
                Object object = MapsKt.getValue((Map)WitcheryBlocks.ACTIVATED_SHADED_GLASSES, (Object)this.color);
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"WitcheryBlocks.ACTIVATED\u2026D_GLASSES.getValue(color)");
                world.setBlockState(pos, ((BlockShadedGlass)((Object)object)).getDefaultState(), 3);
            }
        } else if (this.shaded) {
            Object object = MapsKt.getValue((Map)WitcheryBlocks.SHADED_GLASSES, (Object)this.color);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"WitcheryBlocks.SHADED_GLASSES.getValue(color)");
            world.setBlockState(pos, ((BlockShadedGlass)((Object)object)).getDefaultState(), 3);
        }
    }

    @NotNull
    public ItemStack getItem(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull IBlockState state) {
        ItemStack itemStack;
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        if (this.shaded) {
            itemStack = new ItemStack((Block)MapsKt.getValue((Map)WitcheryBlocks.SHADED_GLASSES, (Object)this.color));
        } else {
            ItemStack itemStack2 = super.getItem(worldIn, pos, state);
            itemStack = itemStack2;
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack2, (String)"super.getItem(worldIn, pos, state)");
        }
        return itemStack;
    }

    public BlockShadedGlass(@NotNull EnumDyeColor color2, boolean shaded) {
        Intrinsics.checkParameterIsNotNull((Object)color2, (String)"color");
        super(shaded ? Material.ROCK : Material.GLASS, false);
        this.color = color2;
        this.shaded = shaded;
        this.setHardness(0.3f);
        if (this.shaded) {
            this.setLightOpacity(15);
        }
        this.setSoundType(SoundType.GLASS);
        this.setCreativeTab(WitcheryGeneralItems.TAB);
    }
}

