/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.msrandom.witchery.block.WitcheryBlockDoor;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002JP\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0019H\u0016J(\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0006\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J(\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020 H\u0002J(\u0010!\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\u0005H\u0002\u00a8\u0006#"}, d2={"Lnet/msrandom/witchery/block/BlockRowanDoor;", "Lnet/msrandom/witchery/block/WitcheryBlockDoor;", "()V", "getDrops", "", "Lnet/minecraft/item/ItemStack;", "world", "Lnet/minecraft/world/IBlockAccess;", "pos", "Lnet/minecraft/util/math/BlockPos;", "state", "Lnet/minecraft/block/state/IBlockState;", "fortune", "", "hasKeyForDoor", "", "Lnet/minecraft/world/World;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "onBlockActivated", "hand", "Lnet/minecraft/util/EnumHand;", "facing", "Lnet/minecraft/util/EnumFacing;", "hitX", "", "hitY", "hitZ", "onBlockHarvested", "", "testDoor", "door", "Lnet/minecraft/nbt/NBTTagCompound;", "testKey", "stack", "WitcheryResurrected"})
public final class BlockRowanDoor
extends WitcheryBlockDoor {
    public boolean onBlockActivated(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState state, @NotNull EntityPlayer player, @NotNull EnumHand hand, @NotNull EnumFacing facing, float hitX, float hitY, float hitZ) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)hand, (String)"hand");
        Intrinsics.checkParameterIsNotNull((Object)facing, (String)"facing");
        return this.hasKeyForDoor(world, pos, state, player) && super.onBlockActivated(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    public void onBlockHarvested(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState state, @NotNull EntityPlayer player) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        ItemStack stack = this.hasKeyForDoor(world, pos, state, player) ? this.getItem(world, pos, state) : new ItemStack(Items.STICK, 8);
        double f = 0.7;
        double d = 0.15002830246369595;
        double x = world.rand.nextDouble() * f + d;
        double y = world.rand.nextDouble() * f + d;
        double z = world.rand.nextDouble() * f + d;
        EntityItem entityitem = new EntityItem(world, (double)pos.getX() + x, (double)pos.getY() + y, (double)pos.getZ() + z, stack);
        entityitem.setDefaultPickupDelay();
        if (!world.isRemote) {
            world.spawnEntity((Entity)entityitem);
        }
        super.onBlockHarvested(world, pos, state, player);
    }

    @NotNull
    public List<ItemStack> getDrops(@NotNull IBlockAccess world, @NotNull BlockPos pos, @NotNull IBlockState state, int fortune) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasKeyForDoor(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        ItemStack itemStack = player.getHeldItem(EnumHand.OFF_HAND);
        boolean bl = false;
        int n = 0;
        ItemStack it = itemStack;
        boolean bl2 = false;
        ItemStack itemStack2 = it;
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack2, (String)"it");
        if (this.testKey(world, state, pos, itemStack2)) {
            return true;
        }
        itemStack = player.getHeldItem(EnumHand.MAIN_HAND);
        bl = false;
        n = 0;
        it = itemStack;
        boolean bl3 = false;
        ItemStack itemStack3 = it;
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack3, (String)"it");
        if (this.testKey(world, state, pos, itemStack3)) {
            return true;
        }
        InventoryPlayer inventoryPlayer = player.inventory;
        Intrinsics.checkExpressionValueIsNotNull((Object)inventoryPlayer, (String)"player.inventory");
        IInventory $this$forEach$iv = (IInventory)inventoryPlayer;
        boolean $i$f$forEach = false;
        n = 0;
        int n2 = $this$forEach$iv.getSizeInventory();
        while (n < n2) {
            ItemStack it2;
            void i$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)$this$forEach$iv.getStackInSlot((int)i$iv), (String)"getStackInSlot(i)");
            boolean bl4 = false;
            if (!it2.isEmpty() && this.testKey(world, state, pos, it2)) {
                return true;
            }
            ++i$iv;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean testKey(World world, IBlockState state, BlockPos pos, ItemStack stack) {
        NBTTagCompound data;
        if (stack.getItem() == WitcheryIngredientItems.DOOR_KEY) {
            return this.testDoor(world, state, pos, WitcheryUtils.getOrCreateTag(stack));
        }
        if (stack.getItem() == WitcheryIngredientItems.DOOR_KEYRING && (data = WitcheryUtils.getOrCreateTag(stack)).hasKey("DoorKeys")) {
            NBTTagList keyList = data.getTagList("DoorKeys", 10);
            int n = 0;
            int n2 = keyList.tagCount();
            while (n < n2) {
                void j;
                NBTTagCompound nBTTagCompound = keyList.getCompoundTagAt((int)j);
                Intrinsics.checkExpressionValueIsNotNull((Object)nBTTagCompound, (String)"keyList.getCompoundTagAt(j)");
                if (this.testDoor(world, state, pos, nBTTagCompound)) {
                    return true;
                }
                ++j;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean testDoor(World world, IBlockState state, BlockPos pos, NBTTagCompound door) {
        if (!door.hasKey("Dimension")) return false;
        if (door.getInteger("X") != pos.getX()) return false;
        if (door.getInteger("Y") + ((BlockDoor.EnumDoorHalf)state.getValue((IProperty)BlockDoor.HALF) == BlockDoor.EnumDoorHalf.UPPER ? 1 : 0) != pos.getY()) return false;
        if (door.getInteger("Z") != pos.getZ()) return false;
        int n = door.getInteger("Dimension");
        WorldProvider worldProvider = world.provider;
        Intrinsics.checkExpressionValueIsNotNull((Object)worldProvider, (String)"world.provider");
        if (n != worldProvider.getDimension()) return false;
        return true;
    }

    public BlockRowanDoor() {
        Material material = Material.WOOD;
        Intrinsics.checkExpressionValueIsNotNull((Object)material, (String)"Material.WOOD");
        super(material);
        this.setHardness(5.0f);
        this.setSoundType(SoundType.WOOD);
    }
}

