/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.TileEntityRemovedBlock;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.Nullable;

public class BlockRemovedBlock
extends BlockContainer {
    public BlockRemovedBlock() {
        super(Material.GLASS);
    }

    public EnumBlockRenderType getRenderType(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public AxisAlignedBB getCollisionBoundingBox(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return NULL_AABB;
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean canCollideCheck(IBlockState p_149678_1_, boolean p_149678_2_) {
        return false;
    }

    public boolean shouldSideBeRendered(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return false;
    }

    public void dropBlockAsItemWithChance(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
    }

    public void replaceBlockAt(World world, BlockPos pos, int timeoutTicks) {
        IBlockState state;
        if (!world.isRemote && WitcheryUtils.canBreak(state = world.getBlockState(pos)) && WitcheryUtils.isBlockBreakable(world, pos, state)) {
            world.setBlockState(pos, WitcheryBlocks.REMOVED.getDefaultState());
            TileEntityRemovedBlock tile = WitcheryTileEntities.REMOVED.getAt((IBlockAccess)world, pos);
            if (tile != null) {
                tile.saveBlock(timeoutTicks, state);
            }
        }
    }

    @Nullable
    public TileEntity createNewTileEntity(World worldIn, int meta) {
        return WitcheryTileEntities.REMOVED.create();
    }
}

