/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import net.minecraft.block.BlockChest;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.msrandom.witchery.init.WitcheryDimensions;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;

public class BlockRefillingChest
extends BlockChest {
    public BlockRefillingChest() {
        super(BlockChest.Type.BASIC);
        this.setCreativeTab(WitcheryGeneralItems.TAB);
        this.setResistance(9999.0f);
        this.setBlockUnbreakable();
    }

    public TileEntity createNewTileEntity(World world, int metadata) {
        return WitcheryTileEntities.REFILLING_CHEST.create();
    }

    public static class TileEntityRefillingChest
    extends TileEntityChest {
        protected long ticks = 0L;

        public void update() {
            super.update();
            if (this.ticks == 0L) {
                this.initiate();
            } else if (this.ticks >= Long.MAX_VALUE) {
                this.ticks = 1L;
            }
            ++this.ticks;
            this.doUpdate();
        }

        protected void initiate() {
            this.doUpdate();
        }

        protected void doUpdate() {
            if (!this.world.isRemote && WitcheryDimensions.TORMENT.isCurrentDimension(this.world) && this.ticks % 72000L == 0L) {
                for (int i = 0; i < this.getSizeInventory(); ++i) {
                    if (this.getStackInSlot(i).isEmpty()) continue;
                    this.setLootTable(LootTableList.CHESTS_SIMPLE_DUNGEON, this.world.rand.nextLong());
                    break;
                }
            }
        }

        public NBTTagCompound writeToNBT(NBTTagCompound nbtChest) {
            super.writeToNBT(nbtChest);
            nbtChest.setLong("WitcheryLifeTicks", this.ticks);
            return nbtChest;
        }

        public void readFromNBT(NBTTagCompound nbtChest) {
            super.readFromNBT(nbtChest);
            this.ticks = nbtChest.getLong("WitcheryLifeTicks");
        }
    }
}

