/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.TileEntityPoppetShelf;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import org.jetbrains.annotations.Nullable;

public class BlockPoppetShelf
extends BlockContainer {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)0.51f, 1.0);

    public BlockPoppetShelf() {
        super(Material.ROCK);
        this.setCreativeTab(WitcheryGeneralItems.TAB);
        this.setHardness(2.5f);
        this.setSoundType(SoundType.STONE);
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean shouldSideBeRendered(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.isRemote) {
            return true;
        }
        TileEntityPoppetShelf tileEntity = (TileEntityPoppetShelf)world.getTileEntity(pos);
        if (tileEntity != null) {
            player.displayGUIChest((IInventory)tileEntity);
        }
        return true;
    }

    public void breakBlock(World worldIn, BlockPos pos, IBlockState state) {
        TileEntityPoppetShelf tileEntity = WitcheryTileEntities.POPPET_SHELF.getAt((IBlockAccess)worldIn, pos);
        if (tileEntity != null) {
            InventoryHelper.dropInventoryItems((World)worldIn, (BlockPos)pos, (IInventory)tileEntity);
            worldIn.updateComparatorOutputLevel(pos, (Block)this);
        }
        super.breakBlock(worldIn, pos, state);
    }

    public boolean hasComparatorInputOverride(IBlockState state) {
        return true;
    }

    public int getComparatorInputOverride(IBlockState state, World world, BlockPos pos) {
        return Container.calcRedstoneFromInventory((IInventory)((IInventory)world.getTileEntity(pos)));
    }

    @Nullable
    public TileEntity createNewTileEntity(World worldIn, int meta) {
        return WitcheryTileEntities.POPPET_SHELF.create();
    }
}

