/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.Random;
import net.minecraft.block.BlockBush;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.entity.EntityWitchProjectile;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.item.brews.ItemInkBrew;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;

public class BlockPlantMine
extends BlockBush {
    private final MineEffect effect;

    public BlockPlantMine(MineEffect effect) {
        super(Material.PLANTS);
        this.setHardness(6.0f);
        this.setResistance(1000.0f);
        this.setSoundType(SoundType.PLANT);
        this.setCreativeTab(WitcheryGeneralItems.TAB);
        this.effect = effect;
    }

    public void onEntityCollision(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!world.isRemote) {
            world.setBlockToAir(pos);
            world.playSound(null, 0.5 + (double)pos.getX(), 0.05 + (double)pos.getY(), 0.5 + (double)pos.getZ(), SoundEvents.ENTITY_GENERIC_EXPLODE, entity.getSoundCategory(), 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
            WitcheryNetworkChannel.sendToAllAround(new PacketParticles(0.5 + (double)pos.getX(), 0.05 + (double)pos.getY(), 0.5 + (double)pos.getZ(), 0.5f, 1.0f, EnumParticleTypes.CRIT_MAGIC), world, pos);
            this.effect.apply(world, pos, entity);
        }
    }

    public Item getItemDropped(IBlockState par1, Random rand, int fortune) {
        return Items.AIR;
    }

    public static enum Variant {
        ROSE,
        DANDELION,
        DEAD_BUSH;

        public static final Variant[] VALUES;

        static {
            VALUES = Variant.values();
        }
    }

    @FunctionalInterface
    public static interface MineEffect {
        public static final MineEffect WEBS = (world, pos, entity) -> EntityWitchProjectile.explodeWeb(world, pos, EnumFacing.UP, false);
        public static final MineEffect INK = (world, pos, entity) -> ItemInkBrew.Companion.impactInk(world, pos, entity, new AxisAlignedBB(pos, pos.add(1, 1, 1)), false);
        public static final MineEffect THORNS = (world, pos, entity) -> EntityWitchProjectile.plantCactus(world, pos, 4);
        public static final MineEffect SPROUTING = (world, pos, entity) -> EntityWitchProjectile.growBranch(pos, world, EnumFacing.UP, 10, new AxisAlignedBB(pos, pos.add(1, 1, 1)));

        public void apply(World var1, BlockPos var2, Entity var3);
    }
}

