/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.TileEntityPlacedItem;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryTileEntities;

public class BlockPlacedItem
extends BlockContainer {
    public static final AxisAlignedBB AABB = new AxisAlignedBB((double)0.2f, 0.0, (double)0.2f, (double)0.8f, (double)0.05f, (double)0.8f);
    private static final PropertyDirection FACING = BlockHorizontal.FACING;

    public BlockPlacedItem() {
        super(Material.GROUND);
        this.setDefaultState(this.getDefaultState().withProperty((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.setHardness(0.0f);
        this.setSoundType(SoundType.METAL);
    }

    public static void placeInWorld(EnumHand hand, EntityPlayer player, World world, BlockPos pos) {
        if (world.setBlockState(pos, WitcheryBlocks.PLACED_ITEM.getDefaultState().withProperty((IProperty)FACING, (Comparable)player.getHorizontalFacing().getOpposite()))) {
            TileEntityPlacedItem entity;
            ItemStack stack = player.getHeldItem(hand);
            ItemStack item = stack.copy();
            item.setCount(1);
            if (!player.capabilities.isCreativeMode) {
                stack.shrink(1);
            }
            if ((entity = WitcheryTileEntities.PLACED_ITEM.getAt((IBlockAccess)world, pos)) != null) {
                entity.initialize(item);
            }
        }
    }

    public int getMetaFromState(IBlockState state) {
        return ((EnumFacing)state.getValue((IProperty)FACING)).getHorizontalIndex();
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty((IProperty)FACING, (Comparable)EnumFacing.byHorizontalIndex((int)(meta & 3)));
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{FACING}).build();
    }

    public IBlockState withRotation(IBlockState state, Rotation rot) {
        return state.withProperty((IProperty)FACING, (Comparable)rot.rotate((EnumFacing)state.getValue((IProperty)FACING)));
    }

    public IBlockState withMirror(IBlockState state, Mirror mirrorIn) {
        return state.withRotation(mirrorIn.toRotation((EnumFacing)state.getValue((IProperty)FACING)));
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public void harvestBlock(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        player.addExhaustion(0.005f);
        if (te instanceof TileEntityPlacedItem) {
            BlockPlacedItem.spawnAsEntity((World)world, (BlockPos)pos, (ItemStack)((TileEntityPlacedItem)te).getStack());
        }
    }

    public void neighborChanged(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canPlaceBlockAt(worldIn, pos) && !worldIn.isRemote) {
            this.dropBlockAsItem(worldIn, pos, state, 0);
            worldIn.setBlockToAir(pos);
        }
    }

    public ItemStack getItem(World world, BlockPos pos, IBlockState state) {
        TileEntityPlacedItem item = WitcheryTileEntities.PLACED_ITEM.getAt((IBlockAccess)world, pos);
        return item == null ? ItemStack.EMPTY : new ItemStack(item.stack.getItem(), 1, item.stack.getItemDamage());
    }

    public boolean canPlaceBlockAt(World world, BlockPos pos) {
        BlockPos down = pos.down();
        Material material = world.getBlockState(down).getMaterial();
        return !world.isAirBlock(down) && material.isOpaque() && material.isSolid();
    }

    @Nullable
    public TileEntity createNewTileEntity(World world, int meta) {
        return WitcheryTileEntities.PLACED_ITEM.create();
    }
}

