/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockPressurePlate;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.items.WitcheryEquipmentItems;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;

public class BlockPerpetualIcePressurePlate
extends BlockPressurePlate {
    public BlockPerpetualIcePressurePlate(Material material) {
        super(material, BlockPressurePlate.Sensitivity.EVERYTHING);
        this.setCreativeTab(WitcheryGeneralItems.TAB);
        if (material == Material.ICE) {
            this.setLightOpacity(3);
            this.setHardness(2.0f);
            this.setResistance(5.0f);
        } else {
            this.setHardness(0.2f);
            this.setSoundType(SoundType.SNOW);
        }
    }

    protected int computeRedstoneStrength(World world, BlockPos pos) {
        if (this.material == Material.ICE) {
            for (EntityLivingBase entity : world.getEntitiesWithinAABB(EntityLivingBase.class, PRESSURE_AABB.offset(pos))) {
                if (entity.getItemStackFromSlot(EntityEquipmentSlot.FEET).getItem() != WitcheryEquipmentItems.ICY_SLIPPERS) continue;
                return 15;
            }
            return 0;
        }
        return super.computeRedstoneStrength(world, pos);
    }

    public boolean canPlaceBlockAt(World world, BlockPos pos) {
        return super.canPlaceBlockAt(world, pos) || world.getBlockState(pos.down()).getBlock() == WitcheryBlocks.PERPETUAL_ICE_FENCE;
    }

    public void neighborChanged(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canPlaceBlockAt(world, pos)) {
            this.dropBlockAsItem(world, pos, state, 0);
            world.setBlockToAir(pos);
        }
    }
}

