/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketPlayerPosLook;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.msrandom.witchery.WitcheryResurrected;
import net.msrandom.witchery.block.entity.TileEntityMirror;
import net.msrandom.witchery.common.IPowerSource;
import net.msrandom.witchery.common.PowerSources;
import net.msrandom.witchery.entity.EntityMirrorFace;
import net.msrandom.witchery.entity.EntityReflection;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryDimensions;
import net.msrandom.witchery.init.WitcherySounds;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.item.ingredients.WitcheryIngredientItem;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.Nullable;

public class BlockMirror
extends BlockContainer {
    public static final PropertyBool TOP = PropertyBool.create((String)"top");
    private static final PropertyDirection FACING = BlockHorizontal.FACING;
    private static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0, 0.0, (double)0.85f, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, (double)0.15f);
    private static final AxisAlignedBB WEST_AABB = new AxisAlignedBB((double)0.85f, 0.0, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, (double)0.15f, 1.0, 1.0);
    private static String sendMeHome;
    private static String iGiveUp;
    private final boolean unbreakable;

    public BlockMirror(boolean unbreakable) {
        super(Material.GLASS);
        this.unbreakable = unbreakable;
        this.setLightLevel(0.7f);
        this.disableStats();
        this.setSoundType(SoundType.GLASS);
        if (unbreakable) {
            this.setBlockUnbreakable();
        } else {
            this.setHardness(1.0f);
            this.setCreativeTab(WitcheryGeneralItems.TAB);
        }
        this.setResistance(9999.0f);
    }

    public static EnumFacing getDirection(IBlockState meta) {
        return (EnumFacing)meta.getValue((IProperty)FACING);
    }

    public static boolean isBlockTopOfMirror(IBlockState meta) {
        return (Boolean)meta.getValue((IProperty)TOP);
    }

    public boolean trySayMirrorMirrorSendMeHome(EntityPlayer player, String message) {
        if (player == null || player.world.isRemote || !WitcheryDimensions.MIRROR.isInDimension((Entity)player)) {
            return false;
        }
        if (sendMeHome == null) {
            sendMeHome = WitcheryResurrected.translate(WitcheryBlocks.MIRROR.getTranslationKey() + ".send_me_home", new Object[0]).toLowerCase().replace("'", "").replace(",", "").trim();
        }
        if (iGiveUp == null) {
            iGiveUp = WitcheryResurrected.translate(WitcheryBlocks.MIRROR.getTranslationKey() + ".give_up", new Object[0]).toLowerCase().replace("'", "").replace(",", "").trim();
        }
        PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
        String m = message.toLowerCase().replace("'", "").replace(",", "").trim();
        if (m.startsWith(sendMeHome)) {
            if (playerEx.canEscapeMirrorWorld(1)) {
                player.sendMessage(new TextComponentTranslation(WitcheryBlocks.MIRROR.getTranslationKey() + ".failed_chant", new Object[]{Long.valueOf(playerEx.getCooldownSecs(1)).toString()}).setStyle(new Style().setColor(TextFormatting.RED)));
                return true;
            }
            BlockPos c = playerEx.getMirrorWorldEntryPoint();
            if (c != null) {
                playerEx.escapedMirrorWorld(1);
                player.setPositionAndRotation(player.posX, player.posY, player.posZ, 270.0f, player.rotationPitch);
                WitcheryIngredientItem.teleportToLocation(c, player.dimension, (Entity)player, true, EnumParticleTypes.WATER_SPLASH, WitcherySounds.BLOCK_MIRROR_SPLASH);
                return true;
            }
        } else if (m.startsWith(iGiveUp)) {
            if (playerEx.canEscapeMirrorWorld(2)) {
                player.sendMessage(new TextComponentTranslation(WitcheryBlocks.MIRROR.getTranslationKey() + ".failed_chant", new Object[]{Long.valueOf(playerEx.getCooldownSecs(2)).toString()}).setStyle(new Style().setColor(TextFormatting.RED)));
                return true;
            }
            BlockPos coords = player.getBedLocation(player.dimension);
            if (coords != null) {
                int dimension = player.dimension;
                World world = player.world;
                if ((coords = Blocks.BED.getBedSpawnPosition(world.getBlockState(coords), (IBlockAccess)world, coords, null)) != null) {
                    playerEx.escapedMirrorWorld(2);
                    WitcheryIngredientItem.teleportToLocation(coords.up(), dimension, (Entity)player, true);
                    return true;
                }
            }
        }
        return false;
    }

    public void addInformation(ItemStack stack, @javax.annotation.Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.addInformation(stack, worldIn, tooltip, flagIn);
        NBTTagCompound nbtRoot = stack.getTagCompound();
        if (nbtRoot == null || !nbtRoot.getBoolean("DemonSlain")) {
            tooltip.add(WitcheryResurrected.translate(this.getTranslationKey() + ".tip.inhabited", new Object[0]));
        } else {
            tooltip.add(WitcheryResurrected.translate(this.getTranslationKey() + ".tip.bridge", new Object[0]));
        }
    }

    public void onEntityCollision(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!world.isRemote && entity.ticksExisted % 5 == 1 && this.isTransportableEntity(entity)) {
            TileEntityMirror tile;
            AxisAlignedBB box;
            double f2;
            double f;
            AxisAlignedBB entityBox;
            int hitZoneyShift = 0;
            if (!BlockMirror.isBlockTopOfMirror(state)) {
                pos = pos.up();
                if (entity.height <= 1.0f) {
                    hitZoneyShift = -1;
                }
                if (world.getBlockState(pos).getBlock() != this) {
                    return;
                }
            }
            if ((entityBox = new AxisAlignedBB(entity.posX - (f = (double)entity.width * 0.5), entity.posY + (double)entity.height, entity.posZ - f, entity.posX + f, entity.posY + (double)entity.height + (f2 = (double)entity.height), entity.posZ + f)).intersects(box = this.getServerSelectedBoundingBoxFromPool(world, pos.up(hitZoneyShift))) && (tile = WitcheryTileEntities.MIRROR.getAt((IBlockAccess)world, pos)) != null) {
                EnumFacing side = BlockMirror.getDirection(world.getBlockState(pos));
                int facing = MathHelper.floor((double)((double)(entity.rotationYaw * 4.0f / 360.0f) + 0.5)) & 3;
                int dx = 0;
                int dz = 0;
                float shift = 0.7f;
                float xShift = 0.0f;
                float zShift = 0.0f;
                int scale = 1;
                EnumFacing requiredSide = side.getOpposite();
                boolean isLiving = entity instanceof EntityLivingBase;
                if (side == EnumFacing.NORTH) {
                    dz = scale;
                    zShift = -shift;
                    if (isLiving && facing != 0) {
                        return;
                    }
                } else if (side == EnumFacing.SOUTH) {
                    dz = -scale;
                    zShift = shift;
                    if (isLiving && facing != 2) {
                        return;
                    }
                } else if (side == EnumFacing.WEST) {
                    dx = scale;
                    xShift = -shift;
                    if (isLiving && facing != 3) {
                        return;
                    }
                } else if (side == EnumFacing.EAST) {
                    dx = -scale;
                    xShift = shift;
                    if (isLiving && facing != 1) {
                        return;
                    }
                }
                boolean inMirrorWorld = WitcheryDimensions.MIRROR.isInDimension(entity);
                if (!this.unbreakable) {
                    BlockPos np;
                    int j;
                    if (inMirrorWorld || tile.demonKilled) {
                        for (j = 1; j < 32; ++j) {
                            int nz;
                            int ny;
                            np = pos.add(dx * j, 0, dz * j);
                            int nx = np.getX();
                            IBlockState ns = world.getBlockState(new BlockPos(nx, ny = np.getY(), nz = np.getZ()));
                            Block block = ns.getBlock();
                            if (block != this || BlockMirror.getDirection(ns) != requiredSide) continue;
                            WitcheryIngredientItem.teleportToLocation(0.5 + (double)nx - (double)xShift, (double)(ny - 1) + 0.01, 0.5 + (double)nz - (double)zShift, world.provider.getDimension(), entity, true, EnumParticleTypes.WATER_SPLASH, WitcherySounds.BLOCK_MIRROR_SPLASH);
                            return;
                        }
                    }
                    if (inMirrorWorld) {
                        for (j = 1; j < 10; ++j) {
                            IPowerSource power;
                            int nz;
                            int cz;
                            int ny;
                            int cy;
                            int nx;
                            int cx;
                            boolean isEntryCell;
                            np = pos.add(dx * j, 0, dz * j);
                            if (!world.isAirBlock(pos) || !world.isAirBlock(pos.down())) continue;
                            boolean isPlayerEntryCell = false;
                            if (entity instanceof EntityPlayer) {
                                EntityPlayer player = (EntityPlayer)entity;
                                PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
                                isPlayerEntryCell = playerEx.isMirrorWorldEntryPoint(np);
                            }
                            boolean bl = isEntryCell = world.getBlockState(new BlockPos(cx = ((nx = np.getX()) >> 4 << 4) + 4, cy = ((ny = np.getY()) >> 4 << 4) + 8, cz = ((nz = np.getZ()) >> 4 << 4) + 8)).getBlock() == WitcheryBlocks.UNBREAKABLE_MIRROR;
                            if ((!isEntryCell || isPlayerEntryCell) && (power = PowerSources.findClosestPowerSource(world, pos)) != null && power.consumePower(3000.0f)) {
                                WitcheryIngredientItem.teleportToLocation(0.5 + (double)nx - (double)xShift, (double)ny + 0.01, 0.5 + (double)nz - (double)zShift, world.provider.getDimension(), entity, true, EnumParticleTypes.WATER_SPLASH, WitcherySounds.BLOCK_MIRROR_SPLASH);
                            }
                            return;
                        }
                    } else if (tile.demonKilled) {
                        int dy;
                        for (dy = 2; dy < 16; ++dy) {
                            np = pos.add(0, dy, 0);
                            IBlockState meta = world.getBlockState(np);
                            Block block = meta.getBlock();
                            if (block != this || BlockMirror.getDirection(meta) != side) continue;
                            if (BlockMirror.isBlockTopOfMirror(meta)) {
                                np = np.down();
                            }
                            int nx = np.getX();
                            int ny = np.getY();
                            int nz = np.getZ();
                            WitcheryIngredientItem.teleportToLocation(0.5 + (double)nx + (double)xShift, (double)ny + 0.01, 0.5 + (double)nz + (double)zShift, world.provider.getDimension(), entity, true, EnumParticleTypes.WATER_SPLASH, WitcherySounds.BLOCK_MIRROR_SPLASH);
                            if (entity instanceof EntityPlayerMP) {
                                EntityPlayerMP player2 = (EntityPlayerMP)entity;
                                double yaw = player2.rotationYaw + 180.0f;
                                float rev = (float)yaw % 360.0f;
                                SPacketPlayerPosLook packet2 = new SPacketPlayerPosLook(player2.posX, player2.posY, player2.posZ, rev, player2.rotationPitch, EnumSet.noneOf(SPacketPlayerPosLook.EnumFlags.class), player2.connection.teleportId);
                                player2.connection.sendPacket((Packet)packet2);
                            }
                            return;
                        }
                        for (dy = 2; dy < 16; ++dy) {
                            np = pos.add(0, -dy, 0);
                            IBlockState meta = world.getBlockState(np);
                            Block block = meta.getBlock();
                            if (block != this || BlockMirror.getDirection(meta) != side) continue;
                            if (BlockMirror.isBlockTopOfMirror(meta)) {
                                np = np.down();
                            }
                            WitcheryIngredientItem.teleportToLocation(0.5 + (double)np.getX() + (double)xShift, (double)np.getY() + 0.01, 0.5 + (double)np.getZ() + (double)zShift, world.provider.getDimension(), entity, true, EnumParticleTypes.WATER_SPLASH, WitcherySounds.BLOCK_MIRROR_SPLASH);
                            if (entity instanceof EntityPlayerMP) {
                                EntityPlayerMP player2 = (EntityPlayerMP)entity;
                                double yaw = player2.rotationYaw + 180.0f;
                                float rev = (float)yaw % 360.0f;
                                SPacketPlayerPosLook packet3 = new SPacketPlayerPosLook(player2.posX, player2.posY, player2.posZ, rev, player2.rotationPitch, EnumSet.noneOf(SPacketPlayerPosLook.EnumFlags.class), player2.connection.teleportId);
                                player2.connection.sendPacket((Packet)packet3);
                            }
                            return;
                        }
                    }
                }
                if (entity instanceof EntityPlayer) {
                    BlockPos dimCoords;
                    EntityPlayer player3 = (EntityPlayer)entity;
                    PlayerExtendedData playerEx2 = WitcheryUtils.getExtension(player3);
                    if ((!inMirrorWorld || playerEx2.isMirrorWorldEntryPoint(pos)) && (dimCoords = tile.getDimCoords()) != null) {
                        float dimX = (float)dimCoords.getX() + 0.5f;
                        float dimY = (float)dimCoords.getY() + 0.01f;
                        float dimZ = (float)dimCoords.getZ() + 0.5f;
                        int targetDimension = inMirrorWorld ? tile.dim : WitcheryDimensions.MIRROR.getType().getId();
                        WorldServer otherWorld = player3.getServer().getWorld(targetDimension);
                        float face = 0.0f;
                        IBlockState state2 = otherWorld.getBlockState(dimCoords);
                        Block block2 = state2.getBlock();
                        if (block2 instanceof BlockMirror) {
                            EnumFacing mside = BlockMirror.getDirection(state2);
                            float distance = 1.0f;
                            face = mside.getOpposite().getHorizontalAngle();
                            if (mside == EnumFacing.NORTH) {
                                dimZ -= distance;
                            } else if (mside == EnumFacing.SOUTH) {
                                dimZ += distance;
                            } else if (mside == EnumFacing.WEST) {
                                dimX -= distance;
                            } else if (mside == EnumFacing.EAST) {
                                dimX += distance;
                            }
                            player3.rotationYaw = face;
                            TileEntityMirror otherTile = WitcheryTileEntities.MIRROR.getAt((IBlockAccess)world, pos);
                            if (otherTile != null) {
                                if (otherTile.onCooldown()) {
                                    return;
                                }
                                otherTile.addCooldown(60);
                            }
                        }
                        entity.playSound(WitcherySounds.BLOCK_MIRROR_SPLASH, 0.5f, 0.4f / (entity.world.rand.nextFloat() * 0.4f + 0.8f));
                        WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(entity.posX, entity.posY, entity.posZ, 0.5f, 2.0f, EnumParticleTypes.WATER_SPLASH), entity);
                        if (!WitcheryDimensions.MIRROR.isInDimension(entity)) {
                            if (!tile.demonKilled) {
                                float cellMidZ;
                                float cellMidY;
                                double R = 7.0;
                                double RY = 6.0;
                                float cellMidX = dimCoords.getX() + 4;
                                AxisAlignedBB bounds = new AxisAlignedBB((double)cellMidX - R, (double)(cellMidY = (float)dimCoords.getY()) - RY, (double)(cellMidZ = (float)dimCoords.getZ()) - R, (double)cellMidX + R, (double)cellMidY + RY, (double)cellMidZ + R);
                                List EntityReflection2 = otherWorld.getEntitiesWithinAABB(EntityReflection.class, bounds);
                                if (EntityReflection2.size() == 0) {
                                    EntityReflection reflection = new EntityReflection((World)otherWorld);
                                    reflection.setPositionAndRotation(0.5 + (double)cellMidX, 1.1 + (double)cellMidY, 0.5 + (double)cellMidZ, 0.0f, 0.0f);
                                    reflection.enablePersistence();
                                    reflection.world.spawnEntity((Entity)reflection);
                                }
                            }
                            playerEx2.setMirrorWorldEntryPoint(dimCoords);
                            player3.setPositionAndRotation((double)dimX, (double)(dimY - 1.0f), (double)dimZ, face, player3.rotationPitch);
                            WitcheryIngredientItem.travelToDimension(player3, WitcheryDimensions.MIRROR.getType().getId());
                            player3.setPositionAndUpdate((double)dimX, (double)(dimY - 1.0f), (double)dimZ);
                        } else if (tile.isConnected) {
                            player3.setPositionAndRotation((double)dimX, (double)(dimY - 1.0f), (double)dimZ, face, player3.rotationPitch);
                            WitcheryIngredientItem.travelToDimension(player3, tile.dim);
                            player3.setPositionAndUpdate((double)dimX, (double)(dimY - 1.0f), (double)dimZ);
                        } else {
                            double targetX = dimX;
                            double targetY = dimY - 1.0f;
                            double targetZ = dimZ;
                            int targetDim = tile.dim;
                            MinecraftServer server = world.getMinecraftServer();
                            for (WorldServer worldServer : server.worlds) {
                                block5: for (EntityPlayer otherPlayer : worldServer.playerEntities) {
                                    for (ItemStack stack : otherPlayer.inventory.mainInventory) {
                                        boolean isMirror;
                                        if (Block.getBlockFromItem((Item)stack.getItem()) != this || !(isMirror = tile.isTargettedBy(stack))) continue;
                                        if (WitcheryDimensions.MIRROR.isInDimension((Entity)otherPlayer)) continue block5;
                                        targetX = otherPlayer.posX;
                                        targetY = otherPlayer.posY;
                                        targetZ = otherPlayer.posZ;
                                        targetDim = otherPlayer.dimension;
                                        continue block5;
                                    }
                                }
                            }
                            player3.setPositionAndRotation(targetX, targetY, targetZ, face, player3.rotationPitch);
                            WitcheryIngredientItem.travelToDimension(player3, targetDim);
                            player3.setPositionAndUpdate(targetX, targetY, targetZ);
                        }
                        entity.playSound(WitcherySounds.BLOCK_MIRROR_SPLASH, 0.5f, 0.4f / (entity.world.rand.nextFloat() * 0.4f + 0.8f));
                        WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(entity.posX, entity.posY, entity.posZ, 0.5f, 2.0f, EnumParticleTypes.WATER_SPLASH), entity);
                    }
                }
            }
        }
    }

    public void demonSlain(World world, double posX, double posY, double posZ) {
        if (!world.isRemote) {
            int z;
            double R = 7.0;
            double RY = 6.0;
            int x = (MathHelper.floor((double)posX) >> 4 << 4) + 4;
            int xmid = x + 4;
            int y = (MathHelper.floor((double)posY) >> 4 << 4) + 8;
            BlockPos pos = new BlockPos(x, y, z = (MathHelper.floor((double)posZ) >> 4 << 4) + 8);
            if (world.getBlockState(pos).getBlock() == WitcheryBlocks.UNBREAKABLE_MIRROR) {
                TileEntityMirror tile;
                AxisAlignedBB bounds = new AxisAlignedBB((double)xmid - R, (double)y - RY, (double)z - R, (double)xmid + R, (double)y + RY, (double)z + R);
                List reflections = world.getEntitiesWithinAABB(EntityReflection.class, bounds);
                int livingDemons = 0;
                for (EntityReflection entity : reflections) {
                    if (entity == null || !entity.isEntityAlive()) continue;
                    ++livingDemons;
                }
                if (livingDemons == 0 && (tile = WitcheryTileEntities.MIRROR.getAt((IBlockAccess)world, pos)) != null) {
                    BlockPos dimCoords = tile.getDimCoords();
                    int dim = tile.dim;
                    WorldServer otherWorld = world.getMinecraftServer().getWorld(dim);
                    TileEntityMirror otherTile = WitcheryTileEntities.MIRROR.getAt((IBlockAccess)otherWorld, dimCoords);
                    if (otherTile != null) {
                        otherTile.demonKilled = true;
                    }
                }
            }
        }
    }

    private boolean isTransportableEntity(Entity entity) {
        return !(entity instanceof EntityMirrorFace) && (entity instanceof EntityLivingBase || entity instanceof EntityItem);
    }

    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.isRemote) {
            return true;
        }
        if (!this.unbreakable) {
            IBlockState i1 = world.getBlockState(pos);
            if (!BlockMirror.isBlockTopOfMirror(i1) && world.getBlockState(pos = pos.up()).getBlock() != this) {
                return true;
            }
            TileEntityMirror tile = WitcheryTileEntities.MIRROR.getAt((IBlockAccess)world, pos);
            if (tile == null) {
                return true;
            }
            tile.depolyDemon(player, hand);
        }
        return true;
    }

    public EnumBlockRenderType getRenderType(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.getValue((IProperty)FACING)) {
            case NORTH: {
                return NORTH_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
            case EAST: {
                return EAST_AABB;
            }
        }
        return super.getBoundingBox(state, source, pos);
    }

    public AxisAlignedBB getServerSelectedBoundingBoxFromPool(World world, BlockPos pos) {
        EnumFacing side = BlockMirror.getDirection(world.getBlockState(pos));
        float w = 0.32f;
        float minX = 0.0f;
        float minY = 0.0f;
        float minZ = 0.0f;
        float maxX = 1.0f;
        float maxY = 1.0f;
        float maxZ = 1.0f;
        switch (side) {
            case NORTH: {
                minZ = 0.68f;
                break;
            }
            case SOUTH: 
            case EAST: {
                maxZ = w;
                break;
            }
            case WEST: {
                minX = 0.68f;
            }
        }
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        return new AxisAlignedBB((double)((float)x + minX), (double)((float)y + minY), (double)((float)z + minZ), (double)((float)x + maxX), (double)((float)y + maxY), (double)((float)z + maxZ));
    }

    public void harvestBlock(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.harvestBlock(worldIn, player, pos, state, te, stack);
        if (BlockMirror.isBlockTopOfMirror(state) && te instanceof TileEntityMirror) {
            BlockMirror.spawnAsEntity((World)worldIn, (BlockPos)pos, (ItemStack)this.getDrop(worldIn, (TileEntityMirror)te));
        }
    }

    public void neighborChanged(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (world.getBlockState(fromPos).getBlock() != this) {
            if (BlockMirror.isBlockTopOfMirror(state)) {
                if (world.getBlockState(pos.down()).getBlock() != this) {
                    if (!world.isRemote) {
                        this.dropBlockAsItem(world, pos, state, 0);
                    }
                    world.setBlockToAir(pos);
                }
            } else if (world.getBlockState(pos.up()).getBlock() != this) {
                world.setBlockToAir(pos);
            }
        }
    }

    public void onBlockPlacedBy(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        NBTTagCompound nbtRoot;
        TileEntityMirror tile;
        super.onBlockPlacedBy(world, pos, state, placer, stack);
        EnumFacing facing = placer.getHorizontalFacing().getOpposite();
        BlockPos top = pos.up();
        world.setBlockState(pos, this.getDefaultState().withProperty((IProperty)FACING, (Comparable)facing).withProperty((IProperty)TOP, (Comparable)Boolean.valueOf(false)), 2);
        world.setBlockState(top, this.getDefaultState().withProperty((IProperty)FACING, (Comparable)facing).withProperty((IProperty)TOP, (Comparable)Boolean.valueOf(true)), 2);
        if (!world.isRemote && (tile = WitcheryTileEntities.MIRROR.getAt((IBlockAccess)world, top)) != null && (nbtRoot = stack.getTagCompound()) != null) {
            tile.readItemDataFromNBT(nbtRoot);
            if (!WitcheryDimensions.MIRROR.isCurrentDimension(world) && tile.isDimLinked()) {
                TileEntityMirror otherTile;
                BlockPos dimCoords = tile.getDimCoords();
                WorldServer otherWorld = placer.getServer().getWorld(WitcheryDimensions.MIRROR.getType().getId());
                if (otherWorld.getBlockState(dimCoords).getBlock() == WitcheryBlocks.UNBREAKABLE_MIRROR && (otherTile = WitcheryTileEntities.MIRROR.getAt((IBlockAccess)otherWorld, dimCoords)) != null) {
                    otherTile.isConnected = true;
                    otherTile.dimCoords = top;
                    otherTile.notifyBlockUpdate(false);
                }
            }
        }
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess access, BlockPos pos, IBlockState state, int fortune) {
        TileEntityMirror tile;
        if (((Boolean)state.getValue((IProperty)TOP)).booleanValue() && (tile = WitcheryTileEntities.MIRROR.getAt(access, pos)) != null) {
            drops.add((Object)this.getDrop(access instanceof World ? (World)access : null, tile));
        }
    }

    private ItemStack getDrop(World world, TileEntityMirror tile) {
        ItemStack stack = new ItemStack((Block)this);
        NBTTagCompound nbtRoot = new NBTTagCompound();
        tile.writeItemDataToNBT(nbtRoot);
        stack.setTagCompound(nbtRoot);
        if (world != null && !WitcheryDimensions.MIRROR.isCurrentDimension(world) && tile.isDimLinked()) {
            TileEntityMirror otherTile;
            BlockPos dimCoords = tile.getDimCoords();
            WorldServer otherWorld = world.getMinecraftServer().getWorld(WitcheryDimensions.MIRROR.getType().getId());
            if (otherWorld.getBlockState(dimCoords).getBlock() == WitcheryBlocks.MIRROR && (otherTile = WitcheryTileEntities.MIRROR.getAt((IBlockAccess)otherWorld, dimCoords)) != null) {
                otherTile.isConnected = false;
                otherTile.notifyBlockUpdate(false);
            }
        }
        return stack;
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty((IProperty)FACING, (Comparable)EnumFacing.byHorizontalIndex((int)(meta & 3))).withProperty((IProperty)TOP, (Comparable)Boolean.valueOf((meta & 4) != 0));
    }

    public int getMetaFromState(IBlockState state) {
        int meta = ((EnumFacing)state.getValue((IProperty)FACING)).getHorizontalIndex();
        if (((Boolean)state.getValue((IProperty)TOP)).booleanValue()) {
            meta |= 4;
        }
        return meta;
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{FACING, TOP}).build();
    }

    @javax.annotation.Nullable
    public TileEntity createNewTileEntity(World worldIn, int meta) {
        return WitcheryTileEntities.MIRROR.create();
    }
}

