/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import com.mojang.authlib.GameProfile;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.msrandom.witchery.block.entity.TileEntityMovingBrew;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.init.WitcheryFluids;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.data.brewing.WitcheryBrewEffects;
import net.msrandom.witchery.util.WitcheryUtils;

public class BlockLiquidBrew
extends BlockFluidClassic
implements ITileEntityProvider {
    public BlockLiquidBrew() {
        super(WitcheryFluids.BREW_LIQUID, Material.WATER);
        this.hasTileEntity = true;
    }

    public boolean eventReceived(IBlockState state, World worldIn, BlockPos pos, int id, int param) {
        super.eventReceived(state, worldIn, pos, id, param);
        TileEntity tileentity = worldIn.getTileEntity(pos);
        return tileentity != null && tileentity.receiveClientEvent(id, param);
    }

    protected void flowIntoBlock(World world, BlockPos pos, int meta, TileEntityMovingBrew sourceFluid) {
        if (meta < 0) {
            return;
        }
        if (this.displaceIfPossible(world, pos)) {
            world.setBlockState(pos, this.getDefaultState().withProperty((IProperty)BlockLiquid.LEVEL, (Comparable)Integer.valueOf(meta)), 3);
            TileEntityMovingBrew targetFluid = WitcheryTileEntities.MOVING_BREW.getAt((IBlockAccess)world, pos);
            if (targetFluid != null && sourceFluid != null && sourceFluid.nbtEffect != null) {
                targetFluid.nbtEffect = sourceFluid.nbtEffect.copy();
                targetFluid.expansion = sourceFluid.expansion;
                targetFluid.duration = sourceFluid.duration;
                targetFluid.thrower = sourceFluid.thrower;
            }
        }
    }

    public void updateTick(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.isRemote) {
            return;
        }
        boolean evaporated = false;
        TileEntityMovingBrew fluid = WitcheryTileEntities.MOVING_BREW.getAt((IBlockAccess)world, pos);
        if (fluid != null && this.isSourceBlock((IBlockAccess)world, pos)) {
            if (++fluid.updateCount > 3 && (fluid.duration == 0 || rand.nextInt(fluid.duration) == 0)) {
                world.setBlockToAir(pos);
                evaporated = true;
            } else {
                world.scheduleUpdate(pos, (Block)this, this.tickRate);
            }
        }
        if (!evaporated) {
            int quantaRemaining = this.quantaPerBlock - (Integer)world.getBlockState(pos).getValue((IProperty)BlockLiquid.LEVEL);
            if (quantaRemaining < this.quantaPerBlock) {
                int expQuanta;
                BlockPos y2 = pos.up(this.densityDir);
                if (world.getBlockState(y2).getBlock() == this || world.getBlockState(y2.west()).getBlock() == this || world.getBlockState(y2.east()).getBlock() == this || world.getBlockState(y2.north()).getBlock() == this || world.getBlockState(y2.south()).getBlock() == this) {
                    expQuanta = this.quantaPerBlock - 1;
                } else {
                    int maxQuanta = -100;
                    maxQuanta = this.getLargerQuanta((IBlockAccess)world, pos.west(), maxQuanta);
                    maxQuanta = this.getLargerQuanta((IBlockAccess)world, pos.east(), maxQuanta);
                    maxQuanta = this.getLargerQuanta((IBlockAccess)world, pos.north(), maxQuanta);
                    maxQuanta = this.getLargerQuanta((IBlockAccess)world, pos.south(), maxQuanta);
                    expQuanta = maxQuanta - 1;
                }
                if (expQuanta != quantaRemaining) {
                    quantaRemaining = expQuanta;
                    if (quantaRemaining <= 0) {
                        world.setBlockState(pos, Blocks.AIR.getDefaultState());
                    } else {
                        world.setBlockState(pos, state.withProperty((IProperty)BlockLiquid.LEVEL, (Comparable)Integer.valueOf(this.quantaPerBlock - expQuanta)), 3);
                        world.scheduleUpdate(pos, (Block)this, this.tickRate);
                        world.notifyNeighborsRespectDebug(pos, (Block)this, true);
                    }
                }
            } else {
                world.setBlockState(pos, this.getDefaultState(), 2);
            }
            if (this.canDisplace((IBlockAccess)world, pos.up(this.densityDir))) {
                this.flowIntoBlock(world, pos.up(this.densityDir), 1, fluid);
                return;
            }
            int flowMeta = this.quantaPerBlock - quantaRemaining + 1;
            if (flowMeta >= this.quantaPerBlock) {
                return;
            }
            if (this.isSourceBlock((IBlockAccess)world, pos) || !this.isFlowingVertically((IBlockAccess)world, pos)) {
                boolean[] flowTo;
                if (world.getBlockState(pos.down(this.densityDir)).getBlock() == this) {
                    flowMeta = 1;
                }
                if ((flowTo = this.getOptimalFlowDirections(world, pos))[0]) {
                    this.flowIntoBlock(world, pos.west(), flowMeta, fluid);
                }
                if (flowTo[1]) {
                    this.flowIntoBlock(world, pos.east(), flowMeta, fluid);
                }
                if (flowTo[2]) {
                    this.flowIntoBlock(world, pos.north(), flowMeta, fluid);
                }
                if (flowTo[3]) {
                    this.flowIntoBlock(world, pos.south(), flowMeta, fluid);
                }
            }
            if (fluid != null && fluid.nbtEffect != null) {
                for (EnumFacing direction : EnumFacing.values()) {
                    ModifiersEffect modifiersEffect;
                    BlockPos p2 = pos.offset(direction);
                    Block block = world.getBlockState(p2).getBlock();
                    if (!(world.rand.nextDouble() < 0.01) || block == Blocks.AIR && !world.getBlockState(pos.down()).getMaterial().isSolid() || block == this) continue;
                    EntityPlayer player = WitcheryUtils.getPlayer(world, fluid.thrower);
                    if (player == null) {
                        player = FakePlayerFactory.get((WorldServer)((WorldServer)world), (GameProfile)new GameProfile(fluid.thrower, null));
                    }
                    ModifiersEffect modifiers = modifiersEffect = new ModifiersEffect(1.0, 1.0, false, new Vec3d((Vec3i)pos), false, 0, player);
                    ++modifiersEffect.strengthPenalty;
                    WitcheryBrewEffects.applyToBlock(world, p2, direction.getOpposite(), 1, fluid.nbtEffect, modifiers);
                }
                world.scheduleUpdate(pos, (Block)this, this.tickRate);
            }
        }
    }

    public void onEntityCollision(World world, BlockPos pos, IBlockState state, Entity entity) {
        TileEntityMovingBrew liquid;
        if (entity instanceof EntityLivingBase && !world.isRemote && world.rand.nextInt(10) == 4 && (liquid = WitcheryTileEntities.MOVING_BREW.getAt((IBlockAccess)world, pos)) != null && liquid.nbtEffect != null) {
            EntityLivingBase living = (EntityLivingBase)entity;
            EntityPlayer player = WitcheryUtils.getPlayer(world, liquid.thrower);
            if (player == null) {
                player = FakePlayerFactory.get((WorldServer)((WorldServer)world), (GameProfile)new GameProfile(liquid.thrower, null));
            }
            WitcheryBrewEffects.applyToEntity(world, living, liquid.nbtEffect, new ModifiersEffect(0.25, 0.5, false, new Vec3d((Vec3i)pos), false, 0, player));
        }
    }

    @Nullable
    public TileEntity createNewTileEntity(World worldIn, int meta) {
        return WitcheryTileEntities.MOVING_BREW.create();
    }
}

