/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.BloodTrap;
import net.msrandom.witchery.block.entity.TileEntityLeechChest;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import org.jetbrains.annotations.Nullable;

public class BlockLeechChest
extends BlockContainer
implements BloodTrap {
    public static final PropertyDirection FACING = BlockHorizontal.FACING;
    private static final AxisAlignedBB DEFAULT_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.875, 0.9375);
    private static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0, 0.9375, 0.875, 0.9375);
    private static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.875, 1.0);
    private static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0625, 0.9375, 0.875, 0.9375);
    private static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 1.0, 0.875, 0.9375);

    public BlockLeechChest() {
        super(Material.ROCK);
        this.setCreativeTab(WitcheryGeneralItems.TAB);
        this.setDefaultState(this.getBlockState().getBaseState().withProperty((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.setHardness(25.0f);
        this.setResistance(1000.0f);
    }

    public static boolean isOcelotBlockingChest(World world, BlockPos pos) {
        for (EntityOcelot entityocelot : world.getEntitiesWithinAABB(EntityOcelot.class, new AxisAlignedBB((double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ(), (double)(pos.getX() + 1), (double)(pos.getY() + 2), (double)(pos.getZ() + 1)))) {
            if (!entityocelot.isSitting()) continue;
            return true;
        }
        return false;
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return false;
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (source.getBlockState(pos.north()).getBlock() == this) {
            return NORTH_AABB;
        }
        if (source.getBlockState(pos.south()).getBlock() == this) {
            return SOUTH_AABB;
        }
        if (source.getBlockState(pos.west()).getBlock() == this) {
            return WEST_AABB;
        }
        if (source.getBlockState(pos.east()).getBlock() == this) {
            return EAST_AABB;
        }
        return DEFAULT_AABB;
    }

    public IBlockState getStateForPlacement(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.getDefaultState().withProperty((IProperty)FACING, (Comparable)placer.getHorizontalFacing());
    }

    public void onBlockPlacedBy(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        BlockPos north = pos.north();
        BlockPos south = pos.south();
        BlockPos west = pos.west();
        BlockPos east = pos.east();
        Block northBlock = world.getBlockState(north).getBlock();
        Block southBlock = world.getBlockState(south).getBlock();
        Block westBlock = world.getBlockState(west).getBlock();
        Block eastBlock = world.getBlockState(east).getBlock();
        IBlockState currentState = state.withProperty((IProperty)FACING, (Comparable)placer.getHorizontalFacing().getOpposite());
        if (northBlock != this && southBlock != this && westBlock != this && eastBlock != this) {
            world.setBlockState(pos, state, 3);
        } else {
            if (!(northBlock != this && southBlock != this || currentState.getValue((IProperty)FACING) != EnumFacing.WEST && currentState.getValue((IProperty)FACING) != EnumFacing.EAST)) {
                if (northBlock == this) {
                    world.setBlockState(north, currentState, 3);
                } else {
                    world.setBlockState(south, currentState, 3);
                }
                world.setBlockState(pos, currentState, 3);
            }
            if (!(westBlock != this && eastBlock != this || currentState.getValue((IProperty)FACING) != EnumFacing.NORTH && currentState.getValue((IProperty)FACING) != EnumFacing.SOUTH)) {
                if (westBlock == this) {
                    world.setBlockState(north, currentState, 3);
                } else {
                    world.setBlockState(south, currentState, 3);
                }
                world.setBlockState(pos, currentState, 3);
            }
        }
        TileEntity tile = world.getTileEntity(pos);
        if (tile instanceof TileEntityLeechChest) {
            TileEntityLeechChest chest = (TileEntityLeechChest)tile;
            if (stack.hasDisplayName()) {
                chest.setChestGuiName(stack.getDisplayName());
            }
            if (!world.isRemote && stack.hasTagCompound()) {
                chest.readPlayers(stack.getTagCompound());
            }
        }
    }

    public IBlockState getStateFromMeta(int meta) {
        EnumFacing enumfacing = EnumFacing.byIndex((int)meta);
        if (enumfacing.getAxis() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.getDefaultState().withProperty((IProperty)FACING, (Comparable)enumfacing);
    }

    public int getMetaFromState(IBlockState state) {
        return ((EnumFacing)state.getValue((IProperty)FACING)).getIndex();
    }

    public IBlockState withRotation(IBlockState state, Rotation rot) {
        return state.withProperty((IProperty)FACING, (Comparable)rot.rotate((EnumFacing)state.getValue((IProperty)FACING)));
    }

    public IBlockState withMirror(IBlockState state, Mirror mirrorIn) {
        return state.withRotation(mirrorIn.toRotation((EnumFacing)state.getValue((IProperty)FACING)));
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{FACING}).build();
    }

    public boolean canPlaceBlockAt(World worldIn, BlockPos pos) {
        return true;
    }

    public void neighborChanged(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.neighborChanged(state, worldIn, pos, blockIn, fromPos);
        TileEntity tile = worldIn.getTileEntity(pos);
        if (tile instanceof TileEntityLeechChest) {
            TileEntityLeechChest tileentitychest = (TileEntityLeechChest)tile;
            tileentitychest.updateContainingBlockInfo();
        }
    }

    public void breakBlock(World worldIn, BlockPos pos, IBlockState state) {
        TileEntityLeechChest chest = WitcheryTileEntities.LEECH_CHEST.getAt((IBlockAccess)worldIn, pos);
        if (chest != null) {
            InventoryHelper.dropInventoryItems((World)worldIn, (BlockPos)pos, (IInventory)chest);
            worldIn.updateComparatorOutputLevel(pos, (Block)this);
        }
        super.breakBlock(worldIn, pos, state);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return Collections.emptyList();
    }

    public void onBlockHarvested(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (!world.isRemote) {
            ItemStack stack = new ItemStack((Block)this);
            TileEntityLeechChest chest = WitcheryTileEntities.LEECH_CHEST.getAt((IBlockAccess)world, pos);
            if (chest != null) {
                NBTTagCompound tag = new NBTTagCompound();
                chest.writePlayers(tag);
                stack.setTagCompound(tag);
            }
            this.dropBlockAsItem(world, pos, state, 0);
        }
    }

    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.isRemote) {
            return true;
        }
        IInventory iinventory = this.getInventory(world, pos);
        if (iinventory != null && !this.handleItem(world, WitcheryTileEntities.LEECH_CHEST.getAt((IBlockAccess)world, pos), player, hand)) {
            player.displayGUIChest(iinventory);
        }
        return true;
    }

    public IInventory getInventory(World world, BlockPos pos) {
        TileEntity object = world.getTileEntity(pos);
        if (object == null) {
            return null;
        }
        if (world.isSideSolid(pos.up(), EnumFacing.DOWN)) {
            return null;
        }
        if (BlockLeechChest.isOcelotBlockingChest(world, pos)) {
            return null;
        }
        if (world.getBlockState(pos.west()).getBlock() == this && (world.isSideSolid(pos.add(-1, 1, 0), EnumFacing.DOWN) || BlockLeechChest.isOcelotBlockingChest(world, pos.west()))) {
            return null;
        }
        if (world.getBlockState(pos.east()).getBlock() == this && (world.isSideSolid(pos.add(1, 1, 0), EnumFacing.DOWN) || BlockLeechChest.isOcelotBlockingChest(world, pos.east()))) {
            return null;
        }
        if (world.getBlockState(pos.north()).getBlock() == this && (world.isSideSolid(pos.add(0, 1, -1), EnumFacing.DOWN) || BlockLeechChest.isOcelotBlockingChest(world, pos.north()))) {
            return null;
        }
        if (world.getBlockState(pos.south()).getBlock() == this && (world.isSideSolid(pos.add(0, 1, 1), EnumFacing.DOWN) || BlockLeechChest.isOcelotBlockingChest(world, pos.south()))) {
            return null;
        }
        return (IInventory)object;
    }

    public boolean canProvidePower(IBlockState state) {
        return true;
    }

    public int getWeakPower(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (!this.canProvidePower(blockState)) {
            return 0;
        }
        TileEntity tile = blockAccess.getTileEntity(pos);
        if (tile instanceof TileEntityLeechChest) {
            int i1 = ((TileEntityLeechChest)tile).numPlayersUsing;
            return MathHelper.clamp((int)i1, (int)0, (int)15);
        }
        return 0;
    }

    public int getStrongPower(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.UP ? this.getWeakPower(blockState, blockAccess, pos, side) : 0;
    }

    public boolean hasComparatorInputOverride(IBlockState state) {
        return true;
    }

    public int getComparatorInputOverride(IBlockState blockState, World world, BlockPos pos) {
        return Container.calcRedstoneFromInventory((IInventory)this.getInventory(world, pos));
    }

    @Nullable
    public TileEntity createNewTileEntity(World worldIn, int meta) {
        return WitcheryTileEntities.LEECH_CHEST.create();
    }
}

