/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import net.minecraft.block.BlockLilyPad;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;

public class BlockLeapingLily
extends BlockLilyPad {
    public BlockLeapingLily() {
        this.setHardness(0.0f);
        this.setLightLevel(0.4f);
        this.setSoundType(SoundType.PLANT);
        this.setCreativeTab(WitcheryGeneralItems.TAB);
    }

    protected boolean canSustainBush(IBlockState block) {
        return block.getMaterial().isSolid() || block.getMaterial() == Material.WATER;
    }

    public boolean canPlaceBlockAt(World par1World, BlockPos pos) {
        Material material = par1World.getBlockState(pos).getMaterial();
        return super.canPlaceBlockAt(par1World, pos) && !material.isLiquid() && this.canBlockStay(par1World, pos);
    }

    public boolean canBlockStay(World world, BlockPos pos) {
        Material material = world.getBlockState(pos.down()).getMaterial();
        return (material.isSolid() || material.isLiquid()) && world.isAirBlock(pos.up());
    }

    public void onEntityCollision(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!world.isRemote && entity instanceof EntityLivingBase) {
            EntityLivingBase livingEntity = (EntityLivingBase)entity;
            if (!livingEntity.isPotionActive(MobEffects.SPEED)) {
                livingEntity.addPotionEffect(new PotionEffect(MobEffects.SPEED, 10, 0));
            }
            if (!livingEntity.isPotionActive(MobEffects.JUMP_BOOST)) {
                livingEntity.addPotionEffect(new PotionEffect(MobEffects.JUMP_BOOST, 10, 4));
            }
        }
    }
}

