/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.entity.TileEntityKettle;
import net.msrandom.witchery.entity.familiar.Familiars;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.data.WitcheryFamiliars;
import net.msrandom.witchery.init.data.recipes.WitcheryRecipeTypes;
import net.msrandom.witchery.init.items.WitcheryBrewItems;
import net.msrandom.witchery.init.items.WitcheryEquipmentItems;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.recipe.KettleRecipe;
import net.msrandom.witchery.util.BlockUtil;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.Nullable;

public class BlockKettle
extends BlockContainer {
    public static final PropertyDirection FACING = BlockHorizontal.FACING;
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.0625, 0.0625, 0.0625, 0.9375, 0.9375, 0.9375);

    public BlockKettle() {
        super(Material.ANVIL);
        this.setDefaultState(this.getBlockState().getBaseState().withProperty((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.setHardness(2.0f);
        this.setSoundType(SoundType.METAL);
        this.setCreativeTab(WitcheryGeneralItems.TAB);
    }

    @Nonnull
    private static ItemStack consumeItem(ItemStack stack) {
        if (stack.getItem().hasContainerItem(stack)) {
            return stack.getItem().getContainerItem(stack);
        }
        return stack;
    }

    public AxisAlignedBB getCollisionBoundingBox(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return AABB;
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public IBlockState getStateForPlacement(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.getDefaultState().withProperty((IProperty)FACING, (Comparable)placer.getHorizontalFacing().getOpposite());
    }

    public void onBlockPlacedBy(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.setBlockState(pos, state.withProperty((IProperty)FACING, (Comparable)placer.getHorizontalFacing().getOpposite()), 2);
    }

    public IBlockState getStateFromMeta(int meta) {
        EnumFacing enumfacing = EnumFacing.byIndex((int)meta);
        if (enumfacing.getAxis() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.getDefaultState().withProperty((IProperty)FACING, (Comparable)enumfacing);
    }

    public int getMetaFromState(IBlockState state) {
        return ((EnumFacing)state.getValue((IProperty)FACING)).getIndex();
    }

    public IBlockState withRotation(IBlockState state, Rotation rot) {
        return state.withProperty((IProperty)FACING, (Comparable)rot.rotate((EnumFacing)state.getValue((IProperty)FACING)));
    }

    public IBlockState withMirror(IBlockState state, Mirror mirrorIn) {
        return state.withRotation(mirrorIn.toRotation((EnumFacing)state.getValue((IProperty)FACING)));
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{FACING}).build();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(IBlockState stateIn, World world, BlockPos pos, Random rand) {
        TileEntityKettle tileEntity = WitcheryTileEntities.KETTLE.getAt((IBlockAccess)world, pos);
        if (tileEntity != null) {
            double d0 = (float)pos.getX() + 0.45f;
            double d2 = (float)pos.getY() + 0.4f;
            double d3 = (float)pos.getZ() + 0.5f;
            if (tileEntity.isRuined()) {
                world.spawnParticle(EnumParticleTypes.SMOKE_LARGE, d0, d2, d3, 0.0, 0.0, 0.0, new int[0]);
            } else if (tileEntity.isReady()) {
                world.spawnParticle(EnumParticleTypes.SLIME, d0, d2, d3, 0.0, 0.0, 0.0, new int[0]);
                if (tileEntity.isPowered) {
                    world.spawnParticle(EnumParticleTypes.SPELL, d0, d2, d3, 0.0, 0.0, 0.0, new int[0]);
                } else {
                    world.spawnParticle(EnumParticleTypes.SPELL_MOB, d0, d2, d3, 0.0, 0.0, 0.0, new int[0]);
                }
            } else if (tileEntity.isBrewing()) {
                world.spawnParticle(EnumParticleTypes.SPELL_MOB, d0, d2, d3, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public boolean tryFillWith(World world, BlockPos pos, FluidStack fluidStack) {
        if (world.isRemote) {
            return true;
        }
        TileEntityKettle tile = WitcheryTileEntities.KETTLE.getAt((IBlockAccess)world, pos);
        if (tile == null) {
            return false;
        }
        if (tile.canFill(fluidStack.getFluid())) {
            int qty = tile.fill(fluidStack, true);
            fluidStack.amount -= qty;
            if (fluidStack.amount < 0) {
                fluidStack.amount = 0;
            }
            if (qty > 0) {
                BlockUtil.notifyBlockUpdate(world, pos);
                world.playSound(null, pos, SoundEvents.ENTITY_PLAYER_SWIM, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
            }
            return qty > 0;
        }
        return false;
    }

    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack current = player.getHeldItem(hand);
        if (!current.isEmpty()) {
            FluidStack available;
            TileEntity tile = world.getTileEntity(pos);
            if (!(tile instanceof TileEntityKettle)) {
                return false;
            }
            TileEntityKettle tank = (TileEntityKettle)tile;
            if (current.getItem() == Items.GLASS_BOTTLE && tank.isReady()) {
                Optional<KettleRecipe> recipe = WitcheryUtils.getRecipeManager(world).getRecipe(WitcheryRecipeTypes.KETTLE, tank, world);
                if (recipe.isPresent() && (recipe.get().getFamiliarPower() == null || Familiars.hasFamiliarPower(player, recipe.get().getFamiliarPower()))) {
                    tank.setConsumeBottle(false);
                    ItemStack stack = tank.decrStackSize(6, 1);
                    tank.setConsumeBottle(true);
                    double bonusChance = 0.0;
                    double bonusChance2 = 0.0;
                    if (player.getItemStackFromSlot(EntityEquipmentSlot.HEAD).getItem() == WitcheryEquipmentItems.WITCH_HAT) {
                        bonusChance += 0.35;
                    } else if (player.getItemStackFromSlot(EntityEquipmentSlot.HEAD).getItem() == WitcheryEquipmentItems.BABAS_HAT) {
                        bonusChance += 0.25;
                        bonusChance2 += 0.25;
                    }
                    if (stack.getItem() != WitcheryBrewItems.RAISING_BREW && WitcheryEquipmentItems.WITCH_ROBES.isRobeWorn(player)) {
                        bonusChance += 0.35;
                    } else if (stack.getItem() == WitcheryBrewItems.RAISING_BREW && WitcheryEquipmentItems.NECROMANCERS_ROBES.isRobeWorn(player)) {
                        bonusChance += 0.35;
                    }
                    if (Familiars.hasFamiliarPower(player, WitcheryFamiliars.BREW_MASTERY)) {
                        bonusChance += 0.05;
                        if (player.getItemStackFromSlot(EntityEquipmentSlot.HEAD).getItem() == WitcheryEquipmentItems.BABAS_HAT) {
                            bonusChance2 += 0.05;
                        }
                    }
                    if (bonusChance > 0.0 && world.rand.nextDouble() <= bonusChance) {
                        stack.grow(recipe.get().getHatBonus());
                    }
                    if (bonusChance2 > 0.0 && world.rand.nextDouble() <= bonusChance2) {
                        stack.grow(recipe.get().getHatBonus());
                    }
                    if (!world.isRemote) {
                        if (!player.capabilities.isCreativeMode) {
                            current.shrink(1);
                        }
                        if (current.isEmpty()) {
                            player.setHeldItem(hand, stack);
                        } else if (!player.inventory.addItemStackToInventory(stack)) {
                            player.dropItem(stack, false);
                        }
                    }
                    world.playSound(null, player.getPosition(), SoundEvents.ENTITY_PLAYER_SWIM, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                }
                return true;
            }
            IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)current);
            if (fluidHandler != null) {
                FluidStack liquid = fluidHandler.drain(1000, false);
                if (!tank.isFilled() && liquid != null && tank.canFill(liquid.getFluid())) {
                    int filling = tank.fill(fluidHandler.drain(liquid, true), true);
                    tank.reset(false);
                    if (filling != 0 && !player.capabilities.isCreativeMode) {
                        player.setHeldItem(hand, BlockKettle.consumeItem(current));
                    }
                    world.playSound(null, player.getPosition(), SoundEvents.ENTITY_PLAYER_SWIM, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                    return true;
                }
            }
            if ((available = tank.getTankProperties()[0].getContents()) != null) {
                int quantity;
                if (current.getItem() == Items.BUCKET) {
                    ItemStack filled = FluidUtil.getFilledBucket((FluidStack)available);
                    FluidStack liquid = FluidUtil.getFluidContained((ItemStack)filled);
                    if (liquid != null) {
                        if (!player.capabilities.isCreativeMode) {
                            if (current.getCount() > 1) {
                                if (!player.inventory.addItemStackToInventory(filled)) {
                                    return false;
                                }
                                current.shrink(1);
                            } else {
                                player.setHeldItem(hand, filled);
                            }
                        }
                        tank.drain(liquid.amount, true);
                        tank.reset(false);
                        world.playSound(null, player.getPosition(), SoundEvents.ENTITY_PLAYER_SWIM, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                        return true;
                    }
                } else if (fluidHandler != null && (quantity = fluidHandler.fill(available, false)) > 0) {
                    fluidHandler.fill(tank.drain(quantity, true), true);
                }
            }
        }
        return false;
    }

    public void onEntityCollision(World world, BlockPos pos, IBlockState state, Entity entity) {
        TileEntityKettle tileEntity;
        if (!world.isRemote && entity instanceof EntityItem && (tileEntity = (TileEntityKettle)world.getTileEntity(pos)) != null) {
            EntityItem itemEntity = (EntityItem)entity;
            if (itemEntity.getItem().getItem() == Items.GLASS_BOTTLE) {
                ItemStack stack = tileEntity.getStackInSlot(7);
                if (stack.isEmpty()) {
                    tileEntity.setInventorySlotContents(7, itemEntity.getItem());
                    itemEntity.setDead();
                } else if (stack.getCount() + itemEntity.getItem().getCount() <= tileEntity.getInventoryStackLimit()) {
                    stack.grow(itemEntity.getItem().getCount());
                    tileEntity.setInventorySlotContents(7, stack);
                    itemEntity.setDead();
                }
            } else if (tileEntity.isFilled()) {
                boolean spaceFound = false;
                for (int i = 0; i < tileEntity.getSizeInventory() - 2; ++i) {
                    if (!tileEntity.getStackInSlot(i).isEmpty()) continue;
                    tileEntity.setInventorySlotContents(i, itemEntity.getItem());
                    spaceFound = true;
                    break;
                }
                if (!spaceFound && !tileEntity.isRuined()) {
                    tileEntity.setRuined();
                }
                itemEntity.setDead();
                world.playSound(null, pos, SoundEvents.ENTITY_PLAYER_SPLASH, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)pos.getX() + 0.5, (double)pos.getY() + 0.2, (double)pos.getZ() + 0.5, 0.5f, 0.5f, EnumParticleTypes.WATER_SPLASH), world, pos, 5.0);
            }
        }
    }

    @Nullable
    public TileEntity createNewTileEntity(World worldIn, int meta) {
        return WitcheryTileEntities.KETTLE.create();
    }
}

