/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.msrandom.witchery.block.BloodTrap;
import net.msrandom.witchery.block.WitcheryBlockDoor;
import net.msrandom.witchery.block.entity.TileEntityBloodTrap;
import net.msrandom.witchery.init.WitcheryTileEntities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J0\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0010H\u0016JP\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u001dH\u0016\u00a8\u0006 "}, d2={"Lnet/msrandom/witchery/block/BlockHawthornDoor;", "Lnet/msrandom/witchery/block/WitcheryBlockDoor;", "Lnet/msrandom/witchery/block/BloodTrap;", "()V", "breakBlock", "", "world", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "state", "Lnet/minecraft/block/state/IBlockState;", "createNewTileEntity", "Lnet/msrandom/witchery/block/entity/TileEntityBloodTrap;", "worldIn", "meta", "", "eventReceived", "", "id", "param", "onBlockActivated", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "hand", "Lnet/minecraft/util/EnumHand;", "facing", "Lnet/minecraft/util/EnumFacing;", "hitX", "", "hitY", "hitZ", "WitcheryResurrected"})
public final class BlockHawthornDoor
extends WitcheryBlockDoor
implements BloodTrap {
    public boolean onBlockActivated(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState state, @NotNull EntityPlayer player, @NotNull EnumHand hand, @NotNull EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState lowerState;
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)hand, (String)"hand");
        Intrinsics.checkParameterIsNotNull((Object)facing, (String)"facing");
        BlockPos lowerPos = (BlockDoor.EnumDoorHalf)state.getValue((IProperty)BlockDoor.HALF) == BlockDoor.EnumDoorHalf.LOWER ? pos : pos.down();
        IBlockState iBlockState = lowerState = Intrinsics.areEqual((Object)pos, (Object)lowerPos) ? state : world.getBlockState(lowerPos);
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"lowerState");
        if (iBlockState.getBlock() != this) {
            return false;
        }
        IBlockAccess iBlockAccess = (IBlockAccess)world;
        BlockPos blockPos = lowerPos;
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"lowerPos");
        this.handleItem(world, WitcheryTileEntities.BLOOD_TRAP.getAt(iBlockAccess, blockPos), player, hand);
        return super.onBlockActivated(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    public void breakBlock(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState state) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        super.breakBlock(world, pos, state);
        world.removeTileEntity(pos);
    }

    public boolean eventReceived(@NotNull IBlockState state, @NotNull World world, @NotNull BlockPos pos, int id, int param) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        TileEntity tileEntity = world.getTileEntity(pos);
        return tileEntity != null ? tileEntity.receiveClientEvent(id, param) : false;
    }

    @Nullable
    public TileEntityBloodTrap createNewTileEntity(@NotNull World worldIn, int meta) {
        Intrinsics.checkParameterIsNotNull((Object)worldIn, (String)"worldIn");
        return WitcheryTileEntities.BLOOD_TRAP.create();
    }

    public BlockHawthornDoor() {
        Material material = Material.WOOD;
        Intrinsics.checkExpressionValueIsNotNull((Object)material, (String)"Material.WOOD");
        super(material);
        this.hasTileEntity = true;
    }
}

