/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;

public class BlockGlintWeed
extends BlockBush {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.050000011920928955, 0.0, 0.050000011920928955, (double)0.95f, 1.0, (double)0.95f);

    public BlockGlintWeed() {
        super(Material.PLANTS);
        this.setLightLevel(0.9375f);
        this.setHardness(0.0f);
        this.setSoundType(SoundType.PLANT);
        this.disableStats();
        this.setTickRandomly(true);
        this.setCreativeTab(WitcheryGeneralItems.TAB);
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public void updateTick(World par1World, BlockPos pos, IBlockState state, Random par5Random) {
        if (!par1World.isRemote && par1World.rand.nextInt(6) == 0) {
            int b0 = 4;
            int l = 5;
            for (int i1 = pos.getX() - b0; i1 <= pos.getX() + b0; ++i1) {
                for (int j1 = pos.getZ() - b0; j1 <= pos.getZ() + b0; ++j1) {
                    for (int k1 = pos.getY() - 1; k1 <= pos.getY() + 1; ++k1) {
                        if (par1World.getBlockState(new BlockPos(i1, k1, j1)).getBlock() != this || --l > 0) continue;
                        return;
                    }
                }
            }
            BlockPos p1 = pos.add(par5Random.nextInt(3) - 1, par5Random.nextInt(2) - par5Random.nextInt(2), par5Random.nextInt(3) - 1);
            for (int l2 = 0; l2 < 4; ++l2) {
                if (par1World.isAirBlock(p1) && this.canBlockSpread(par1World, p1)) {
                    pos = p1;
                }
                p1 = pos.add(par5Random.nextInt(3) - 1, par5Random.nextInt(2) - par5Random.nextInt(2), par5Random.nextInt(3) - 1);
            }
            if (par1World.isAirBlock(p1) && this.canBlockSpread(par1World, p1)) {
                par1World.setBlockState(p1, state, 2);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(IBlockState stateIn, World world, BlockPos pos, Random rand) {
        double d0 = (float)pos.getX() + 0.4f + (float)rand.nextInt(3) * 0.1f;
        double d2 = (float)pos.getY() + 0.4f + (float)rand.nextInt(3) * 0.1f;
        double d3 = (float)pos.getZ() + 0.4f + (float)rand.nextInt(3) * 0.1f;
        world.spawnParticle(EnumParticleTypes.FLAME, d0, d2, d3, 0.0, 0.0, 0.0, new int[0]);
    }

    public boolean canPlaceBlockAt(World par1World, BlockPos pos) {
        return super.canPlaceBlockAt(par1World, pos) && this.canBlockStay(par1World, pos);
    }

    protected boolean canSustainBush(IBlockState block) {
        return block != null && block.isOpaqueCube();
    }

    public boolean canBlockSpread(World world, BlockPos pos) {
        Block block = world.getBlockState(pos.down()).getBlock();
        return this.canBlockStay(world, pos) && (block == Blocks.DIRT || block == Blocks.GRASS || block == Blocks.MYCELIUM || block == Blocks.SAND || block == Blocks.FARMLAND);
    }

    public boolean canBlockStay(World world, BlockPos pos) {
        Material material = world.getBlockState(pos.down()).getMaterial();
        Material material2 = world.getBlockState(pos.up()).getMaterial();
        return material != null && material.isSolid() || material2.isSolid();
    }
}

