/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.TileEntityMovingBrew;
import net.msrandom.witchery.brewing.ModifiersEffect;
import net.msrandom.witchery.init.WitcheryPotionEffects;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.data.brewing.WitcheryBrewEffects;
import net.msrandom.witchery.util.WitcheryUtils;

public class BlockGasBrew
extends BlockContainer {
    public static final Material MATERIAL = new Material(MapColor.AIR){

        public boolean isSolid() {
            return false;
        }

        public boolean blocksMovement() {
            return false;
        }
    }.setReplaceable();
    public static final PropertyInteger EXTENT = PropertyInteger.create((String)"extent", (int)0, (int)10);

    public BlockGasBrew() {
        super(MATERIAL);
        this.setTickRandomly(true);
        this.disableStats();
        this.setBlockUnbreakable();
    }

    public AxisAlignedBB getCollisionBoundingBox(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return NULL_AABB;
    }

    public boolean isAir(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public boolean canCollideCheck(IBlockState p_149678_1_, boolean p_149678_2_) {
        return false;
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public Item getItemDropped(IBlockState metadata, Random rand, int fortune) {
        return Items.AIR;
    }

    public int quantityDropped(Random par1Random) {
        return 0;
    }

    public int tickRate(World world) {
        return 5;
    }

    public boolean shouldSideBeRendered(IBlockState blockState, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return world.getBlockState(pos.offset(side)).getBlock() != this && super.shouldSideBeRendered(blockState, world, pos, side);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return ItemStack.EMPTY;
    }

    public void onBlockAdded(World worldIn, BlockPos pos, IBlockState state) {
        worldIn.scheduleUpdate(pos, (Block)this, 5);
    }

    public void neighborChanged(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.onBlockAdded(world, pos, state);
    }

    public void updateTick(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.isRemote) {
            int initialMetadata = (Integer)state.getValue((IProperty)EXTENT);
            TileEntityMovingBrew oldTile = WitcheryTileEntities.MOVING_BREW.getAt((IBlockAccess)world, pos);
            if (oldTile == null) {
                world.setBlockToAir(pos);
                return;
            }
            int maxMeta = oldTile.expansion;
            if (oldTile.incRunTicks() > 120) {
                world.setBlockToAir(pos);
                return;
            }
            if (initialMetadata >= maxMeta) {
                if (oldTile.duration == 0 || oldTile.duration > 0 && rand.nextInt(oldTile.duration) == 0) {
                    world.setBlockToAir(pos);
                    return;
                }
            } else {
                double[] pb = new double[]{0.2, 0.4, 0.8, 0.8, 0.8, 0.8};
                boolean expanded = false;
                for (int i = 0; i < pb.length; ++i) {
                    BlockPos n;
                    Block block;
                    if (!(rand.nextDouble() < pb[i]) || (block = world.getBlockState(n = pos.offset(EnumFacing.values()[i])).getBlock()) != Blocks.AIR && block != Blocks.SNOW_LAYER) continue;
                    world.setBlockState(n, state.withProperty((IProperty)EXTENT, (Comparable)Integer.valueOf(Math.min(initialMetadata + 1, maxMeta))), 3);
                    TileEntityMovingBrew newTile = WitcheryTileEntities.MOVING_BREW.getAt((IBlockAccess)world, n);
                    newTile.nbtEffect = oldTile.nbtEffect.copy();
                    newTile.expansion = oldTile.expansion;
                    newTile.duration = oldTile.duration;
                    newTile.thrower = oldTile.thrower;
                    expanded = true;
                }
                if (expanded) {
                    world.setBlockState(pos, state.withProperty((IProperty)EXTENT, (Comparable)Integer.valueOf(Math.min(initialMetadata + 1, maxMeta))), 3);
                }
            }
            world.scheduleUpdate(pos, (Block)this, 5);
        }
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty((IProperty)EXTENT, (Comparable)Integer.valueOf(meta));
    }

    public int getMetaFromState(IBlockState state) {
        return (Integer)state.getValue((IProperty)EXTENT);
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{EXTENT}).build();
    }

    public void onEntityCollision(World world, BlockPos pos, IBlockState state, Entity entity) {
        TileEntityMovingBrew gas;
        if (entity instanceof EntityLivingBase && !world.isRemote && world.rand.nextInt(10) == 4 && (gas = WitcheryTileEntities.MOVING_BREW.getAt((IBlockAccess)world, pos)) != null && gas.nbtEffect != null) {
            EntityLivingBase living = (EntityLivingBase)entity;
            ModifiersEffect modifiers = new ModifiersEffect(0.25, 0.5, false, new Vec3d((Vec3i)pos), false, 0, WitcheryUtils.getPlayer(world, gas.thrower));
            modifiers.protectedFromNegativePotions = living.isPotionActive(WitcheryPotionEffects.GAS_MASK);
            WitcheryBrewEffects.applyToEntity(world, living, gas.nbtEffect, modifiers);
        }
    }

    public EnumBlockRenderType getRenderType(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public BlockRenderLayer getRenderLayer() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @Nullable
    public TileEntity createNewTileEntity(World worldIn, int meta) {
        return WitcheryTileEntities.MOVING_BREW.create();
    }
}

