/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.entity.EntityVampire;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.WitcheryTransformations;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.rite.effect.RiteEffectProtectionCircleRepulsive;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.Nullable;

public class BlockGarlicGarland
extends BlockContainer {
    public static final PropertyDirection FACING = BlockHorizontal.FACING;
    private static final AxisAlignedBB DEFAULT_AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.5, 0.75);
    private static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB((double)0.1f, (double)0.8f, 1.0, (double)0.85f, 1.0, (double)0.9f);
    private static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.10000002384185791, (double)0.8f, 0.0, (double)0.9f, 1.0, (double)0.15f);
    private static final AxisAlignedBB WEST_AABB = new AxisAlignedBB((double)0.85f, (double)0.8f, (double)0.1f, (double)0.9f, 1.0, 1.0);
    private static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.0, (double)0.8f, (double)0.1f, (double)0.15f, 1.0, (double)0.9f);

    public BlockGarlicGarland() {
        super(Material.CIRCUITS);
        this.setHardness(0.2f);
        this.setCreativeTab(WitcheryGeneralItems.TAB);
    }

    public EnumBlockRenderType getRenderType(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockState blockState, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.getValue((IProperty)FACING)) {
            case NORTH: {
                return NORTH_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
            case EAST: {
                return EAST_AABB;
            }
        }
        return DEFAULT_AABB;
    }

    public AxisAlignedBB getCollisionBoundingBox(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return NULL_AABB;
    }

    public void onEntityCollision(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!world.isRemote && entity instanceof EntityVampire) {
            RiteEffectProtectionCircleRepulsive.push(entity, pos);
        } else if (world.isRemote && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (!player.capabilities.isCreativeMode && WitcheryUtils.getExtension((EntityPlayer)entity).isTransformation(WitcheryTransformations.VAMPIRE)) {
                RiteEffectProtectionCircleRepulsive.push(entity, pos, false);
            }
        }
    }

    public IBlockState getStateForPlacement(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.getDefaultState().withProperty((IProperty)FACING, (Comparable)placer.getHorizontalFacing().getOpposite());
    }

    public void onBlockPlacedBy(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.setBlockState(pos, state.withProperty((IProperty)FACING, (Comparable)EnumFacing.byHorizontalIndex((int)(MathHelper.floor((double)((double)(placer.rotationYaw * 4.0f / 360.0f) + 0.5)) & 3))), 2);
    }

    public IBlockState getStateFromMeta(int meta) {
        EnumFacing enumfacing = EnumFacing.byIndex((int)meta);
        if (enumfacing.getAxis() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.getDefaultState().withProperty((IProperty)FACING, (Comparable)enumfacing);
    }

    public int getMetaFromState(IBlockState state) {
        return ((EnumFacing)state.getValue((IProperty)FACING)).getIndex();
    }

    public IBlockState withRotation(IBlockState state, Rotation rot) {
        return state.withProperty((IProperty)FACING, (Comparable)rot.rotate((EnumFacing)state.getValue((IProperty)FACING)));
    }

    public IBlockState withMirror(IBlockState state, Mirror mirrorIn) {
        return state.withRotation(mirrorIn.toRotation((EnumFacing)state.getValue((IProperty)FACING)));
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{FACING}).build();
    }

    @Nullable
    public TileEntity createNewTileEntity(World worldIn, int meta) {
        return WitcheryTileEntities.INSTANCE.getGARLIC_GARLAND().create();
    }

    public static class TileEntityGarlicGarland
    extends TileEntity {
    }
}

