/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.block.BlockWitchesOven;
import net.msrandom.witchery.block.entity.TileEntityWitchesOven;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryContainers;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.util.WitcheryUtils;

public class BlockFumeFunnel
extends BlockHorizontal {
    public static final PropertyEnum<Connections> CONNECTIONS = PropertyEnum.create((String)"connections", Connections.class);
    public static final PropertyBool ON = PropertyBool.create((String)"on");
    private final boolean filtered;

    public BlockFumeFunnel(boolean filtered) {
        super(Material.IRON);
        this.setDefaultState(this.getBlockState().getBaseState().withProperty((IProperty)FACING, (Comparable)EnumFacing.NORTH).withProperty(CONNECTIONS, (Comparable)((Object)Connections.NONE)).withProperty((IProperty)ON, (Comparable)Boolean.valueOf(false)));
        this.filtered = filtered;
        this.setHardness(3.5f);
        this.setSoundType(SoundType.METAL);
        this.setCreativeTab(WitcheryGeneralItems.TAB);
    }

    public boolean isFiltered() {
        return this.filtered;
    }

    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.isRemote) {
            return true;
        }
        switch (((EnumFacing)state.getValue((IProperty)FACING)).getAxis()) {
            case Z: {
                if (BlockWitchesOven.isOven(world.getBlockState(pos.east()).getBlock())) {
                    pos = pos.east();
                    break;
                }
                if (BlockWitchesOven.isOven(world.getBlockState(pos.west()).getBlock())) {
                    pos = pos.west();
                    break;
                }
                if (!BlockWitchesOven.isOven(world.getBlockState(pos.down()).getBlock())) break;
                pos = pos.down();
                break;
            }
            case X: {
                if (BlockWitchesOven.isOven(world.getBlockState(pos.south()).getBlock())) {
                    pos = pos.south();
                    break;
                }
                if (BlockWitchesOven.isOven(world.getBlockState(pos.north()).getBlock())) {
                    pos = pos.north();
                    break;
                }
                if (!BlockWitchesOven.isOven(world.getBlockState(pos.down()).getBlock())) break;
                pos = pos.down();
            }
        }
        TileEntity te = world.getTileEntity(pos);
        if (te instanceof TileEntityWitchesOven) {
            WitcheryUtils.openContainer(WitcheryContainers.getWitchesOven(), player, pos, ((TileEntityWitchesOven)te).getDisplayName());
        }
        return true;
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public int quantityDropped(Random rand) {
        return 1;
    }

    public IBlockState getStateForPlacement(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.getDefaultState().withProperty((IProperty)FACING, (Comparable)placer.getHorizontalFacing().getOpposite());
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty((IProperty)FACING, (Comparable)EnumFacing.byHorizontalIndex((int)(meta & 3)));
    }

    public int getMetaFromState(IBlockState state) {
        return ((EnumFacing)state.getValue((IProperty)FACING)).getHorizontalIndex();
    }

    public IBlockState withRotation(IBlockState state, Rotation rotation) {
        return state.withProperty((IProperty)FACING, (Comparable)rotation.rotate((EnumFacing)state.getValue((IProperty)FACING)));
    }

    public IBlockState withMirror(IBlockState state, Mirror mirror) {
        return state.withRotation(mirror.toRotation((EnumFacing)state.getValue((IProperty)FACING)));
    }

    public void onBlockPlacedBy(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.setBlockState(pos, state.withProperty((IProperty)FACING, (Comparable)placer.getHorizontalFacing().getOpposite()));
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{FACING, CONNECTIONS, ON}).build();
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(IBlockState stateIn, World world, BlockPos pos, Random rand) {
        if (((Boolean)stateIn.getValue((IProperty)ON)).booleanValue()) {
            double d0 = (float)pos.getX() + 0.45f;
            double d2 = (float)pos.getY() + 0.4f;
            double d3 = (float)pos.getZ() + 0.5f;
            world.spawnParticle(EnumParticleTypes.SMOKE_NORMAL, d0, d2, d3, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public IBlockState getActualState(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumFacing facing = (EnumFacing)(state = super.getActualState(state, world, pos)).getValue((IProperty)FACING);
        EnumFacing ovenDirection = facing.getAxis() == EnumFacing.Axis.X ? EnumFacing.SOUTH : EnumFacing.EAST;
        IBlockState left = world.getBlockState(pos.offset(ovenDirection));
        IBlockState right = world.getBlockState(pos.offset(ovenDirection.getOpposite()));
        IBlockState down = world.getBlockState(pos.down());
        state = state.withProperty((IProperty)ON, (Comparable)Boolean.valueOf(left.getBlock() == WitcheryBlocks.WITCHES_OVEN_BURNING || right.getBlock() == WitcheryBlocks.WITCHES_OVEN_BURNING || down.getBlock() == WitcheryBlocks.WITCHES_OVEN_BURNING && down.getValue((IProperty)FACING) == facing));
        state = down.getBlock() instanceof BlockWitchesOven && down.getValue((IProperty)FACING) == facing ? state.withProperty(CONNECTIONS, (Comparable)((Object)Connections.TOP)) : (left.getBlock() instanceof BlockWitchesOven && left.getValue((IProperty)FACING) == facing ? (right.getBlock() instanceof BlockWitchesOven && right.getValue((IProperty)FACING) == facing ? state.withProperty(CONNECTIONS, (Comparable)((Object)Connections.SIDES)) : state.withProperty(CONNECTIONS, (Comparable)((Object)Connections.LEFT))) : (right.getBlock() instanceof BlockWitchesOven && right.getValue((IProperty)FACING) == facing ? state.withProperty(CONNECTIONS, (Comparable)((Object)Connections.RIGHT)) : state.withProperty(CONNECTIONS, (Comparable)((Object)Connections.NONE))));
        return state;
    }

    public static enum Connections implements IStringSerializable
    {
        NONE,
        RIGHT,
        LEFT,
        SIDES,
        TOP;


        public String getName() {
            return this.name().toLowerCase();
        }
    }
}

