/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class BlockForce
extends Block {
    private final boolean transparent;

    public BlockForce(boolean transparent) {
        super(Material.ROCK);
        this.transparent = transparent;
        this.setBlockUnbreakable();
        this.setResistance(9999.0f);
        this.setLightOpacity(0);
        this.setSoundType(transparent ? SoundType.GLASS : SoundType.STONE);
    }

    public EnumBlockRenderType getRenderType(IBlockState state) {
        return this.transparent ? EnumBlockRenderType.INVISIBLE : super.getRenderType(state);
    }

    protected boolean canSilkHarvest() {
        return false;
    }

    public int quantityDropped(Random rand) {
        return 0;
    }

    public boolean isOpaqueCube(IBlockState state) {
        return !this.transparent && super.isOpaqueCube(state);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return ItemStack.EMPTY;
    }
}

